/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.charging.common.dataitem;

import com.ericsson.charging.common.dataitem.AbstractDataItem;
import java.lang.reflect.Method;

public abstract class AbstractSingleDataItem
extends AbstractDataItem {
    Object myOriginalValue = null;

    public AbstractSingleDataItem(Object originalValue) {
        if (originalValue instanceof Cloneable || originalValue.getClass().isArray()) {
            try {
                Method cloneMethod = originalValue.getClass().getSuperclass().getDeclaredMethod("clone", new Class[0]);
                cloneMethod.setAccessible(true);
                this.myOriginalValue = cloneMethod.invoke(originalValue, (Object[])null);
            }
            catch (Exception e) {
                this.myOriginalValue = originalValue;
            }
        } else {
            this.myOriginalValue = originalValue;
        }
    }

    @Override
    public void reset() {
        this.myOriginalValue = this.getDataItem(null);
    }

    @Override
    public boolean isModified() {
        Object currentObj = this.getDataItem(null);
        if (this.myOriginalValue == null || currentObj == null) {
            return this.myOriginalValue != null || currentObj != null;
        }
        if (currentObj.getClass().isArray() || this.myOriginalValue.getClass().isArray()) {
            if (currentObj.getClass().isArray() && this.myOriginalValue.getClass().isArray()) {
                return this.arrayCompare((Object[])this.myOriginalValue, (Object[])currentObj);
            }
            return false;
        }
        return !this.myOriginalValue.equals(currentObj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean arrayCompare(Object[] original, Object[] current) {
        if (original.length != current.length) {
            return true;
        }
        if (original.getClass().isPrimitive() || current.getClass().isPrimitive()) {
            if (!original.getClass().isPrimitive() || !current.getClass().isPrimitive()) return true;
            for (int ii = 0; ii < original.length; ++ii) {
                if (original[ii] == current[ii]) continue;
                return true;
            }
            return false;
        } else {
            for (int ii = 0; ii < original.length; ++ii) {
                if (!(original[ii] == null || current[ii] == null ? original[ii] != null || current[ii] != null : !original[ii].equals(current[ii]))) continue;
                return true;
            }
        }
        return false;
    }
}

