/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.charging.common.documents;

import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class DecimalSignificantNumberDocument
extends PlainDocument
implements FieldValidation {
    int mySignificance = 15;
    double myMin = Double.NEGATIVE_INFINITY;
    double myMax = Double.POSITIVE_INFINITY;
    int myDecimals = 0;
    private StatusInterface myStatus = null;
    private boolean isEnabled = true;

    public DecimalSignificantNumberDocument() {
    }

    public DecimalSignificantNumberDocument(double min, double max, int decimals) {
        this.myMin = min;
        this.myMax = max;
        this.myDecimals = decimals;
    }

    public void setSignificance(int significance) {
        this.mySignificance = significance;
    }

    public int getSignificance() {
        return this.mySignificance;
    }

    public double getMinValue() {
        return this.myMin;
    }

    public void setMinValue(double v) {
        this.myMin = v;
    }

    public double getMaxValue() {
        return this.myMax;
    }

    public void setMaxValue(double v) {
        this.myMax = v;
    }

    public int getDecimalsValue() {
        return this.myDecimals;
    }

    public void setDecimalsValue(int v) {
        this.myDecimals = v;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        block22: {
            int ii;
            int minusPos;
            String significantNumbers;
            int exponentIndex;
            if (!this.isEnabled) {
                super.insertString(offs, str, a);
                return;
            }
            String numbersOnlyString = "";
            int start = 0;
            if (this.myMin < 0.0 && str.startsWith("-") && offs == 0) {
                numbersOnlyString = numbersOnlyString + "-";
                start = 1;
            }
            char[] chars = str.toCharArray();
            String currentText = this.getText(0, this.getLength());
            boolean periodExists = currentText.indexOf(46) != -1;
            boolean exponentExists = currentText.indexOf(101) != -1;
            for (int i = start; i < chars.length; ++i) {
                if (Character.isDigit(chars[i])) {
                    numbersOnlyString = numbersOnlyString + chars[i];
                    continue;
                }
                if (!(chars[i] != '.' && chars[i] != ',' || periodExists)) {
                    numbersOnlyString = numbersOnlyString + ".";
                    periodExists = true;
                    continue;
                }
                if (!(chars[i] != 'e' && chars[i] != 'E' || exponentExists)) {
                    numbersOnlyString = numbersOnlyString + "e";
                    continue;
                }
                if (chars[i] == '-' && numbersOnlyString.endsWith("e")) {
                    numbersOnlyString = numbersOnlyString + "-";
                    continue;
                }
                if (this.myStatus == null) continue;
                this.myStatus.beep();
                this.myStatus.printMessage("Only digits '0-9' and '.' allowed");
            }
            String beforeOffset = currentText.substring(0, offs);
            String afterOffset = currentText.substring(offs, currentText.length());
            String proposedResult = beforeOffset + numbersOnlyString + afterOffset;
            if (proposedResult.length() == 0) {
                return;
            }
            if (proposedResult.equals(".") || proposedResult.equals("-") || proposedResult.equals("-.")) {
                super.insertString(offs, numbersOnlyString, a);
                return;
            }
            int indexOfExponent = proposedResult.indexOf(101);
            if (indexOfExponent > -1) {
                String startStr = proposedResult.substring(0, indexOfExponent);
                String endStr = proposedResult.substring(indexOfExponent + 1);
                proposedResult = startStr + "e0" + endStr;
            }
            if ((exponentIndex = (significantNumbers = proposedResult).toLowerCase().indexOf("e")) >= 0) {
                significantNumbers = significantNumbers.substring(0, exponentIndex);
            }
            if ((minusPos = significantNumbers.indexOf(45)) >= 0) {
                significantNumbers = significantNumbers.substring(minusPos + 1);
            }
            for (int ii2 = significantNumbers.length() - 1; 0 <= ii2; --ii2) {
                if (significantNumbers.charAt(ii2) == '0') continue;
                significantNumbers = significantNumbers.substring(0, ii2 + 1);
                break;
            }
            int countDecimals = 0;
            boolean decimalsExists = false;
            for (ii = 0; ii < significantNumbers.length(); ++ii) {
                if (decimalsExists) {
                    ++countDecimals;
                }
                if (significantNumbers.charAt(ii) != '.' && significantNumbers.charAt(ii) != ',') continue;
                decimalsExists = true;
            }
            if (countDecimals > this.myDecimals) {
                this.myStatus.beep();
                this.myStatus.printMessage("Decimals, max " + this.myDecimals + " decimals are allowed");
                return;
            }
            for (ii = 0; ii < significantNumbers.length(); ++ii) {
                if (significantNumbers.charAt(ii) == '0' || significantNumbers.charAt(ii) == '.' || significantNumbers.charAt(ii) == ',' || this.mySignificance >= significantNumbers.length() - ii || this.myStatus == null) continue;
                this.myStatus.beep();
                this.myStatus.printMessage("Significance, max " + this.mySignificance + " digits are allowed");
                return;
            }
            try {
                double doubleProposedResult = Double.parseDouble(proposedResult);
                if (doubleProposedResult <= this.myMax && doubleProposedResult >= this.myMin) {
                    super.insertString(offs, numbersOnlyString, a);
                } else if (this.myStatus != null) {
                    this.myStatus.beep();
                    this.myStatus.printMessage("Number out of range, must be within " + this.myMin + " >= " + proposedResult + " <= " + this.myMax);
                }
            }
            catch (NumberFormatException e) {
                if (this.myStatus == null) break block22;
                this.myStatus.beep();
                this.myStatus.printMessage("Number out of range, must be within " + this.myMin + " >= value <= " + this.myMax);
            }
        }
    }

    @Override
    public boolean isValid(String value) {
        String v;
        String pattern;
        boolean valid = true;
        String msg = "";
        if (value == null) {
            valid = false;
            msg = "No digits, not a numeric value";
        }
        if (!Pattern.matches(pattern = "^[-+]?(\\d*[.,])?\\d+(e-?\\d+)?$", v = value.toLowerCase())) {
            valid = false;
            msg = "'" + value + "' is NOT Valid, only digits '0-9' and '.' allowed ";
        }
        try {
            int exp;
            if (v.startsWith("-")) {
                v = v.substring(1);
            }
            exp = (exp = v.indexOf(101)) < 0 ? v.length() : exp;
            v = v.substring(0, exp);
            v = v.replaceFirst("[.,]", "");
            while (v.startsWith("0")) {
                v = v.substring(1);
            }
            while (v.length() != 0 && v.endsWith("0")) {
                v = v.substring(0, v.length() - 1);
            }
            valid = v.length() <= this.mySignificance;
        }
        catch (NumberFormatException e) {
            valid = false;
            msg = "NumberformatException for '" + value + "'";
        }
        if (!valid && this.myStatus != null) {
            this.myStatus.beep();
            this.myStatus.printMessage(msg);
        }
        return valid;
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
        this.myStatus = statusHandler;
    }

    public StatusInterface getStatusHandler() {
        return this.myStatus;
    }

    @Override
    public void enableValidation(boolean enable) {
        this.isEnabled = enable;
    }
}

