/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.charging.common.documents;

import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import ericsson.ere.defs.RmaDefs;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IpAddressMaskDocument
extends PlainDocument
implements FieldValidation {
    private StatusInterface myStatus = null;
    private static String ipAddressRegExp = "^((25[0-5]|2[0-4][0-9]|[0-1][0-9][0-9]|[0-9][0-9]|[0-9])\\.){0,3}(25[0-5]|2[0-4][0-9]|[0-1][0-9][0-9]|[0-9][0-9]|[0-9]){0,1}$";
    private static String bitRange = "^(3[0-2]|[1-2][0-9]|[1-9])";
    private static String fullIpAddressRegExp = "^(((25[0-5]|2[0-4][0-9]|[0-1][0-9][0-9]|[0-9][0-9]|[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[0-1][0-9][0-9]|[0-9][0-9]|[0-9]){1}(/(3[0-2]|[1-2][0-9]|[1-9])){0,1})|((25[0-5]|2[0-4][0-9]|[0-1][0-9][0-9]|[0-9][0-9]|[0-9])\\.){1,3}\\*$";
    private static Pattern ipPattern = Pattern.compile(ipAddressRegExp);
    private static Pattern bitRangePattern = Pattern.compile(bitRange);
    private static Pattern fullIpPattern = Pattern.compile(fullIpAddressRegExp);
    private boolean isEnabled = true;

    public IpAddressMaskDocument() {
    }

    public IpAddressMaskDocument(String maskString) {
        try {
            this.insertString(0, maskString, null);
        }
        catch (BadLocationException e) {
            System.out.println("Not good...");
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (!this.isEnabled) {
            super.insertString(offs, str, a);
            return;
        }
        String ipMaskOnlyString = "";
        char[] chars = str.toCharArray();
        String currentText = this.getText(0, this.getLength());
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isDigit(chars[i]) || chars[i] == '.' || chars[i] == '/' || chars[i] == '*') {
                if (chars[i] == '*' && (currentText.indexOf(42) >= 0 || ipMaskOnlyString.indexOf(42) >= 0)) {
                    RmaDefs.getInstance().controlledBeep();
                    this.myStatus.printMessage("Only one wildcard character '*' is allowed");
                    continue;
                }
                if (chars[i] == '/' && (currentText.indexOf(47) >= 0 || ipMaskOnlyString.indexOf(47) >= 0)) {
                    RmaDefs.getInstance().controlledBeep();
                    this.myStatus.printMessage("Only one '/' character is allowed");
                    continue;
                }
                ipMaskOnlyString = ipMaskOnlyString + chars[i];
                continue;
            }
            RmaDefs.getInstance().controlledBeep();
            this.myStatus.printMessage("Only digits '0-9', '.', '/', '*' allowed");
        }
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + ipMaskOnlyString + afterOffset;
        if (proposedResult.length() == 0) {
            return;
        }
        if (this.validateIpAddressPart(offs, proposedResult)) {
            super.insertString(offs, ipMaskOnlyString, a);
        }
    }

    private boolean validateIpAddressPart(int pos, String ip) {
        String localIp = ip;
        String sign = "";
        int slashPos = ip.indexOf(47);
        int wildCardPos = ip.indexOf(42);
        if (wildCardPos >= 0) {
            if (wildCardPos + 1 != ip.length()) {
                RmaDefs.getInstance().controlledBeep();
                this.myStatus.printMessage("'*' is only allowed at the end");
                return false;
            }
            ip = localIp.substring(0, wildCardPos);
        }
        if (slashPos >= 0) {
            ip = localIp.substring(0, slashPos);
            sign = localIp.substring(slashPos + 1, localIp.length());
            if (!this.checkSlash(localIp, slashPos)) {
                return false;
            }
            if (sign.length() > 0 && !bitRangePattern.matcher(sign).matches()) {
                RmaDefs.getInstance().controlledBeep();
                this.myStatus.printMessage("'" + localIp + "' with " + sign + " significant bits NOT valid (range 1-32)");
                return false;
            }
        }
        if (!ipPattern.matcher(ip).matches()) {
            RmaDefs.getInstance().controlledBeep();
            this.myStatus.printMessage("'" + localIp + "' is NOT any valid IP- address");
            return false;
        }
        return true;
    }

    private boolean checkSlash(String localIp, int slashPos) {
        int numberOfDots = 0;
        if (slashPos < 2) {
            RmaDefs.getInstance().controlledBeep();
            this.myStatus.printMessage("'/' can only be added to a complete IP-address");
            return false;
        }
        char[] chars = localIp.toCharArray();
        for (int ii = 0; ii < chars.length; ++ii) {
            if (chars[ii] != '.') continue;
            ++numberOfDots;
        }
        if (numberOfDots != 3) {
            RmaDefs.getInstance().controlledBeep();
            this.myStatus.printMessage("'/' can only be added to a complete IP-address");
            return false;
        }
        if (!Character.isDigit(chars[slashPos - 1])) {
            RmaDefs.getInstance().controlledBeep();
            this.myStatus.printMessage("'/' can only be added to a complete IP-address");
            return false;
        }
        return true;
    }

    @Override
    public boolean isValid(String value) {
        return fullIpPattern.matcher(value).matches();
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
        this.myStatus = statusHandler;
    }

    public StatusInterface getStatusHandler() {
        return this.myStatus;
    }

    @Override
    public void enableValidation(boolean enable) {
        this.isEnabled = enable;
    }
}

