/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.charging.common.documents;

import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NumbersOnlyDocument
extends PlainDocument
implements FieldValidation {
    private long myMin = Long.MIN_VALUE;
    private long myMax = Long.MAX_VALUE;
    private boolean allowZero = true;
    private StatusInterface myStatus = null;
    private boolean isEnabled = true;

    public NumbersOnlyDocument() {
    }

    public NumbersOnlyDocument(long min, long max) {
        this.myMin = min;
        this.myMax = max;
    }

    public NumbersOnlyDocument(boolean zero) {
        this.allowZero = zero;
    }

    public NumbersOnlyDocument(long min, long max, boolean zero) {
        this.myMin = min;
        this.myMax = max;
        this.allowZero = zero;
    }

    public long getMinValue() {
        return this.myMin;
    }

    public void setMinValue(long v) {
        this.myMin = v;
    }

    public long getMaxValue() {
        return this.myMax;
    }

    public void setMaxValue(long v) {
        this.myMax = v;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (!this.isEnabled) {
            super.insertString(offs, str, a);
            return;
        }
        String numbersOnlyString = "";
        int start = 0;
        if (this.myMin < 0L && str.startsWith("-") && offs == 0) {
            numbersOnlyString = numbersOnlyString + "-";
            start = 1;
        }
        char[] chars = str.toCharArray();
        for (int i = start; i < chars.length; ++i) {
            if (Character.isDigit(chars[i])) {
                numbersOnlyString = numbersOnlyString + chars[i];
                continue;
            }
            if (this.myStatus == null) continue;
            this.myStatus.beep();
            this.myStatus.printMessage("Only digits '0-9' allowed");
        }
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + numbersOnlyString + afterOffset;
        if (proposedResult.length() == 0) {
            return;
        }
        if (proposedResult.equals("-")) {
            super.insertString(offs, numbersOnlyString, a);
            return;
        }
        super.insertString(offs, numbersOnlyString, a);
    }

    @Override
    public boolean isValid(String str) {
        boolean valid = true;
        String msg = "";
        if (str.length() < 1) {
            valid = false;
            msg = "No digits, not a numeric value";
        }
        if (valid && !this.onlyDigitsInString(str)) {
            valid = false;
            msg = "'" + str + "' is NOT Valid, only digits '0-9' allowed ";
        }
        try {
            long longVal = Long.parseLong(str);
            if (valid && !this.checkRange(longVal)) {
                valid = false;
                msg = "Value '" + str + "' out of range, must be within " + this.myMin + " >= value <= " + this.myMax;
            } else if (valid && longVal == 0L && !this.allowZero) {
                valid = false;
                msg = "Value cannot be 0";
            }
        }
        catch (NumberFormatException e) {
            valid = false;
            msg = "NumberformatException for '" + str + "'";
        }
        if (!valid && this.myStatus != null) {
            this.myStatus.beep();
            this.myStatus.printMessage(msg);
        }
        return valid;
    }

    private boolean onlyDigitsInString(String str) {
        int start = 0;
        if (this.myMin < 0L && (str.startsWith("-") || str.startsWith("+"))) {
            start = 1;
        }
        char[] chars = str.toCharArray();
        for (int i = start; i < chars.length; ++i) {
            if (Character.isDigit(chars[i])) continue;
            return false;
        }
        return true;
    }

    private boolean checkRange(long longProposedResult) {
        return longProposedResult <= this.myMax && longProposedResult >= this.myMin;
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
        this.myStatus = statusHandler;
    }

    public StatusInterface getStatusHandler() {
        return this.myStatus;
    }

    @Override
    public void enableValidation(boolean enable) {
        this.isEnabled = enable;
    }
}

