/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc;

import java.util.LinkedHashMap;
import java.util.Map;

public enum ExternalErrorArgumentsConverter {
    CHARGING_SYSTEM("CS"),
    EXTERNAL_RATING_SYSTEM("ERS"),
    EXTERNAL_ACCOUNT("EA"),
    SERVICE_PROVIDER("SP"),
    GENERIC_ACCESS_MODULE("AM"),
    EXTERNAL_ACCOUNT_ACCESS_MODULE("EA_AM"),
    SERVICE_PROVIDER_ACCESS_MODULE("SP_AM");

    private String originCode;
    public static final String ERROR_ORIGIN_KEY = "ExternalErrorOrigin";
    public static final String ERROR_CODE_KEY = "ExternalErrorCode";
    public static final String UNKNOWN_EXTERNAL_ERROR = "UNKNOWN_EXTERNAL_ERROR";

    private ExternalErrorArgumentsConverter(String originCode) {
        this.originCode = originCode;
    }

    public String getOriginCode() {
        return this.originCode;
    }

    public Map<String, Object> convertArgumentsMap(Map<String, Object> arguments, Object errorCode) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (arguments != null) {
            result.putAll(arguments);
        }
        if (!result.containsKey(ERROR_ORIGIN_KEY)) {
            this.updateArgumentsMap(result, errorCode);
        }
        return result;
    }

    public void updateArgumentsMap(Map<String, Object> arguments, Object errorCode) {
        if (arguments != null && !arguments.containsKey(ERROR_ORIGIN_KEY)) {
            LinkedHashMap newArguments = new LinkedHashMap();
            arguments.forEach((key, value) -> newArguments.put(this.originCode + "_" + key, value));
            arguments.putAll(newArguments);
            arguments.put(ERROR_ORIGIN_KEY, this.originCode);
            arguments.put(ERROR_CODE_KEY, errorCode != null ? errorCode.toString() : UNKNOWN_EXTERNAL_ERROR);
        }
    }

    public static Map<String, Object> reduceArgumentsMap(Map<String, Object> arguments) {
        if (arguments != null && arguments.containsKey(ERROR_ORIGIN_KEY)) {
            LinkedHashMap<String, Object> reducedArguments = new LinkedHashMap<String, Object>();
            String origin = arguments.get(ERROR_ORIGIN_KEY).toString();
            arguments.forEach((key, value) -> {
                if (!(key.equals(ERROR_ORIGIN_KEY) || key.equals(ERROR_CODE_KEY) || key.startsWith(origin + "_"))) {
                    reducedArguments.put((String)key, value);
                }
            });
            return reducedArguments;
        }
        return arguments;
    }

    public static Map<String, Object> applyCustomPrefixToArgumentsMap(String prefix, Map<String, Object> arguments) {
        if (prefix != null && arguments != null) {
            LinkedHashMap<String, Object> updatedArguments = new LinkedHashMap<String, Object>();
            String origin = arguments.containsKey(ERROR_ORIGIN_KEY) ? arguments.get(ERROR_ORIGIN_KEY).toString() : null;
            arguments.forEach((key, value) -> {
                if (origin != null && (key.equals(ERROR_ORIGIN_KEY) || key.equals(ERROR_CODE_KEY) || key.startsWith(origin + "_"))) {
                    updatedArguments.put((String)key, value);
                } else {
                    updatedArguments.put(prefix + key, value);
                }
            });
            return updatedArguments;
        }
        return arguments;
    }
}

