/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.credential.persistence;

import com.ericsson.em.emc.credential.exception.CredentialErrorCode;
import com.ericsson.em.privacy.PersonalData;
import com.ericsson.lwac.ValidationException;
import com.ericsson.lwac.crypto.util.ByteArrays;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.persistence.Versionable;
import com.ericsson.lwac.security.HashVersion;
import java.sql.Timestamp;

public class CredentialHistory
extends BaseEntity
implements Versionable {
    private static final long serialVersionUID = 6823761223234382601L;
    private Long credentialOwnerReferenceId = null;
    private Long credentialTypeId = null;
    @PersonalData(type={PersonalData.PersonalDataType.PASSWORD})
    private byte[] hashedPassword = null;
    private HashVersion hashVersion;
    private Timestamp changeDate = null;
    private Long version = 1L;

    public Long getCredentialOwnerReferenceId() {
        return this.credentialOwnerReferenceId;
    }

    public void setCredentialOwnerReferenceId(Long credentialOwnerReferenceId) {
        this.credentialOwnerReferenceId = credentialOwnerReferenceId;
    }

    public Long getCredentialTypeId() {
        return this.credentialTypeId;
    }

    public void setCredentialTypeId(Long credentialTypeId) {
        this.credentialTypeId = credentialTypeId;
    }

    public byte[] getHashedPassword() {
        return ByteArrays.safeCopy((byte[])this.hashedPassword);
    }

    public void setHashedPassword(byte[] hashedPassword) {
        this.hashedPassword = ByteArrays.safeCopy((byte[])hashedPassword);
    }

    public HashVersion getHashVersion() {
        return this.hashVersion;
    }

    public void setHashVersion(HashVersion hashVersion) {
        this.hashVersion = hashVersion;
    }

    public Timestamp getChangeDate() {
        return this.changeDate == null ? null : new Timestamp(this.changeDate.getTime());
    }

    public void setChangeDate(Timestamp changed) {
        this.changeDate = changed == null ? null : new Timestamp(changed.getTime());
    }

    public String toString() {
        return "com.ericsson.em.emc.credential.persistence.Credential[id=" + this.mId + "]";
    }

    protected void validate() {
        if (this.credentialOwnerReferenceId == null) {
            throw new ValidationException(CredentialErrorCode.CREDENTIAL_MISSING_CREDENTIAL_OWNER_REFERENCE.getMessage());
        }
        if (this.credentialTypeId == null) {
            throw new ValidationException(CredentialErrorCode.CREDENTIAL_MISSING_CREDENTIAL_TYPE.getMessage());
        }
        if (this.hashedPassword == null) {
            throw new ValidationException(CredentialErrorCode.CREDENTIAL_MISSING_HASHED_PASSWORD.getMessage());
        }
        if (this.hashedPassword.length == 0) {
            throw new ValidationException(CredentialErrorCode.CREDENTIAL_EMPTY_HASHED_PASSWORD.getMessage());
        }
        if (this.hashVersion == null) {
            throw new ValidationException(CredentialErrorCode.CREDENTIAL_MISSING_HASH_VERSION.getMessage());
        }
        if (this.changeDate == null) {
            throw new ValidationException(CredentialErrorCode.CREDENTIAL_MISSING_CHANGE_DATE.getMessage());
        }
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    @Override
    public void increaseVersion() {
        Long l = this.version;
        Long l2 = this.version = Long.valueOf(this.version + 1L);
    }
}

