/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.credential.persistence;

import com.ericsson.em.emc.credential.persistence.CredentialOwnerReference;
import com.ericsson.em.emc.credential.persistence.CredentialOwnerReferenceDAO;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.FingerprintUpdateResultSetProcessor;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.database.persistence.EntityResultSetProcessor;
import jakarta.ejb.Singleton;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;

@Updatable
@Validatable
@Singleton
@CryptoKeys(keyAliases={"emm.credentialownerreference.S"})
public class CredentialOwnerReferenceDAOBean
extends CryptoExtendedBaseEntityDAOBean<CredentialOwnerReference>
implements CredentialOwnerReferenceDAO {
    private static final int DEFAULT_FINGERPRINT_VERSION = 1;
    private static final int CURRENT_FINGERPRINT_VERSION = 2;
    static final String FINGERPRINT_KEY = "emm.credentialownerreference.S";
    private static final String TABLE_NAME = "emm$credentialownerreference";
    private static final String TABLE_SEQUENCE_NAME = "emm$credentialownerref_seq";

    @Override
    public CredentialOwnerReference create(CredentialOwnerReference credentialOwnerReference) {
        return (CredentialOwnerReference)super.create((BaseEntity)credentialOwnerReference);
    }

    public CredentialOwnerReference update(CredentialOwnerReference credentialOwnerReference) {
        return (CredentialOwnerReference)super.update((BaseEntity)credentialOwnerReference);
    }

    @Override
    public void delete(CredentialOwnerReference credentialOwnerReference) {
        super.delete((BaseEntity)credentialOwnerReference);
    }

    public String[] getColumns() {
        return (String[])Arrays.stream(TableColumn.values()).map(Enum::name).toArray(String[]::new);
    }

    protected String getEntitySimpleName() {
        return CredentialOwnerReference.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 2;
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    public String getSequenceName() {
        return TABLE_SEQUENCE_NAME;
    }

    public boolean isVersionable() {
        return false;
    }

    public boolean isUpdatable() {
        return true;
    }

    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        int fingerprintIndex = TableColumn.FINGERPRINT.index();
        return this.assignFingerprint(preparedStatement, fingerprintIndex, new Object[0]);
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1 || fingerprintVersion == 2) {
            return new Object[0];
        }
        return null;
    }

    protected CredentialOwnerReference createManagedEntity() {
        return new CredentialOwnerReference();
    }

    public CredentialOwnerReference updateDefaultFingerprint(CredentialOwnerReference entry) {
        return (CredentialOwnerReference)this.updateWithFingerprintVersionCheck(entry, 1);
    }

    public long updateDefaultFingerprintUsingResultSetProcessor(long batchSize, FingerprintUpdateResultSetProcessor fpResultSetProcessor) {
        long recordsUpdated = this.processEntityResultSet("select * from (" + this.getSelectStatement() + " where " + TableColumn.FINGERPRINTVERSION + "= ? order by " + TableColumn.ID + ") WHERE rownum <= ?", (EntityResultSetProcessor)fpResultSetProcessor, new Object[]{1, batchSize});
        return recordsUpdated;
    }

    private static enum TableColumn {
        ID,
        FINGERPRINT,
        FINGERPRINTVERSION,
        FINGERPRINTKEYGENERATION;


        int index() {
            return this.ordinal();
        }
    }
}

