/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.credential.persistence;

import com.ericsson.em.emc.credential.persistence.CredentialType;
import com.ericsson.em.emc.credential.persistence.CredentialTypeDAO;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.FingerprintUpdateResultSetProcessor;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.database.persistence.EntityResultSetProcessor;
import jakarta.ejb.Singleton;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
@Updatable
@Validatable
@CryptoKeys(keyAliases={"emm.credentialtype.S"})
public class CredentialTypeDAOBean
extends CryptoExtendedBaseEntityDAOBean<CredentialType>
implements CredentialTypeDAO {
    private static final String TABLE_NAME = "emm$credentialtype";
    private static final int DEFAULT_FINGERPRINT_VERSION = 1;
    private static final int CURRENT_FINGERPRINT_VERSION = 2;
    static final String FINGERPRINT_KEY = "emm.credentialtype.S";
    private final Map<Long, CredentialType> localCache = new ConcurrentHashMap<Long, CredentialType>();

    @Override
    public CredentialType create(CredentialType credentialType) {
        credentialType = (CredentialType)super.create((BaseEntity)credentialType);
        this.localCache.put(credentialType.getId(), credentialType);
        return credentialType;
    }

    @Override
    public CredentialType find(long id) {
        CredentialType credentialType = this.localCache.get(id);
        if (credentialType == null && (credentialType = (CredentialType)super.find(id)) != null) {
            this.localCache.put(credentialType.getId(), credentialType);
        }
        return credentialType;
    }

    @Override
    public List<CredentialType> findAll() {
        return this.findMultiple(this.getSelectStatement(), new Object[0]);
    }

    @Override
    public CredentialType findByName(String name) {
        return (CredentialType)this.find(this.getSelectStatement() + " where " + TableColumn.NAME.name() + " = ?", new Object[]{name});
    }

    public CredentialType update(CredentialType credentialType) {
        credentialType = (CredentialType)super.update((BaseEntity)credentialType);
        this.localCache.put(credentialType.getId(), credentialType);
        return credentialType;
    }

    public CredentialType updateDefaultFingerprint(CredentialType entry) {
        return (CredentialType)this.updateWithFingerprintVersionCheck(entry, 1);
    }

    public long updateDefaultFingerprintUsingResultSetProcessor(long batchSize, FingerprintUpdateResultSetProcessor fpResultSetProcessor) {
        long recordsUpdated = this.processEntityResultSet("select * from (" + this.getSelectStatement() + " where " + TableColumn.FINGERPRINTVERSION + "= ? order by " + TableColumn.ID + ") WHERE rownum <= ?", (EntityResultSetProcessor)fpResultSetProcessor, new Object[]{1, batchSize});
        return recordsUpdated;
    }

    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        CredentialType credentialType = (CredentialType)baseEntity;
        preparedStatement.setString(TableColumn.NAME.index(), credentialType.getName());
        preparedStatement.setString(TableColumn.DESCRIPTION.index(), credentialType.getDescription());
        return this.assignFingerprint(preparedStatement, TableColumn.FINGERPRINT.index(), new Object[]{credentialType.getName(), credentialType.getDescription()});
    }

    protected void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        CredentialType credentialType = (CredentialType)baseEntity;
        credentialType.setName(resultSet.getString(TableColumn.NAME.name()));
        credentialType.setDescription(resultSet.getString(TableColumn.DESCRIPTION.name()));
    }

    protected CredentialType createManagedEntity() {
        return new CredentialType();
    }

    public String[] getColumns() {
        return (String[])Arrays.stream(TableColumn.values()).map(Enum::name).toArray(String[]::new);
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    public String getSequenceName() {
        return "emm$credentialtype_seq";
    }

    public boolean isVersionable() {
        return false;
    }

    public boolean isUpdatable() {
        return true;
    }

    protected String getEntitySimpleName() {
        return CredentialType.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 2;
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1 || fingerprintVersion == 2) {
            return new Object[]{resultSet.getString(TableColumn.NAME.name()), resultSet.getString(TableColumn.DESCRIPTION.name())};
        }
        return null;
    }

    private static enum TableColumn {
        ID,
        NAME,
        DESCRIPTION,
        FINGERPRINT,
        FINGERPRINTVERSION,
        FINGERPRINTKEYGENERATION;


        int index() {
            return this.ordinal();
        }
    }
}

