/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.credential.provider;

import com.ericsson.em.emc.CoreUserErrorCode;
import com.ericsson.em.emc.UserErrorCode;
import com.ericsson.em.emc.UserException;
import com.ericsson.em.emc.UserExceptionBuilder;
import com.ericsson.em.emc.credential.CredentialKeyDomainService;
import com.ericsson.em.emc.credential.CredentialManager;
import com.ericsson.em.emc.credential.CredentialOwner;
import com.ericsson.em.emc.credential.CredentialStatus;
import com.ericsson.em.emc.credential.CredentialTypeProvider;
import com.ericsson.em.emc.credential.exception.CredentialErrorCode;
import com.ericsson.em.emc.credential.exception.CredentialException;
import com.ericsson.em.emc.credential.hash.HashManager;
import com.ericsson.em.emc.credential.persistence.Credential;
import com.ericsson.em.emc.credential.persistence.CredentialDAO;
import com.ericsson.em.emc.credential.persistence.CredentialHistory;
import com.ericsson.em.emc.credential.persistence.CredentialHistoryDAO;
import com.ericsson.em.emc.credential.persistence.CredentialOwnerReference;
import com.ericsson.em.emc.credential.persistence.CredentialType;
import com.ericsson.lwac.cli.ApplicationProperties;
import com.ericsson.lwac.cli.ApplicationPropertyChangeListener;
import com.ericsson.lwac.locks.LockService;
import com.ericsson.lwac.security.HashVersion;
import com.ericsson.lwac.utilities.StringUtilities;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import java.sql.Timestamp;
import java.util.concurrent.locks.ReadWriteLock;
import org.joda.time.DateTime;
import org.slf4j.Logger;

public abstract class AbstractCredentialProvider
implements CredentialTypeProvider,
ApplicationPropertyChangeListener {
    @EJB
    private CredentialManager credentialManager;
    @EJB
    private CredentialDAO credentialDAO;
    @EJB
    private CredentialHistoryDAO credentialHistoryDAO;
    @EJB
    private HashManager hashManager;
    @Resource
    private LockService lockService;
    @Resource
    private CredentialKeyDomainService credentialKeyService;
    @Resource
    private ApplicationProperties applicationProperties;
    private LastLoginResolution resolution = LastLoginResolution.MILLISECONDS;
    private ReadWriteLock lock;
    protected CredentialType credentialType;

    protected abstract Logger getLogger();

    protected abstract String getCredentialTypeName();

    protected void validateSecret(CredentialOwner credentialOwner, String credentialSecret) {
    }

    @PostConstruct
    public final void postConstruct() {
        this.applicationProperties.registerApplicationPropertyChangeListener(this, CredentialApplicationProperty.LAST_LOGIN_RESOLUTION);
        this.resolution = LastLoginResolution.valueOf(this.applicationProperties.getProperty(CredentialApplicationProperty.LAST_LOGIN_RESOLUTION));
        this.lock = this.lockService.createReadWriteLock("credential-update-lock");
        this.onPostConstruct();
    }

    public abstract void onPostConstruct();

    protected CredentialManager getCredentialManager() {
        return this.credentialManager;
    }

    private CredentialType getCredentialType() {
        if (this.credentialType != null) {
            return this.credentialType;
        }
        this.credentialType = this.credentialManager.getCredentialType(this.getCredentialTypeName());
        if (this.credentialType == null) {
            throw new CredentialException(CredentialErrorCode.CREDENTIAL_ILLEGAL_ARGUMENT, "credentialTypeName");
        }
        return this.credentialType;
    }

    protected Credential createCredentialEntity(CredentialOwner credentialOwner, String credentialSecret, CredentialStatus initialStatus) {
        Credential credential = new Credential();
        credential.setCredentialOwnerReferenceId(credentialOwner.getCredentialOwnerReference().getId());
        credential.setCredentialTypeId(this.getCredentialType().getId());
        HashVersion hashVersion = this.hashManager.getCurrentHashVersion();
        credential.setHashVersion(hashVersion);
        Integer credentialKeyGeneration = this.credentialKeyService.getCredentialKeyGeneration();
        credential.setKeyGeneration(credentialKeyGeneration);
        credential.setHashedCredential(this.getHashedSecret(credentialOwner, credentialSecret, hashVersion, credentialKeyGeneration));
        credential.setStatus(initialStatus);
        credential = this.credentialDAO.create(credential);
        return credential;
    }

    @Override
    public boolean authenticate(CredentialOwner credentialOwner, Credential credential, String secret) {
        boolean result = this.hashManager.validate(credentialOwner.getCredentialOwnerReference().getId(), secret, credential.getHashVersion(), credential.getHashedCredential(), credential.getKeyGeneration());
        if (result && credential.getHashVersion() != this.hashManager.getCurrentHashVersion()) {
            HashVersion hashVersion = this.hashManager.getCurrentHashVersion();
            Integer credentialKeyGeneration = this.credentialKeyService.getCredentialKeyGeneration();
            credential.setHashVersion(hashVersion);
            credential.setKeyGeneration(credentialKeyGeneration);
            credential.setHashedCredential(this.getHashedSecret(credentialOwner, secret, hashVersion, credentialKeyGeneration));
            this.credentialDAO.update(credential);
        }
        return result;
    }

    protected byte[] getHashedSecret(CredentialOwner credentialOwner, String credentialSecret, HashVersion hashVersion, Integer credentialKeyGeneration) {
        return this.hashManager.getHashedCredential(credentialOwner.getCredentialOwnerReference().getId(), credentialSecret, hashVersion, credentialKeyGeneration);
    }

    protected void authenticateCredential(CredentialOwner credentialOwner, Credential credential, String currentSecret) {
        if (!this.authenticate(credentialOwner, credential, currentSecret)) {
            throw new UserExceptionBuilder(CoreUserErrorCode.INCORRECT_PASSWORD).create();
        }
    }

    @Override
    public Credential createCredential(CredentialOwner credentialOwner, String credentialSecret, String repeatedCredentialSecret, CredentialStatus initialStatus) {
        if (!this.validateRepeatedSecret(credentialSecret, repeatedCredentialSecret)) {
            throw new UserExceptionBuilder(CoreUserErrorCode.CREDENTIAL_REPEATED_SECRET_DOES_NOT_MATCH).create();
        }
        return this.createCredential(credentialOwner, credentialSecret, initialStatus);
    }

    @Override
    public Credential createCredential(CredentialOwner credentialOwner, String credentialSecret, CredentialStatus initialStatus) {
        if (credentialOwner == null) {
            throw new CredentialException(CredentialErrorCode.CREDENTIAL_ILLEGAL_ARGUMENT, "credentialOwner");
        }
        this.validateSecret(credentialOwner, credentialSecret);
        Credential credential = this.createCredentialEntity(credentialOwner, credentialSecret, initialStatus);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Created credentials of type {} for credential reference: {}", (Object)this.getCredentialType().getName(), (Object)credentialOwner.getCredentialOwnerReference().getId());
        }
        return credential;
    }

    @Override
    public Credential createVoidCredential(CredentialOwner credentialOwner) {
        return this.createVoidCredential(credentialOwner, CredentialStatus.ACTIVE);
    }

    @Override
    public Credential createVoidCredential(CredentialOwner credentialOwner, CredentialStatus initialStatus) {
        if (credentialOwner == null) {
            throw new CredentialException(CredentialErrorCode.CREDENTIAL_ILLEGAL_ARGUMENT, "credentialOwner");
        }
        this.getLogger().warn("Missing credentials of type {} for credential reference {}. Creating void credentials.", (Object)this.getCredentialType().getName(), (Object)credentialOwner.getCredentialOwnerReference().getId());
        Credential credential = new Credential();
        credential.setCredentialOwnerReferenceId(credentialOwner.getCredentialOwnerReference().getId());
        credential.setCredentialTypeId(this.getCredentialType().getId());
        credential.setHashVersion(this.hashManager.getCurrentHashVersion());
        credential.setHashedCredential(new byte[]{0});
        credential.setStatus(initialStatus);
        credential = this.credentialDAO.create(credential);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Created credentials of type {} for credential reference: {}", (Object)this.getCredentialType().getName(), (Object)credentialOwner.getCredentialOwnerReference().getId());
        }
        return credential;
    }

    @Override
    public void resetCredential(CredentialOwner credentialOwner, String credentialSecret, String repeatedSecret, CredentialStatus newStatus) {
        if (!this.validateRepeatedSecret(credentialSecret, repeatedSecret)) {
            throw new UserExceptionBuilder(CoreUserErrorCode.CREDENTIAL_REPEATED_SECRET_DOES_NOT_MATCH).create();
        }
        if (credentialOwner == null) {
            throw new CredentialException(CredentialErrorCode.CREDENTIAL_ILLEGAL_ARGUMENT, "credentialOwner");
        }
        this.validateSecret(credentialOwner, credentialSecret);
        Credential credential = this.findByCredentialOwnerReferenceAndCredentialType(credentialOwner.getCredentialOwnerReference());
        if (CredentialStatus.INACTIVE == credential.getStatus()) {
            throw new CredentialException(CredentialErrorCode.CREDENTIAL_INCORRECT_STATUS, new Object[]{credential.getStatus()});
        }
        this.saveCredentialHistory(credential);
        HashVersion hashVersion = this.hashManager.getCurrentHashVersion();
        credential.setHashVersion(hashVersion);
        Integer credentialKeyGeneration = this.credentialKeyService.getCredentialKeyGeneration();
        credential.setKeyGeneration(credentialKeyGeneration);
        credential.setHashedCredential(this.getHashedSecret(credentialOwner, credentialSecret, hashVersion, credentialKeyGeneration));
        credential.setStatus(newStatus);
        credential.setCreated(new Timestamp(System.currentTimeMillis()));
        this.credentialDAO.update(credential);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Reset credentials of type {} for credential reference: {}", (Object)this.getCredentialType(), (Object)credentialOwner.getCredentialOwnerReference().getId());
        }
    }

    protected boolean validateRepeatedSecret(String credentialSecret, String repeatedSecret) {
        return credentialSecret != null && (repeatedSecret == null || credentialSecret.equals(repeatedSecret));
    }

    @Override
    public Credential updateCredential(CredentialOwner credentialOwner, String currentSecret, String newSecret, String repeatedSecret) {
        Credential credential;
        block9: {
            if (credentialOwner == null) {
                throw new CredentialException(CredentialErrorCode.CREDENTIAL_ILLEGAL_ARGUMENT, "credentialOwner");
            }
            if (StringUtilities.isBlank(currentSecret)) {
                throw new CredentialException(CredentialErrorCode.CREDENTIAL_ILLEGAL_ARGUMENT, "currentSecret");
            }
            if (StringUtilities.isBlank(newSecret)) {
                throw new CredentialException(CredentialErrorCode.CREDENTIAL_ILLEGAL_ARGUMENT, "newSecret");
            }
            credential = this.credentialDAO.findByCredentialOwnerReferenceAndCredentialType(credentialOwner.getCredentialOwnerReference(), this.getCredentialType());
            if (credential == null) {
                throw new UserExceptionBuilder(CoreUserErrorCode.CREDENTIALS_NOT_FOUND).create();
            }
            if (credential.getStatus() != CredentialStatus.ACTIVE && credential.getStatus() != CredentialStatus.ACTIVE_MUST_BE_CHANGED) {
                throw new UserExceptionBuilder(CoreUserErrorCode.CREDENTIAL_NOT_ACTIVE).create();
            }
            if (!this.validateRepeatedSecret(newSecret, repeatedSecret)) {
                throw new UserExceptionBuilder(CoreUserErrorCode.CREDENTIAL_REPEATED_SECRET_DOES_NOT_MATCH).create();
            }
            try {
                this.authenticateCredential(credentialOwner, credential, currentSecret);
            }
            catch (UserException ue) {
                UserErrorCode errorCode = ue.getErrorCode();
                if (CoreUserErrorCode.PINCODE_HAS_EXPIRED == errorCode) break block9;
                throw ue;
            }
        }
        this.validateSecret(credentialOwner, newSecret);
        this.saveCredentialHistory(credential);
        HashVersion hashVersion = this.hashManager.getCurrentHashVersion();
        Integer keyGeneration = this.credentialKeyService.getCredentialKeyGeneration();
        credential.setHashedCredential(this.getHashedSecret(credentialOwner, newSecret, hashVersion, keyGeneration));
        credential.setHashVersion(hashVersion);
        credential.setKeyGeneration(keyGeneration);
        credential.setCreated(new Timestamp(System.currentTimeMillis()));
        if (credential.getStatus() == CredentialStatus.ACTIVE_MUST_BE_CHANGED) {
            credential.setStatus(CredentialStatus.ACTIVE);
        }
        credential = this.credentialDAO.update(credential);
        return credential;
    }

    @Override
    public void registerSuccessfulLogin(CredentialOwner credentialOwner) {
        Credential credential = this.findByCredentialOwnerReferenceAndCredentialType(credentialOwner.getCredentialOwnerReference());
        if (credential != null) {
            this.registerSuccessfulLogin(credential);
        }
    }

    @Override
    public void registerUnsuccessfulLogin(CredentialOwner credentialOwner) {
        Credential credential = this.findByCredentialOwnerReferenceAndCredentialType(credentialOwner.getCredentialOwnerReference());
        if (credential != null) {
            this.registerUnsuccessfulLogin(credential);
        }
    }

    @Override
    public void registerUnsuccessfulReset(CredentialOwner credentialOwner) {
        Credential credential = this.findByCredentialOwnerReferenceAndCredentialType(credentialOwner.getCredentialOwnerReference());
        if (credential != null) {
            credential.setLastResetAttempt(new DateTime());
            this.credentialDAO.update(credential);
        }
    }

    private void registerUnsuccessfulLogin(Credential credential) {
        credential.setFailedLogins(credential.getFailedLogins() + 1);
        credential.setLastFailedLoginTimestamp(new DateTime());
        this.credentialDAO.update(credential);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerSuccessfulLogin(Credential credential) {
        Integer oldFailedLogins = credential.getFailedLogins();
        Integer oldLastFailedLogins = credential.getLastFailedLogins();
        DateTime oldLastLoginTimestamp = credential.getLastLoginTimestamp();
        credential.setLastFailedLogins(credential.getFailedLogins());
        credential.setFailedLogins(0);
        credential.setLastLoginTimestamp(credential.getLoginTimestamp());
        credential.setLoginTimestamp(new DateTime());
        if (credential.getFailedLogins().equals(oldFailedLogins) && credential.getLastFailedLogins().equals(oldLastFailedLogins)) {
            this.lock.readLock().lock();
            try {
                if (this.resolution == LastLoginResolution.MILLISECONDS || oldLastLoginTimestamp == null) {
                    this.credentialDAO.updateUnsafe(credential);
                    return;
                }
                if (credential.getLastLoginTimestamp().minuteOfHour().roundFloorCopy().equals(oldLastLoginTimestamp.minuteOfHour().roundFloorCopy())) return;
                this.credentialDAO.updateUnsafe(credential);
                return;
            }
            finally {
                this.lock.readLock().unlock();
            }
        } else {
            this.credentialDAO.update(credential);
        }
    }

    private void saveCredentialHistory(Credential credential) {
        CredentialHistory credentialHistory = new CredentialHistory();
        credentialHistory.setCredentialOwnerReferenceId(credential.getCredentialOwnerReferenceId());
        credentialHistory.setCredentialTypeId(credential.getCredentialTypeId());
        credentialHistory.setHashedPassword(credential.getHashedCredential());
        credentialHistory.setHashVersion(credential.getHashVersion());
        credentialHistory.setChangeDate(new Timestamp(System.currentTimeMillis()));
        this.credentialHistoryDAO.create(credentialHistory);
    }

    @Override
    public Credential findByCredentialOwnerReferenceAndCredentialType(CredentialOwnerReference credentialOwnerReference) {
        return this.credentialDAO.findByCredentialOwnerReferenceAndCredentialType(credentialOwnerReference, this.getCredentialType());
    }

    @Override
    public void onPropertyChanged(ApplicationProperties.ApplicationProperty property, String newValue) {
        if (property == CredentialApplicationProperty.LAST_LOGIN_RESOLUTION) {
            this.lock.writeLock().lock();
            try {
                this.resolution = LastLoginResolution.valueOf(newValue);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    private static enum LastLoginResolution {
        MILLISECONDS,
        MINUTES;

    }

    static enum CredentialApplicationProperty implements ApplicationProperties.ApplicationProperty
    {
        LAST_LOGIN_RESOLUTION("credential.last_login_resolution", "MILLISECONDS");

        private final String propertyName;
        private final String defaultValue;

        private CredentialApplicationProperty(String propertyName, String defaultValue) {
            this.propertyName = propertyName;
            this.defaultValue = defaultValue;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

