/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.csv;

import com.ericsson.em.emc.csv.CsvFileInfo;
import com.ericsson.em.emc.util.Currency;
import com.ericsson.em.validation.Validation;
import com.ericsson.em.validators.NotEmpty;
import jakarta.validation.constraints.NotNull;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class FinancialCsvFileInfo
extends CsvFileInfo {
    @NotEmpty
    private final String financialResourceType;
    @NotNull
    private final Currency currency;
    @NotNull
    private final DateTime dateFrom;
    @NotNull
    private final DateTime dateTo;

    private FinancialCsvFileInfo(String financialResourceType, Currency currency, DateTime dateFrom, DateTime dateTo, String fileNamePrefix) {
        super(fileNamePrefix);
        this.financialResourceType = financialResourceType;
        this.currency = currency;
        this.dateFrom = dateFrom;
        this.dateTo = dateTo;
    }

    @Override
    protected void validate() {
        Validation.validate(this);
        if (this.dateFrom.isAfter(this.dateTo)) {
            throw new IllegalArgumentException("Start date cannot be after end date");
        }
    }

    @Override
    public String generateFileName(String format, String fileExtension) {
        DateTimeFormatter dateFormat = DateTimeFormat.forPattern("YYYY-MM-dd");
        return String.format(format, this.getFileNamePrefix(), this.financialResourceType, this.currency, dateFormat.print(this.dateFrom), dateFormat.print(this.dateTo), fileExtension);
    }

    public String getFinancialResourceType() {
        return this.financialResourceType;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public DateTime getDateFrom() {
        return this.dateFrom;
    }

    public DateTime getDateTo() {
        return this.dateTo;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder
    extends CsvFileInfo.Builder<FinancialCsvFileInfo, Builder> {
        private String financialResourceType;
        private Currency currency;
        private DateTime dateFrom;
        private DateTime dateTo;

        private Builder() {
        }

        @Override
        protected FinancialCsvFileInfo createCsvFileInfo(String fileNamePrefix) {
            return new FinancialCsvFileInfo(this.financialResourceType, this.currency, this.dateFrom, this.dateTo, fileNamePrefix);
        }

        public Builder financialResourceType(String financialResourceType) {
            this.financialResourceType = financialResourceType;
            return this;
        }

        public Builder currency(Currency currency) {
            this.currency = currency;
            return this;
        }

        public Builder dateFrom(DateTime dateFrom) {
            this.dateFrom = dateFrom;
            return this;
        }

        public Builder dateTo(DateTime dateTo) {
            this.dateTo = dateTo;
            return this;
        }
    }
}

