/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.externaladmininfo;

import com.ericsson.em.emc.externaladmininfo.ExternalAdminInfo;
import com.ericsson.em.emc.externaladmininfo.ExternalAdminInfoDAO;
import com.ericsson.em.emc.externaladmininfo.ExternalAdminStatus;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import jakarta.ejb.Stateless;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.stream.Stream;
import org.joda.time.DateTime;

@Updatable
@Validatable
@CryptoKeys(keyAliases={"emm.externaladmininfo.S"})
@Stateless
public class ExternalAdminInfoDAOBean
extends CryptoExtendedBaseEntityDAOBean<ExternalAdminInfo>
implements ExternalAdminInfoDAO {
    static final String EXTERNAL_ADMIN_INFO_FINGERPRINT_KEY = "emm.externaladmininfo.S";
    private static final String[] COLUMNS = (String[])Stream.of(TableColumn.values()).map(Enum::name).toArray(String[]::new);
    private static final int CURRENT_FINGERPRINT_VERSION = 2;
    private static final String TABLE_NAME = "emm$externaladmininfo";
    private static final String SEQUENCE_NAME = "emm$externaladmininfo_seq";

    @Override
    public ExternalAdminInfo create(ExternalAdminInfo externalAdminInfo) {
        return (ExternalAdminInfo)super.create((BaseEntity)externalAdminInfo);
    }

    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        ExternalAdminInfo externalAdminInfo = (ExternalAdminInfo)baseEntity;
        preparedStatement.setString(TableColumn.USERIDENTITY.ordinal(), externalAdminInfo.getUserIdentity());
        preparedStatement.setInt(TableColumn.STATUS.ordinal(), externalAdminInfo.getStatus().ordinal());
        preparedStatement.setTimestamp(TableColumn.LOGINTIMESTAMP.ordinal(), Timestamp.valueOf(externalAdminInfo.getLoginTimestamp()));
        if (externalAdminInfo.getLastLoginTimestamp() != null) {
            preparedStatement.setTimestamp(TableColumn.LASTLOGINTIMESTAMP.ordinal(), Timestamp.valueOf(externalAdminInfo.getLastLoginTimestamp()));
        } else {
            preparedStatement.setNull(TableColumn.LASTLOGINTIMESTAMP.ordinal(), 93);
        }
        preparedStatement.setLong(TableColumn.PROFILEID.ordinal(), externalAdminInfo.getProfileId());
        return this.assignFingerprint(preparedStatement, TableColumn.FINGERPRINT.ordinal(), new Object[]{externalAdminInfo.getUserIdentity(), externalAdminInfo.getStatus().ordinal(), Timestamp.valueOf(externalAdminInfo.getLoginTimestamp()), externalAdminInfo.getLastLoginTimestamp() == null ? null : Timestamp.valueOf(externalAdminInfo.getLastLoginTimestamp()), externalAdminInfo.getProfileId()});
    }

    public ExternalAdminInfo createEntity(ResultSet resultSet) throws SQLException {
        ExternalAdminInfo.Builder externalAdminInfoBuilder = ExternalAdminInfo.newBuilder().mId(resultSet.getLong(TableColumn.ID.name())).userIdentity(resultSet.getString(TableColumn.USERIDENTITY.name())).status(ExternalAdminStatus.valueOf(resultSet.getInt(TableColumn.STATUS.name()))).loginTimestamp(resultSet.getTimestamp(TableColumn.LOGINTIMESTAMP.name()).toLocalDateTime()).profileId(resultSet.getLong(TableColumn.PROFILEID.name()));
        Timestamp lastLoginTimestamp = resultSet.getTimestamp(TableColumn.LASTLOGINTIMESTAMP.name());
        if (lastLoginTimestamp == null) {
            externalAdminInfoBuilder.lastLoginTimestamp(null);
        } else {
            externalAdminInfoBuilder.lastLoginTimestamp(lastLoginTimestamp.toLocalDateTime());
        }
        return externalAdminInfoBuilder.build();
    }

    @Override
    public ExternalAdminInfo findByUserIdentity(String userIdentity) {
        String filters = " where " + TableColumn.USERIDENTITY.name() + " = ?";
        return (ExternalAdminInfo)this.find(this.getSelectStatement() + filters, new Object[]{userIdentity});
    }

    @Override
    public ExternalAdminInfo update(ExternalAdminInfo externalAdminInfo) {
        return (ExternalAdminInfo)super.update((BaseEntity)externalAdminInfo);
    }

    @Override
    public void delete(ExternalAdminInfo externalAdminInfo) {
        super.delete((BaseEntity)externalAdminInfo);
    }

    @Override
    public List<ExternalAdminInfo> findUsersNotLoggedInSince(ZonedDateTime zonedDateTime) {
        String filters = " where " + TableColumn.LOGINTIMESTAMP.name() + " < ? AND " + TableColumn.STATUS + " = ?";
        return this.findMultiple(this.getSelectStatement() + filters, new Object[]{Timestamp.from(zonedDateTime.toInstant()), ExternalAdminStatus.ACTIVE.ordinal()});
    }

    protected String getEntitySimpleName() {
        return ExternalAdminInfo.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return EXTERNAL_ADMIN_INFO_FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 2;
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1) {
            return new Object[]{resultSet.getString(TableColumn.USERIDENTITY.name()), resultSet.getInt(TableColumn.STATUS.name()), resultSet.getTimestamp(TableColumn.LOGINTIMESTAMP.name()), resultSet.getTimestamp(TableColumn.LASTLOGINTIMESTAMP.name()) == null ? null : new DateTime(resultSet.getTimestamp(TableColumn.LASTLOGINTIMESTAMP.name()))};
        }
        if (fingerprintVersion == 2) {
            return new Object[]{resultSet.getString(TableColumn.USERIDENTITY.name()), resultSet.getInt(TableColumn.STATUS.name()), resultSet.getTimestamp(TableColumn.LOGINTIMESTAMP.name()), resultSet.getTimestamp(TableColumn.LASTLOGINTIMESTAMP.name()) == null ? null : new DateTime(resultSet.getTimestamp(TableColumn.LASTLOGINTIMESTAMP.name())), resultSet.getLong(TableColumn.PROFILEID.name())};
        }
        return null;
    }

    public String[] getColumns() {
        return (String[])COLUMNS.clone();
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    public String getSequenceName() {
        return SEQUENCE_NAME;
    }

    public boolean isVersionable() {
        return false;
    }

    public boolean isUpdatable() {
        return true;
    }

    static enum TableColumn {
        ID,
        USERIDENTITY,
        STATUS,
        LOGINTIMESTAMP,
        LASTLOGINTIMESTAMP,
        PROFILEID,
        FINGERPRINT,
        FINGERPRINTVERSION,
        FINGERPRINTKEYGENERATION;

    }
}

