/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.feature.provider;

import com.ericsson.em.emc.feature.provider.DistributedPermissionHolder;
import com.ericsson.em.emc.feature.provider.FeatureRefreshMessage;
import com.ericsson.em.emc.feature.provider.PermissionFactory;
import com.ericsson.em.emc.feature.provider.PermissionFeatureService;
import com.ericsson.lwac.cluster.ClusterChannel;
import com.ericsson.lwac.cluster.ClusterException;
import com.ericsson.lwac.cluster.ClusterMessage;
import com.ericsson.lwac.cluster.ClusterMessageListener;
import com.ericsson.lwac.cluster.ClusterService;
import com.ericsson.lwac.deployer.BeanId;
import com.ericsson.lwac.feature.Feature;
import com.ericsson.lwac.jobs.JobExecutorService;
import com.ericsson.lwac.jobs.JobRejectedException;
import com.ericsson.lwac.logging.LogManager;
import com.ericsson.lwac.logging.StructuredLogger;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.NotSerializableException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DistributedPermissionHolderImpl
implements DistributedPermissionHolder {
    private static final Logger logger = LoggerFactory.getLogger(DistributedPermissionHolderImpl.class);
    private final AtomicReference<Set<String>> permissionCache = new AtomicReference(Collections.emptySet());
    private final ClusterService clusterService;
    private final ClusterChannel channel;
    private final PermissionRefresh permissionRefresher;
    private final JobExecutorService jobExecutorService;
    private final FeatureStatusUpdateLogger featureStatusUpdateLogger;
    private final BeanId beanId;

    public static DistributedPermissionHolder create(BeanId beanId, ClusterService clusterService, PermissionFeatureService permissionFeatureService, JobExecutorService jobExecutorService, LogManager logManager) throws ClusterException {
        StructuredLogger logger2 = logManager.registerLogger("feature");
        return new DistributedPermissionHolderImpl(beanId, clusterService, permissionFeatureService, jobExecutorService, logger2);
    }

    private DistributedPermissionHolderImpl(BeanId beanId, ClusterService clusterService, PermissionFeatureService permissionFeatureService, JobExecutorService jobExecutorService, StructuredLogger logger2) throws ClusterException {
        this.clusterService = clusterService;
        this.permissionRefresher = new PermissionRefresh(this.permissionCache, (PermissionFactory)((Object)permissionFeatureService));
        this.jobExecutorService = jobExecutorService;
        this.featureStatusUpdateLogger = new FeatureStatusUpdateLogger(permissionFeatureService, logger2);
        this.channel = clusterService.registerMessageListener(beanId, new Receiver(jobExecutorService, this.permissionRefresher, this.featureStatusUpdateLogger));
        this.beanId = beanId;
    }

    @Override
    public Set<String> getPermissions() {
        return this.permissionCache.get();
    }

    @Override
    public void go() throws Exception {
        this.permissionRefresher.call();
        this.jobExecutorService.scheduleAtFixedRate(this.beanId, "Refresh Permission Cache ", this.permissionRefresher, 5L, 5L, TimeUnit.MINUTES);
        this.featureStatusUpdateLogger.log(RefreshCause.StartUp);
    }

    @Override
    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public void refresh() throws Exception {
        try {
            this.permissionRefresher.call();
        }
        finally {
            this.castRefreshEvent();
            this.featureStatusUpdateLogger.log(RefreshCause.StatusChange);
        }
    }

    private void castRefreshEvent() {
        FeatureRefreshMessage message = new FeatureRefreshMessage();
        try {
            this.clusterService.castMessage(this.channel, message, ClusterService.CastOption.ASYNC);
        }
        catch (ClusterException | NotSerializableException e) {
            logger.warn(e.getMessage(), e);
        }
    }

    private static class FeatureStatusUpdateLogger {
        private final PermissionFeatureService permissionFeatureService;
        private final StructuredLogger logger;

        FeatureStatusUpdateLogger(PermissionFeatureService permissionFeatureService, StructuredLogger logger2) {
            this.permissionFeatureService = permissionFeatureService;
            this.logger = logger2;
        }

        public void log(RefreshCause statuschange) {
            StringBuilder sb = new StringBuilder(1024);
            sb.append(String.format("Feature status refreshed, trigged by %s%n", new Object[]{statuschange}));
            for (Feature feature : this.permissionFeatureService.getFeatures()) {
                sb.append("    ").append("Feature '").append(feature.getName()).append("'").append(" is ").append(this.permissionFeatureService.isActive(feature) ? "Active" : "Inactive").append("\n");
            }
            this.logger.write(ImmutableMap.of("message", sb.toString()));
        }
    }

    private static class PermissionRefresh
    implements Runnable,
    Callable<Void> {
        private final Lock refreshLock = new ReentrantLock();
        private final AtomicReference<Set<String>> permissionCache;
        private final PermissionFactory permissionFactory;

        PermissionRefresh(AtomicReference<Set<String>> permissionCache, PermissionFactory permissionFactory) {
            this.permissionCache = permissionCache;
            this.permissionFactory = permissionFactory;
        }

        @Override
        public Void call() {
            this.refreshLock.lock();
            try {
                this.permissionCache.set(this.createPermissions());
            }
            finally {
                this.refreshLock.unlock();
            }
            return null;
        }

        private Set<String> createPermissions() {
            HashSet<String> permissions = new HashSet<String>();
            this.permissionFactory.fill(permissions);
            return Collections.unmodifiableSet(permissions);
        }

        @Override
        public void run() {
            this.call();
        }
    }

    private static class Receiver
    implements ClusterMessageListener {
        private final JobExecutorService jobExecutorService;
        private final PermissionRefresh permissionRefresh;
        private final FeatureStatusUpdateLogger featureStatusUpdateLogger;

        public Receiver(JobExecutorService jobExecutorService, PermissionRefresh permissionRefresh, FeatureStatusUpdateLogger featureStatusUpdateLogger) {
            this.jobExecutorService = jobExecutorService;
            this.permissionRefresh = permissionRefresh;
            this.featureStatusUpdateLogger = featureStatusUpdateLogger;
        }

        @Override
        @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
        public Object handle(ClusterMessage message) {
            if (message.getPayload() instanceof FeatureRefreshMessage) {
                try {
                    this.jobExecutorService.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            permissionRefresh.call();
                            featureStatusUpdateLogger.log(RefreshCause.ReceiverUpdate);
                            return null;
                        }
                    });
                }
                catch (JobRejectedException e) {
                    logger.warn("Could not submit festure refersh task", e);
                }
            }
            return null;
        }
    }

    private static enum RefreshCause {
        TimeoutReread,
        StartUp,
        StatusChange,
        ReceiverUpdate;

    }
}

