/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.financial;

import com.ericsson.em.emc.IllegalFriException;
import com.ericsson.em.emc.financial.CurrencyResolvedFRI;
import com.ericsson.em.emc.financial.FRI;
import com.ericsson.em.emc.financial.FriBuilder;
import com.ericsson.em.emc.financial.ResolvedFRI;
import com.ericsson.em.emc.financial.UnresolvedFRI;
import com.ericsson.em.emc.util.Currency;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractFriBuilder
implements FriBuilder {
    private static final String ID_PATTERN_STRING = "([\\p{IsAlphabetic}\\p{IsDigit}+:.@_\\-]*?)(?:@([\\p{IsAlphabetic}\\p{IsDigit}+:._\\-]+))?";
    private static final Pattern ID_PATTERN = Pattern.compile(String.format("^%s$", "([\\p{IsAlphabetic}\\p{IsDigit}+:.@_\\-]*?)(?:@([\\p{IsAlphabetic}\\p{IsDigit}+:._\\-]+))?"), 258);
    protected String id;
    protected String idWithoutProvider;
    protected String provider;
    protected String handler;
    protected Currency currency;
    protected FRI resolvedFrom;

    @Override
    public abstract String getFriType();

    protected abstract boolean friIsValid();

    protected abstract FRI makeFRI();

    @Override
    public FriBuilder withId(Object id) {
        this.id = String.valueOf(id);
        return this;
    }

    @Override
    public FriBuilder withId(long id) {
        this.id = String.valueOf(id);
        return this;
    }

    @Override
    public FriBuilder withId(int id) {
        this.id = String.valueOf(id);
        return this;
    }

    @Override
    public FriBuilder withHandler(String handler) {
        this.handler = handler;
        return this;
    }

    @Override
    public FriBuilder withCurrency(Currency currency) {
        this.currency = currency;
        return this;
    }

    @Override
    public FriBuilder withResolvedFrom(FRI resolvedFrom) {
        this.resolvedFrom = resolvedFrom;
        return this;
    }

    @Override
    public FRI create() {
        this.splitIdIfFriIsValid();
        return this.makeFRI();
    }

    @Override
    public ResolvedFRI createResolved() {
        this.splitIdIfFriIsValid();
        return this.makeResolvedFRI();
    }

    private void splitIdIfFriIsValid() {
        if (this.id == null) {
            this.id = "";
        }
        if (!this.friIsValid()) {
            throw new IllegalFriException("Illegal datatype " + this.id + " for type " + this.getFriType());
        }
        this.splitProviderFromId();
    }

    private void splitProviderFromId() {
        this.idWithoutProvider = this.id;
        this.provider = null;
        Matcher idPatternMatcher = ID_PATTERN.matcher(this.id);
        if (idPatternMatcher.matches()) {
            if (idPatternMatcher.groupCount() != 2) {
                throw new IllegalFriException("Can not match ID " + this.id + " for type " + this.getFriType());
            }
        } else {
            throw new IllegalFriException("Can not match ID " + this.id + " for type " + this.getFriType());
        }
        this.idWithoutProvider = idPatternMatcher.group(1);
        this.provider = idPatternMatcher.group(2);
    }

    protected UnresolvedFRI makeUnresolvedFRI() {
        return new UnresolvedFRI(this.id, this.idWithoutProvider, this.provider, this.getFriType(), this.handler, this.resolvedFrom);
    }

    protected ResolvedFRI makeResolvedFRI() {
        return new ResolvedFRI(this.id, this.idWithoutProvider, this.provider, this.getFriType(), this.handler, this.resolvedFrom);
    }

    protected CurrencyResolvedFRI makeCurrencyResolvedFRI() {
        return new CurrencyResolvedFRI(this.id, this.idWithoutProvider, this.provider, this.getFriType(), this.handler, this.resolvedFrom, this.currency);
    }
}

