/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.financial;

import java.io.Serializable;

public abstract class FRI
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String idWithoutProvider;
    private final String provider;
    private final String type;
    private final String handler;
    private final FRI resolvedFrom;

    public static FRI getRootFRI(FRI fri) {
        if (fri == null) {
            return null;
        }
        return FRI.getRootImpl(fri, fri.getResolvedFrom());
    }

    public static FRI ofType(FRI fri, String type) {
        if (fri == null) {
            return null;
        }
        if (type.equals(fri.getType())) {
            return fri;
        }
        return FRI.ofType(fri.getResolvedFrom(), type);
    }

    protected FRI(String id, String idWithoutProvider, String provider, String type, String handler, FRI resolvedFrom) {
        this.id = id;
        this.idWithoutProvider = idWithoutProvider;
        this.provider = provider;
        this.type = type;
        this.handler = handler;
        this.resolvedFrom = resolvedFrom != this ? resolvedFrom : null;
    }

    public String getId() {
        return this.id;
    }

    public String getIdWithoutProvider() {
        return this.idWithoutProvider;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getType() {
        return this.type;
    }

    public String getHandler() {
        return this.handler;
    }

    public FRI getResolvedFrom() {
        return this.resolvedFrom;
    }

    public String toString() {
        return "FRI:" + this.id + '/' + this.type;
    }

    public String toDetailedString() {
        StringBuilder string = new StringBuilder("FRI:").append(this.id).append('/').append(this.type).append('#').append(this.handler);
        if (this.resolvedFrom != null) {
            string.append(" -> ").append(this.resolvedFrom.toDetailedString());
        }
        return string.toString();
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FRI)) {
            return false;
        }
        FRI other = (FRI)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    private static FRI getRootImpl(FRI fri, FRI resolvedFrom) {
        if (resolvedFrom == null) {
            return fri;
        }
        return FRI.getRootImpl(resolvedFrom, resolvedFrom.getResolvedFrom());
    }
}

