/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies;

import com.ericsson.em.emc.hierarchies.PeriodManager;
import com.ericsson.em.emc.hierarchies.persistence.Period;
import com.ericsson.em.emc.hierarchies.persistence.Periodizable;
import com.ericsson.lwac.utilities.DateUtilities;
import jakarta.ejb.Singleton;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;

@Singleton
public class PeriodManagerBean
implements PeriodManager {
    @Override
    public void calculatePeriod(Periodizable periodizable, Period period, DateTime now) {
        this.calculatePeriod(periodizable, period, now, periodizable.getStartDateTime(), periodizable.getEndDateTime());
    }

    @Override
    public void calculatePeriod(Periodizable periodizable, Period period, DateTime now, DateTime startDateTime, DateTime endDateTime) {
        startDateTime = DateUtilities.getMax(periodizable.getStartDateTime(), startDateTime);
        if (!DateUtilities.within(startDateTime, endDateTime = DateUtilities.getMin(periodizable.getEndDateTime(), endDateTime), now)) {
            throw new IllegalArgumentException(String.format("DateTime %s not within period: %s - %s", now, startDateTime, endDateTime));
        }
        Periodizable.PeriodType periodType = periodizable.getPeriodType();
        switch (periodType) {
            case NO_PERIOD: {
                period.setStartDateTime(startDateTime);
                period.setEndDateTime(endDateTime);
                break;
            }
            case CALENDAR_MONTH: {
                PeriodManagerBean.calculateCalendarMonthPeriod(period, periodizable.getPeriodLength(), now);
                break;
            }
            case CALENDAR_WEEK: {
                PeriodManagerBean.calculateCalendarWeekPeriod(period, periodizable.getPeriodLength(), startDateTime, now);
                break;
            }
            case DAY: {
                PeriodManagerBean.calculateDayPeriod(period, periodizable.getPeriodLength(), startDateTime, now);
                break;
            }
            case FINANCIAL_CALENDAR: {
                PeriodManagerBean.calculateFinancialMonthPeriod(period, periodizable.getStartDayInMonth(), now);
                break;
            }
            case MINUTE: {
                PeriodManagerBean.calculateMinutePeriod(period, periodizable.getPeriodLength(), startDateTime, now);
                break;
            }
            case HOUR: {
                PeriodManagerBean.calculateHourPeriod(period, periodizable.getPeriodLength(), startDateTime, now);
                break;
            }
            case CALENDAR_YEAR: {
                PeriodManagerBean.calculateCalendarYearPeriod(period, periodizable.getPeriodLength(), now);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal period type: " + periodType);
            }
        }
    }

    @Override
    public boolean isPendingPeriod(Periodizable periodizable, DateTime dateTime, DateTime initTimestamp) {
        Periodizable.PeriodType periodType = periodizable.getPeriodType();
        DateTime endDateTime = new DateTime(initTimestamp);
        switch (periodType) {
            case CALENDAR_MONTH: 
            case FINANCIAL_CALENDAR: {
                endDateTime = endDateTime.plusMonths(periodizable.getPeriodLength());
                break;
            }
            case CALENDAR_WEEK: {
                endDateTime = endDateTime.plusWeeks(periodizable.getPeriodLength());
                break;
            }
            case DAY: {
                endDateTime = endDateTime.plusDays(periodizable.getPeriodLength());
                break;
            }
            case MINUTE: {
                endDateTime = endDateTime.plusMinutes(periodizable.getPeriodLength());
                break;
            }
            case HOUR: {
                endDateTime = endDateTime.plusHours(periodizable.getPeriodLength());
                break;
            }
            case CALENDAR_YEAR: {
                endDateTime = endDateTime.plusYears(periodizable.getPeriodLength());
                break;
            }
            case NO_PERIOD: {
                return true;
            }
            default: {
                return false;
            }
        }
        return initTimestamp.isBefore(dateTime) && endDateTime.isAfter(dateTime);
    }

    private static void calculateCalendarYearPeriod(Period period, int periodLength, DateTime now) {
        DateMidnight firstOfYear = new DateMidnight(now.getMillis()).withDayOfYear(1);
        period.setStartDateTime(new DateTime(firstOfYear));
        DateMidnight endDate = firstOfYear.plusYears(periodLength);
        period.setEndDateTime(new DateTime(endDate));
    }

    private static void calculateFinancialMonthPeriod(Period period, int startDayInMonth, DateTime now) {
        DateMidnight firstOfMonth = new DateMidnight(now.getMillis()).withDayOfMonth(1);
        DateTime startDate = new DateTime(firstOfMonth.withDayOfMonth(startDayInMonth));
        period.setStartDateTime(startDate);
        DateTime endDate = new DateTime(startDate.plusMonths(1).plusDays(1));
        period.setEndDateTime(endDate);
    }

    private static void calculateCalendarMonthPeriod(Period period, int periodLength, DateTime now) {
        DateMidnight firstOfMonth = new DateMidnight(now.getMillis()).withDayOfMonth(1);
        period.setStartDateTime(new DateTime(firstOfMonth));
        DateMidnight endDate = firstOfMonth.plusMonths(periodLength);
        period.setEndDateTime(new DateTime(endDate));
    }

    private static void calculateCalendarWeekPeriod(Period period, int periodLength, DateTime startDateTime, DateTime now) {
        DateTime start = periodLength == 1 ? now : startDateTime;
        DateMidnight startDay = new DateMidnight(start);
        while (startDay.getDayOfWeek() != 1) {
            startDay = startDay.minusDays(1);
        }
        do {
            period.setStartDateTime(new DateTime(startDay));
            startDay = startDay.plusWeeks(periodLength);
            period.setEndDateTime(new DateTime(startDay));
        } while (!period.within(now));
    }

    private static void calculateDayPeriod(Period period, int periodLength, DateTime startDateTime, DateTime now) {
        DateTime start = periodLength == 1 ? now : startDateTime;
        DateMidnight startDay = new DateMidnight(start);
        do {
            period.setStartDateTime(new DateTime(startDay));
            startDay = startDay.plusDays(periodLength);
            period.setEndDateTime(new DateTime(startDay));
        } while (!period.within(now));
    }

    private static void calculateMinutePeriod(Period period, int periodLength, DateTime startDateTime, DateTime now) {
        DateTime start = periodLength == 1 ? now : startDateTime;
        do {
            period.setStartDateTime(start);
            start = start.plusMinutes(periodLength);
            period.setEndDateTime(start);
        } while (!period.within(now));
    }

    private static void calculateHourPeriod(Period period, int periodLength, DateTime startDateTime, DateTime now) {
        DateTime start = periodLength == 1 ? now : startDateTime;
        do {
            period.setStartDateTime(start);
            start = start.plusHours(periodLength);
            period.setEndDateTime(start);
        } while (!period.within(now));
    }
}

