/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies;

import com.ericsson.em.emc.hierarchies.ProfileConfigurationService;
import com.ericsson.lwac.cli.ApplicationProperties;
import com.ericsson.lwac.cli.ApplicationPropertyChangeListener;
import com.ericsson.lwac.deployer.service.Service;
import com.ericsson.lwac.deployer.service.ServiceProperty;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;

@Service
public class ProfileConfigurationServiceBean
implements ProfileConfigurationService,
ApplicationPropertyChangeListener {
    @Resource
    private ApplicationProperties applicationProperties;
    private static final int DEFAULT_MAXIMUM_NUMBER_OF_RATING_COUNTERS = 20;
    private static final int DEFAULT_MAXIMUM_NUMBER_OF_AH_PROFILES = 300;
    private static final ApplicationProperties.ApplicationProperty MAXIMUM_NUMBER_OF_RATING_COUNTERS = ProfileConfigurationServiceBean.createApplicationProperty("profile.maximum_number_of_ratingcounters", String.valueOf(20));
    private static final ApplicationProperties.ApplicationProperty MAXIMUM_NUMBER_OF_AH_PROFILES = ProfileConfigurationServiceBean.createApplicationProperty("profile.maximum_number_of_account_holder_profiles", String.valueOf(300));
    private int maximumNumberOfRatingCounters = 20;
    private int maximumNumberOfAccountHolderProfiles = 300;

    @Override
    public int getMaximumNumberOfRatingCounters() {
        return this.maximumNumberOfRatingCounters;
    }

    @Override
    public int getMaximumNumberOfAccountHolderProfiles() {
        return this.maximumNumberOfAccountHolderProfiles;
    }

    @Override
    @ServiceProperty
    public void setMaximumNumberOfRatingCounters(int maximumNumberOfRatingCounters) {
        if (maximumNumberOfRatingCounters <= 0) {
            throw new IllegalArgumentException("Erroneous property " + MAXIMUM_NUMBER_OF_RATING_COUNTERS.getPropertyName() + ": " + maximumNumberOfRatingCounters + " must be larger then 0");
        }
        this.maximumNumberOfRatingCounters = maximumNumberOfRatingCounters;
    }

    @Override
    @ServiceProperty
    public void setMaximumNumberOfAccountHolderProfiles(int maximumNumberOfAccountHolderProfiles) {
        if (maximumNumberOfAccountHolderProfiles <= 0) {
            throw new IllegalArgumentException("Erroneous property " + MAXIMUM_NUMBER_OF_AH_PROFILES.getPropertyName() + ": " + maximumNumberOfAccountHolderProfiles + " must be larger then 0");
        }
        this.maximumNumberOfAccountHolderProfiles = maximumNumberOfAccountHolderProfiles;
    }

    @Override
    public void onPropertyChanged(ApplicationProperties.ApplicationProperty property, String newValue) {
        if (property.getPropertyName().equals(MAXIMUM_NUMBER_OF_RATING_COUNTERS.getPropertyName())) {
            this.setMaximumNumberOfRatingCounters(Integer.parseInt(newValue));
        } else if (property.getPropertyName().equals(MAXIMUM_NUMBER_OF_AH_PROFILES.getPropertyName())) {
            this.setMaximumNumberOfAccountHolderProfiles(Integer.parseInt(newValue));
        } else {
            throw new IllegalArgumentException("Unhandled ProfileConfigurationService property: " + property.getPropertyName());
        }
    }

    @PostConstruct
    public void postConstruct() {
        this.applicationProperties.registerApplicationPropertyChangeListener(this, MAXIMUM_NUMBER_OF_RATING_COUNTERS);
        this.applicationProperties.registerApplicationPropertyChangeListener(this, MAXIMUM_NUMBER_OF_AH_PROFILES);
    }

    private static ApplicationProperties.ApplicationProperty createApplicationProperty(final String name, final String defaultValue) {
        return new ApplicationProperties.ApplicationProperty(){

            @Override
            public String getPropertyName() {
                return name;
            }

            @Override
            public String getDefaultValue() {
                return defaultValue;
            }
        };
    }
}

