/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.approvalconfiguration;

import com.ericsson.em.emc.util.Currency;
import com.ericsson.lwac.ValidationException;
import com.ericsson.lwac.cache.Cacheable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import jakarta.persistence.Entity;
import java.math.BigDecimal;

@Entity
public class ApprovalConfiguration
extends BaseEntity
implements Cacheable<ApprovalConfiguration> {
    private static final long serialVersionUID = 3923286726317244659L;
    private Currency currency;
    private BigDecimal lowerRange;
    private BigDecimal topRange;
    private Integer stage;
    private Long profileId;
    private boolean sendNotifications = false;
    private Long version = 1L;

    public ApprovalConfiguration() {
    }

    ApprovalConfiguration(Long id, Currency currency, BigDecimal lowerRange, BigDecimal topRange, Integer stage, Long profileId, boolean sendNotifications, Long version) {
        this.mId = id;
        this.currency = currency;
        this.lowerRange = lowerRange;
        this.topRange = topRange;
        this.stage = stage;
        this.profileId = profileId;
        this.sendNotifications = sendNotifications;
        this.version = version;
    }

    private ApprovalConfiguration(ApprovalConfiguration approvalConfig) {
        super((BaseEntity)approvalConfig);
        this.currency = approvalConfig.getCurrency();
        this.lowerRange = approvalConfig.getLowerRange();
        this.topRange = approvalConfig.getTopRange();
        this.stage = approvalConfig.getStage();
        this.profileId = approvalConfig.getProfileId();
        this.sendNotifications = approvalConfig.isSendNotifications();
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public BigDecimal getLowerRange() {
        return this.lowerRange;
    }

    public void setLowerRange(BigDecimal lowerRange) {
        this.lowerRange = lowerRange;
    }

    public BigDecimal getTopRange() {
        return this.topRange;
    }

    public void setTopRange(BigDecimal topRange) {
        this.topRange = topRange;
    }

    public Integer getStage() {
        return this.stage;
    }

    public void setStage(Integer stage) {
        this.stage = stage;
    }

    public Long getProfileId() {
        return this.profileId;
    }

    public void setProfileId(Long profileId) {
        this.profileId = profileId;
    }

    public boolean isSendNotifications() {
        return this.sendNotifications;
    }

    public void setSendNotifications(boolean sendNotifications) {
        this.sendNotifications = sendNotifications;
    }

    public String toString() {
        return "ApprovalConfiguration [currency=" + this.currency + ", lowerRange=" + this.lowerRange + ", topRange=" + this.topRange + ", stage=" + this.stage + ", profileId=" + this.profileId + ", sendNotifications=" + this.sendNotifications + ", version=" + this.version + "]";
    }

    @Override
    public ApprovalConfiguration deepClone() {
        return new ApprovalConfiguration(this);
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void increaseVersion() {
        Long l = this.version;
        Long l2 = this.version = Long.valueOf(this.version + 1L);
    }

    protected void validate() {
        super.validate();
        if (this.currency == null) {
            throw new ValidationException("ApprovalConfiguration: 'currency' is missing");
        }
        if (this.lowerRange == null) {
            throw new ValidationException("ApprovalConfiguration: 'lowerRange' is missing");
        }
        if (this.stage == null) {
            throw new ValidationException("ApprovalConfiguration: 'stage' is missing");
        }
        if (this.profileId == null) {
            throw new ValidationException("ApprovalConfiguration: 'profileId' is missing");
        }
    }

    public static ApprovalConfigurationBuilder newBuilder() {
        return new ApprovalConfigurationBuilder();
    }

    public ApprovalConfigurationBuilder buildUpon() {
        return new ApprovalConfigurationBuilder(this);
    }

    public static class ApprovalConfigurationBuilder {
        protected Long id;
        protected Currency currency;
        protected BigDecimal lowerRange;
        protected BigDecimal topRange;
        protected Integer stage;
        protected Long profileId;
        protected boolean sendNotifications;
        protected Long version = 1L;
        private final boolean existing;

        protected ApprovalConfigurationBuilder() {
            this.existing = false;
        }

        void checkExisting(String property) {
            if (this.existing) {
                throw new IllegalArgumentException("Can not change " + property + " on already created entity");
            }
        }

        protected ApprovalConfigurationBuilder(ApprovalConfiguration approvalConfig) {
            this.id = approvalConfig.getId();
            this.currency = approvalConfig.getCurrency();
            this.lowerRange = approvalConfig.getLowerRange();
            this.topRange = approvalConfig.getTopRange();
            this.stage = approvalConfig.getStage();
            this.profileId = approvalConfig.getProfileId();
            this.sendNotifications = approvalConfig.isSendNotifications();
            this.existing = true;
        }

        public ApprovalConfigurationBuilder currency(Currency currency) {
            this.currency = currency;
            return this;
        }

        public ApprovalConfigurationBuilder lowerRange(BigDecimal lowerRange) {
            this.lowerRange = lowerRange;
            return this;
        }

        public ApprovalConfigurationBuilder topRange(BigDecimal topRange) {
            this.topRange = topRange;
            return this;
        }

        public ApprovalConfigurationBuilder stage(Integer stage) {
            this.stage = stage;
            return this;
        }

        public ApprovalConfigurationBuilder profileId(Long profileId) {
            this.checkExisting("profileId");
            this.profileId = profileId;
            return this;
        }

        public ApprovalConfigurationBuilder sendNotifications(boolean sendNotifications) {
            this.sendNotifications = sendNotifications;
            return this;
        }

        public ApprovalConfigurationBuilder version(Long version) {
            this.version = version;
            return this;
        }

        public ApprovalConfigurationBuilder id(Long id) {
            this.checkExisting("id");
            this.id = id;
            return this;
        }

        public ApprovalConfiguration build() {
            return new ApprovalConfiguration(this.id, this.currency, this.lowerRange, this.topRange, this.stage, this.profileId, this.sendNotifications, this.version);
        }
    }
}

