/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.counters;

import com.ericsson.em.emc.hierarchies.HierarchyManager;
import com.ericsson.em.emc.hierarchies.PeriodManager;
import com.ericsson.em.emc.hierarchies.counters.CounterManager;
import com.ericsson.em.emc.hierarchies.counters.CounterTransaction;
import com.ericsson.em.emc.hierarchies.counters.DynamicCounterModifiersRetriever;
import com.ericsson.em.emc.hierarchies.counters.Modifier;
import com.ericsson.em.emc.hierarchies.counters.ModifierResponse;
import com.ericsson.em.emc.hierarchies.counters.ModifierService;
import com.ericsson.em.emc.hierarchies.counters.PersonalLimitsManager;
import com.ericsson.em.emc.hierarchies.limits.CounterMatcher;
import com.ericsson.em.emc.hierarchies.limits.LimitMatchingParameters;
import com.ericsson.em.emc.hierarchies.limits.ModifierMatcher;
import com.ericsson.em.emc.hierarchies.limits.RatingCounterType;
import com.ericsson.em.emc.hierarchies.persistence.CounterBalance;
import com.ericsson.em.emc.hierarchies.persistence.CounterBalanceDAO;
import com.ericsson.em.emc.hierarchies.persistence.CounterBalanceReservation;
import com.ericsson.em.emc.hierarchies.persistence.CounterBalanceReservationDAO;
import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfigurationManager;
import com.ericsson.em.emc.hierarchies.persistence.ModifierConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.ProfileReference;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import com.ericsson.em.emc.hierarchies.persistence.SharedCounterConfigurationDAO;
import jakarta.ejb.EJB;
import jakarta.ejb.Stateful;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateful
public class CounterManagerBean
implements CounterManager {
    private static final String AUTHORIZATION_SERVICE = "Authorization";
    private static final Logger logger = LoggerFactory.getLogger(CounterManagerBean.class);
    @EJB
    private CounterBalanceDAO counterBalanceDAO;
    @EJB
    private CounterBalanceReservationDAO counterBalanceReservationDAO;
    @EJB
    private IndividualCounterConfigurationManager individualCounterConfigurationManager;
    @EJB
    private SharedCounterConfigurationDAO sharedCounterConfigurationDAO;
    @EJB
    private PeriodManager periodManager;
    @EJB
    private ModifierService modifierService;
    @EJB
    private HierarchyManager hierarchyManager;
    @EJB
    private PersonalLimitsManager personalLimitsManager;
    private final Map<CounterBalance, SavedCounterBalance> startValues = new HashMap<CounterBalance, SavedCounterBalance>();
    private CounterTransaction currentCounterTransaction = new CounterTransaction();

    @Override
    public void executeAllCounters(ProfileReference profileReference, LimitMatchingParameters matchingParameters, BigDecimal amount, DateTime dateTime, boolean shouldReverseCounters) {
        for (ProfileService profileService : profileReference.getProfile().getServices()) {
            if (AUTHORIZATION_SERVICE.equals(profileService.getName()) && !shouldReverseCounters) continue;
            this.visitService(profileReference, profileService, matchingParameters, amount, dateTime);
        }
    }

    @Override
    public void executeAllRatingCounters(ProfileReference profileReference, LimitMatchingParameters matchingParameters, BigDecimal amount, DateTime initTimestamp, DateTime dateTime) {
        ProfileService ratingService = this.hierarchyManager.findService(profileReference.getProfile(), "Rating");
        if (ratingService != null) {
            this.visitRatingService(profileReference, ratingService, matchingParameters, amount, dateTime, initTimestamp);
        }
    }

    @Override
    public void executeAllCountersNow(ProfileReference profileReference, LimitMatchingParameters matchingParameters, BigDecimal amount, DateTime dateTime) {
        for (ProfileService profileService : profileReference.getProfile().getServices()) {
            this.visitServiceStepCountersNow(profileReference, profileService, matchingParameters, amount, dateTime);
        }
    }

    @Override
    public List<ModifierResponse> executeModifiers(CounterBalance.Type withCounterBalanceType, ProfileReference profileReference, ProfileService profileService, LimitMatchingParameters matchingParameters, BigDecimal amount, DateTime dateTime, Optional<DynamicCounterModifiersRetriever> dynamicCounterModifiers) {
        LinkedList<ModifierResponse> modifierResponses = new LinkedList<ModifierResponse>();
        if (profileService.within(dateTime)) {
            for (CounterConfiguration counterConfiguration : CounterManagerBean.getMatchingCounterConfigurations(profileService, matchingParameters, dateTime)) {
                List<Modifier> dynamicModifiers;
                Object personalLimitResponse;
                CounterBalance counterBalance = this.counterBalanceDAO.findCounterBalance(counterConfiguration, profileReference, dateTime);
                if (counterBalance == null) continue;
                BigDecimal startValue = this.getStartValueFrom(counterBalance, withCounterBalanceType);
                BigDecimal endValue = CounterManagerBean.getCounterBalanceFrom(counterBalance, withCounterBalanceType);
                if (counterConfiguration.isPersonalizedLimitAllowed() && ((Optional)(personalLimitResponse = this.personalLimitsManager.executePersonalModifier(profileReference, counterConfiguration, startValue, endValue, amount))).isPresent()) {
                    modifierResponses.add((ModifierResponse)((Optional)personalLimitResponse).get());
                    if (((ModifierResponse)((Optional)personalLimitResponse).get()).getStatus().equals((Object)ModifierResponse.Status.EXECUTED)) continue;
                }
                personalLimitResponse = CounterManagerBean.getMatchingModifierConfigurations(counterConfiguration, matchingParameters, dateTime).iterator();
                while (personalLimitResponse.hasNext()) {
                    ModifierConfiguration modifierConfiguration = (ModifierConfiguration)personalLimitResponse.next();
                    modifierResponses.add(this.modifierService.executeModifier(modifierConfiguration, profileReference, counterConfiguration, startValue, endValue, amount));
                }
                if (!dynamicCounterModifiers.isPresent() || (dynamicModifiers = dynamicCounterModifiers.get().get(counterConfiguration, profileReference)) == null) continue;
                for (Modifier modifier : dynamicModifiers) {
                    ModifierResponse response = modifier.execute(null, profileReference, counterConfiguration, startValue, endValue, amount);
                    response.setCounterConfiguration(counterConfiguration);
                    response.setModifierConfiguration(null);
                    response.setModifier(modifier);
                    response.setCurrentCounterValue(endValue);
                    modifierResponses.add(response);
                }
            }
        }
        return modifierResponses;
    }

    private BigDecimal getStartValueFrom(CounterBalance counterBalance, CounterBalance.Type withCounterBalanceType) {
        SavedCounterBalance savedStartBalance = this.startValues.get(counterBalance);
        BigDecimal startValue = BigDecimal.ZERO;
        startValue = savedStartBalance != null ? CounterManagerBean.getSavedCounterBalanceFrom(savedStartBalance, withCounterBalanceType) : CounterManagerBean.getCounterBalanceFrom(counterBalance, withCounterBalanceType);
        return startValue;
    }

    @Override
    public void reset() {
        this.startValues.clear();
    }

    @Override
    public void resetAllCounters(ProfileReference profileReference, LimitMatchingParameters matchingParameters, DateTime dateTime) {
        for (ProfileService profileService : profileReference.getProfile().getServices()) {
            this.resetService(profileReference, profileService, matchingParameters, dateTime);
        }
    }

    @Override
    public CounterTransaction createCounterTransaction() {
        this.currentCounterTransaction = new CounterTransaction();
        return new CounterTransaction(this.currentCounterTransaction);
    }

    @Override
    public CounterTransaction getCurrentCounterTransaction() {
        return new CounterTransaction(this.currentCounterTransaction);
    }

    @Override
    public boolean commit(Long counterTransactionId) {
        List<CounterBalanceReservation> activeReservations = this.counterBalanceReservationDAO.findActiveReservationsForTransaction(counterTransactionId);
        for (CounterBalanceReservation reservation : activeReservations) {
            this.commitReservation(reservation);
        }
        return true;
    }

    @Override
    public void rollback(Long counterTransactionId) {
        List<CounterBalanceReservation> activeReservations = this.counterBalanceReservationDAO.findActiveReservationsForTransaction(counterTransactionId);
        for (CounterBalanceReservation reservation : activeReservations) {
            this.rollbackReservation(reservation, CounterBalanceReservation.Status.ROLLEDBACK);
        }
    }

    @Override
    public void finalizeCounterTransaction(Long counterTransactionId) {
        List<CounterBalanceReservation> activeReservations = this.counterBalanceReservationDAO.findActiveReservationsForTransaction(counterTransactionId);
        for (CounterBalanceReservation reservation : activeReservations) {
            this.rollbackReservation(reservation, CounterBalanceReservation.Status.EXPIRED);
        }
    }

    @Override
    public boolean isSubTransactionCreated() {
        return Optional.ofNullable(this.currentCounterTransaction).map(CounterTransaction::isSubTransactionCreated).orElse(false);
    }

    @Override
    public void setSubTransactionId(Long id) {
        if (this.currentCounterTransaction != null) {
            this.currentCounterTransaction.setSubTransactionId(id);
        }
    }

    @Override
    public Optional<Long> getSubTransactionId() {
        return Optional.ofNullable(this.currentCounterTransaction).flatMap(CounterTransaction::getSubTransactionId);
    }

    @Override
    public boolean hasChangedAfterSubTransaction() {
        return this.currentCounterTransaction.hasChangedAfterSubTransaction();
    }

    private void resetService(ProfileReference profileReference, ProfileService profileService, LimitMatchingParameters matchingParameters, DateTime dateTime) {
        if (profileService.within(dateTime)) {
            List<CounterConfiguration> matchingConfigurations = CounterManagerBean.getMatchingCounterConfigurations(profileService, matchingParameters, dateTime);
            for (CounterConfiguration counterConfiguration : matchingConfigurations) {
                CounterBalance counterBalance = this.counterBalanceDAO.findCounterBalance(counterConfiguration, profileReference, dateTime);
                if (counterBalance == null) continue;
                if (!this.startValues.containsKey(counterBalance)) {
                    this.startValues.put(counterBalance, new SavedCounterBalance(counterBalance));
                }
                if (counterBalance.getTotalBalance().equals(BigDecimal.ZERO)) continue;
                counterBalance.resetTotalBalance(BigDecimal.ZERO);
                counterBalance.resetCommittedBalance(BigDecimal.ZERO);
                this.counterBalanceDAO.updateBalance(counterBalance);
            }
        }
        for (ProfileService childService : profileService.getChildren()) {
            this.resetService(profileReference, childService, matchingParameters, dateTime);
        }
    }

    private void visitRatingService(ProfileReference profileReference, ProfileService profileService, LimitMatchingParameters matchingParameters, BigDecimal amount, DateTime dateTime, DateTime initTimestamp) {
        if (dateTime != null && profileService.within(dateTime)) {
            List<CounterConfiguration> matchingConfigurations = CounterManagerBean.getMatchingCounterConfigurations(profileService, matchingParameters, dateTime);
            for (CounterConfiguration counterConfiguration : matchingConfigurations) {
                CounterBalance counterBalance;
                if (amount.compareTo(counterConfiguration.getDefaultValue()) != 0) {
                    counterBalance = this.findOrCreateRatingCounterBalance(profileReference, counterConfiguration, dateTime);
                    counterBalance = this.updateRatingCounterBalance(counterBalance, amount);
                    this.createCounterBalanceReservation(amount.add(counterBalance.getCommittedBalance().negate()), counterBalance, initTimestamp);
                    continue;
                }
                counterBalance = this.counterBalanceDAO.findCounterBalance(counterConfiguration, profileReference, dateTime);
                if (counterBalance == null) continue;
                counterBalance = this.updateRatingCounterBalance(counterBalance, amount);
                this.createCounterBalanceReservation(amount.add(counterBalance.getCommittedBalance().negate()), counterBalance, initTimestamp);
            }
        }
    }

    private void visitService(ProfileReference profileReference, ProfileService profileService, LimitMatchingParameters matchingParameters, BigDecimal amount, DateTime dateTime) {
        if (profileService.within(dateTime)) {
            List<CounterConfiguration> matchingConfigurations = CounterManagerBean.getMatchingCounterConfigurations(profileService, matchingParameters, dateTime);
            for (CounterConfiguration counterConfiguration : matchingConfigurations) {
                CounterBalance counterBalance;
                if (CounterManagerBean.greaterThanZero(amount)) {
                    counterBalance = this.findOrCreateCounterBalance(profileReference, counterConfiguration, dateTime);
                    counterBalance = this.updateCounterBalance(amount, counterBalance);
                    this.createCounterBalanceReservation(amount, counterBalance);
                    continue;
                }
                counterBalance = this.counterBalanceDAO.findCounterBalance(counterConfiguration, profileReference, dateTime);
                if (counterBalance == null) continue;
                this.createCounterBalanceReservation(amount, counterBalance);
            }
        }
        for (ProfileService childService : profileService.getChildren()) {
            this.visitService(profileReference, childService, matchingParameters, amount, dateTime);
        }
    }

    private static List<CounterConfiguration> getMatchingCounterConfigurations(ProfileService profileService, LimitMatchingParameters matchingParameters, DateTime dateTime) {
        ArrayList<CounterConfiguration> allConfigurations = new ArrayList<CounterConfiguration>();
        allConfigurations.addAll(profileService.getIndividualCounterConfigurations());
        allConfigurations.addAll(profileService.getSharedCounterConfigurations());
        return allConfigurations.stream().filter(conf -> CounterMatcher.isMatching(conf, matchingParameters, dateTime)).collect(Collectors.toList());
    }

    private static List<ModifierConfiguration> getMatchingModifierConfigurations(CounterConfiguration counterConfiguration, LimitMatchingParameters matchingParameters, DateTime dateTime) {
        List<ModifierConfiguration> allConfigurations = counterConfiguration.getModifierConfigurations();
        return allConfigurations.stream().filter(conf -> ModifierMatcher.isMatching(conf, matchingParameters, dateTime)).collect(Collectors.toList());
    }

    private CounterBalance updateCounterBalance(BigDecimal amount, CounterBalance counterBalance) {
        this.startValues.put(counterBalance, new SavedCounterBalance(counterBalance));
        counterBalance.updateTotalBalance(amount);
        counterBalance = this.counterBalanceDAO.updateBalance(counterBalance);
        return counterBalance;
    }

    private CounterBalance updateRatingCounterBalance(CounterBalance counterBalance, BigDecimal amount) {
        this.startValues.put(counterBalance, new SavedCounterBalance(counterBalance));
        counterBalance.resetTotalBalance(amount);
        counterBalance = this.counterBalanceDAO.updateBalance(counterBalance);
        return counterBalance;
    }

    private void createCounterBalanceReservation(BigDecimal amount, CounterBalance counterBalance) {
        this.createCounterBalanceReservation(amount, counterBalance, null);
    }

    private void createCounterBalanceReservation(BigDecimal amount, CounterBalance counterBalance, DateTime initTimeStamp) {
        CounterBalanceReservation reservation = new CounterBalanceReservation(this.getOrCreateCurrentCounterTransactionId(), counterBalance.getId(), amount, DateTime.now(), initTimeStamp);
        this.counterBalanceReservationDAO.create(reservation);
        this.currentCounterTransaction.increaseNumberOfReservations();
    }

    private static boolean greaterThanZero(BigDecimal amount) {
        return amount.compareTo(BigDecimal.ZERO) > 0;
    }

    private void visitServiceStepCountersNow(ProfileReference profileReference, ProfileService profileService, LimitMatchingParameters matchingParameters, BigDecimal amount, DateTime dateTime) {
        if (profileService.within(dateTime)) {
            List<CounterConfiguration> matchingConfigurations = CounterManagerBean.getMatchingCounterConfigurations(profileService, matchingParameters, dateTime);
            for (CounterConfiguration counterConfiguration : matchingConfigurations) {
                CounterBalance counterBalance = this.findOrCreateCounterBalance(profileReference, counterConfiguration, dateTime, amount);
                if (counterBalance == null) continue;
                this.startValues.put(counterBalance, new SavedCounterBalance(counterBalance));
                counterBalance.updateTotalBalance(amount);
                counterBalance.updateCommittedBalance(amount);
                this.counterBalanceDAO.updateBalance(counterBalance);
            }
        }
        for (ProfileService childService : profileService.getChildren()) {
            this.visitServiceStepCountersNow(profileReference, childService, matchingParameters, amount, dateTime);
        }
    }

    private Long getOrCreateCurrentCounterTransactionId() {
        if (this.currentCounterTransaction.getId() == null) {
            this.currentCounterTransaction.setId(this.counterBalanceReservationDAO.createCounterBalanceTransaction());
        }
        return this.currentCounterTransaction.getId();
    }

    private CounterBalance findOrCreateCounterBalance(ProfileReference profileReference, CounterConfiguration counterConfiguration, DateTime dateTime, BigDecimal amount) {
        CounterBalance counterBalance = this.counterBalanceDAO.findCounterBalance(counterConfiguration, profileReference, dateTime);
        if (counterBalance == null && CounterManagerBean.greaterThanZero(amount)) {
            counterBalance = this.createCounterBalance(profileReference, counterConfiguration, dateTime);
        }
        return counterBalance;
    }

    private CounterBalance findOrCreateCounterBalance(ProfileReference profileReference, CounterConfiguration counterConfiguration, DateTime dateTime) {
        CounterBalance counterBalance = this.counterBalanceDAO.findCounterBalance(counterConfiguration, profileReference, dateTime);
        if (counterBalance == null) {
            counterBalance = this.createCounterBalance(profileReference, counterConfiguration, dateTime);
        }
        return counterBalance;
    }

    private CounterBalance findOrCreateRatingCounterBalance(ProfileReference profileReference, CounterConfiguration counterConfiguration, DateTime dateTime) {
        CounterBalance counterBalance = this.counterBalanceDAO.findCounterBalance(counterConfiguration, profileReference, dateTime);
        if (counterBalance == null) {
            counterBalance = this.createCounterBalance(profileReference, counterConfiguration, dateTime);
        }
        return counterBalance;
    }

    private CounterBalance createCounterBalance(ProfileReference profileReference, CounterConfiguration counterConfiguration, DateTime dateTime) {
        CounterBalance balance = new CounterBalance();
        this.periodManager.calculatePeriod(counterConfiguration, balance, dateTime);
        return this.counterBalanceDAO.create(balance, counterConfiguration, profileReference);
    }

    private void commitReservation(CounterBalanceReservation reservation) {
        CounterBalance counterBalance = this.counterBalanceDAO.find(reservation.getCounterBalanceId());
        if (counterBalance != null) {
            boolean isNotRatingValueCounterType;
            this.startValues.put(counterBalance, new SavedCounterBalance(counterBalance));
            CounterConfiguration counterConfiguration = this.individualCounterConfigurationManager.find(counterBalance.getCounterConfigurationId());
            if (counterConfiguration == null) {
                counterConfiguration = this.sharedCounterConfigurationDAO.find(counterBalance.getCounterConfigurationId());
            }
            boolean bl = isNotRatingValueCounterType = counterConfiguration != null && counterConfiguration.getCounterType() != RatingCounterType.RATING_VALUE;
            if (reservation.getAmount().compareTo(BigDecimal.ZERO) == -1 && isNotRatingValueCounterType) {
                counterBalance.updateTotalBalance(reservation.getAmount());
            }
            if (reservation.getInitTimestamp() != null) {
                counterBalance.setInitTimestamp(reservation.getInitTimestamp());
            }
            counterBalance.updateCommittedBalance(reservation.getAmount());
            this.counterBalanceDAO.updateBalance(counterBalance);
        } else {
            logger.error("Committed balance counter cannot be updated. CounterBalance reference null in CounterBalanceReservation at commit");
        }
        reservation.setStatus(CounterBalanceReservation.Status.COMMITTED);
        this.counterBalanceReservationDAO.updateCounterBalanceReservation(reservation);
    }

    private void rollbackReservation(CounterBalanceReservation reservation, CounterBalanceReservation.Status nextStatus) {
        CounterBalance counterBalance = this.counterBalanceDAO.find(reservation.getCounterBalanceId());
        if (counterBalance != null) {
            boolean isRatingValueCounterType;
            CounterConfiguration counterConfiguration = this.individualCounterConfigurationManager.find(counterBalance.getCounterConfigurationId());
            if (counterConfiguration == null) {
                counterConfiguration = this.sharedCounterConfigurationDAO.find(counterBalance.getCounterConfigurationId());
            }
            boolean bl = isRatingValueCounterType = counterConfiguration != null && counterConfiguration.getCounterType() == RatingCounterType.RATING_VALUE;
            if (reservation.getAmount().compareTo(BigDecimal.ZERO) == 1 || isRatingValueCounterType) {
                this.startValues.put(counterBalance, new SavedCounterBalance(counterBalance));
                counterBalance.updateTotalBalance(reservation.getAmount().negate());
                this.counterBalanceDAO.updateBalance(counterBalance);
            }
        } else {
            logger.error("Total balance counter cannot be updated. CounterBalance reference null in CounterBalanceReservation at rollback");
        }
        reservation.setStatus(nextStatus);
        this.counterBalanceReservationDAO.updateCounterBalanceReservation(reservation);
    }

    private static BigDecimal getSavedCounterBalanceFrom(SavedCounterBalance savedCounterBalance, CounterBalance.Type counterBalanceType) {
        return CounterBalance.Type.TOTAL_BALANCE == counterBalanceType ? savedCounterBalance.totalBalance : savedCounterBalance.committedBalance;
    }

    private static BigDecimal getCounterBalanceFrom(CounterBalance counterBalance, CounterBalance.Type counterBalanceType) {
        return CounterBalance.Type.TOTAL_BALANCE == counterBalanceType ? counterBalance.getTotalBalance() : counterBalance.getCommittedBalance();
    }

    private static class SavedCounterBalance {
        private final BigDecimal totalBalance;
        private final BigDecimal committedBalance;

        public SavedCounterBalance(CounterBalance counterBalance) {
            this.totalBalance = counterBalance.getTotalBalance();
            this.committedBalance = counterBalance.getCommittedBalance();
        }
    }
}

