/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.counters;

import com.ericsson.em.emc.notificationclient.NotificationOperationType;
import java.util.ArrayList;
import java.util.List;

public enum LoginCounterNotificationOperationType implements NotificationOperationType
{
    LOGIN_COUNTER_EXCEEDED("Your account is locked due to too many failed login attempts (max {MAX_LOGIN_ATTEMPTS}). Please reset your password.", "MAX_LOGIN_ATTEMPTS"),
    LOGIN_COUNTER_SOFT_LIMIT_REACHED("Your account is temporary suspended due to too many failed login attempts. You can try to login again in approximately {RETRY_IN_MINUTES} minutes time.", "RETRY_IN_MINUTES");

    private final String defaultMessage;
    private final List<String> parameters;

    private LoginCounterNotificationOperationType(String defaultMessage, String ... paramStrings) {
        this.defaultMessage = defaultMessage;
        this.parameters = new ArrayList<String>(paramStrings.length);
        for (String val : paramStrings) {
            this.parameters.add(val);
        }
    }

    @Override
    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public int getNumberOfParameters() {
        return this.parameters.size();
    }

    @Override
    public String getParameterName(int index) {
        return this.parameters.get(index);
    }

    public static LoginCounterNotificationOperationType withName(String name) {
        for (LoginCounterNotificationOperationType notification : LoginCounterNotificationOperationType.values()) {
            if (!notification.getName().equals(name)) continue;
            return notification;
        }
        return null;
    }
}

