/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.counters.move;

import com.ericsson.em.emc.hierarchies.counters.move.CounterBalanceMoveParameters;
import com.ericsson.em.emc.hierarchies.persistence.CounterBalance;
import com.ericsson.em.emc.hierarchies.persistence.CounterBalanceDAO;
import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.ModifierConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.PersonalModifierConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.PersonalModifierConfigurationDAO;
import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.hierarchies.persistence.ProfileReference;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joda.time.DateTime;

public final class CounterBalanceMove {
    private static final int EQUAL = 0;
    private static final String AUTHORIZATION_SERVICE = "Authorization";
    private static final String RATING_SERVICE = "Rating";
    private final DateTime dateTime;
    private final CounterBalanceDAO counterBalanceDAO;
    private final PersonalModifierConfigurationDAO personalModifierConfigurationDAO;
    private final ProfileReference sourceProfileReference;
    private final ProfileReference targetProfileReference;
    private static final Comparator<CounterConfiguration> byType = (cc1, cc2) -> cc1.getCounterType().getName().compareTo(cc2.getCounterType().getName());
    private static final Comparator<CounterConfiguration> byUnit = (cc1, cc2) -> cc1.getUnit().getValue().compareTo(cc2.getUnit().getValue());
    private static final Comparator<CounterConfiguration> byPeriod = (cc1, cc2) -> cc1.getPeriodType().compareTo(cc2.getPeriodType());
    private static final Comparator<CounterConfiguration> counterConfigurationIdentifierMatcher = byType.thenComparing(byUnit).thenComparing(byPeriod);

    public static void move(CounterBalanceMoveParameters migrationParams) {
        CounterBalanceMove cbm = new CounterBalanceMove(migrationParams);
        cbm.move();
    }

    private static Supplier<Stream<IndividualCounterConfiguration>> getCounterConfigurationsForProfile(Profile profile) {
        ArrayList<String> services = new ArrayList<String>();
        services.add(AUTHORIZATION_SERVICE);
        services.add(RATING_SERVICE);
        return () -> CounterBalanceMove.findServicesInProfile(profile, services).get().flatMap(x -> x.getIndividualCounterConfigurations().stream());
    }

    private static Supplier<Stream<ProfileService>> findServicesInProfile(Profile profile, List<String> profileServicesName) {
        return () -> profile.getServices().stream().flatMap(s -> Stream.concat(Stream.of(s), s.getChildren().stream())).collect(Collectors.toList()).stream().filter(x -> profileServicesName.contains(x.getName()));
    }

    private CounterBalanceMove(CounterBalanceMoveParameters migrationParams) {
        this.counterBalanceDAO = migrationParams.getCounterBalanceDAO();
        this.sourceProfileReference = migrationParams.getFromProfileReference();
        this.targetProfileReference = migrationParams.getToProfileReference();
        this.dateTime = migrationParams.getDateTime();
        this.personalModifierConfigurationDAO = migrationParams.getPersonalModifierConfigurationDAO();
    }

    private void move() {
        if (this.sourceProfileReference.getProfile() != null) {
            Supplier<Stream<IndividualCounterConfiguration>> sourceCounterConfigurations = CounterBalanceMove.getCounterConfigurationsForProfile(this.sourceProfileReference.getProfile());
            Supplier<Stream<IndividualCounterConfiguration>> targetCounterConfigurations = CounterBalanceMove.getCounterConfigurationsForProfile(this.targetProfileReference.getProfile());
            List<IndividualCounterConfiguration> sourceCounterConfigurationList = sourceCounterConfigurations.get().collect(Collectors.toList());
            targetCounterConfigurations.get().forEach(cc -> this.processConfiguration((IndividualCounterConfiguration)cc, sourceCounterConfigurationList.stream()));
            sourceCounterConfigurationList.forEach(this::deleteObsoletePersonalLimits);
        }
    }

    private void processConfiguration(IndividualCounterConfiguration targetCounterConfiguration, Stream<IndividualCounterConfiguration> sourceCounterConfigurations) {
        sourceCounterConfigurations.filter(x -> x.matchesOnIdentifier(targetCounterConfiguration)).forEach(x -> this.moveBalanceToMatchingCounterConfig((CounterConfiguration)x, targetCounterConfiguration));
    }

    private void moveBalanceToMatchingCounterConfig(CounterConfiguration source, CounterConfiguration target) {
        CounterBalance fromBalance = this.counterBalanceDAO.findCounterBalance(source, this.sourceProfileReference, this.dateTime);
        if (fromBalance != null && counterConfigurationIdentifierMatcher.compare(source, target) == 0) {
            this.counterBalanceDAO.updateBalanceProfileAndConfigurationReference(fromBalance, this.targetProfileReference, target);
        }
        if (source.isPersonalizedLimitAllowed() && target.isPersonalizedLimitAllowed()) {
            this.movePersonalLimit(source, target);
        }
    }

    private void movePersonalLimit(CounterConfiguration source, CounterConfiguration target) {
        PersonalModifierConfiguration personalModifierConfiguration = this.personalModifierConfigurationDAO.find(source, this.sourceProfileReference);
        if (personalModifierConfiguration != null) {
            if (target.getModifierConfigurations().size() == 1) {
                ModifierConfiguration defaultLimit = target.getModifierConfigurations().get(0);
                if (personalModifierConfiguration.getStartValue().compareTo(defaultLimit.getStartValue()) > 0) {
                    return;
                }
            }
            personalModifierConfiguration.setProfileReference(this.targetProfileReference);
            personalModifierConfiguration.setCounterConfiguration(target);
            this.personalModifierConfigurationDAO.update(personalModifierConfiguration);
        }
    }

    private void deleteObsoletePersonalLimits(CounterConfiguration source) {
        PersonalModifierConfiguration personalModifierConfiguration;
        if (source.isPersonalizedLimitAllowed() && (personalModifierConfiguration = this.personalModifierConfigurationDAO.find(source, this.sourceProfileReference)) != null) {
            this.personalModifierConfigurationDAO.delete(personalModifierConfiguration);
        }
    }
}

