/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.persistence.MatchRuleToUpdateFP;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.FingerprintUpdateResultSetProcessor;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.database.persistence.EntityResultSetProcessor;
import com.google.common.collect.Lists;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;

abstract class AbstractMatchRuleFPDAOBean
extends CryptoExtendedBaseEntityDAOBean<MatchRuleToUpdateFP> {
    private static final short TRUE = 1;
    private static final short FALSE = 0;
    static final int DEFAULT_FINGERPRINT_VERSION = 1;
    static final int CURRENT_FINGERPRINT_VERSION = 2;
    private static final List<TableColumn> TABLE_COLUMNS = Lists.newArrayList(TableColumn.values());

    AbstractMatchRuleFPDAOBean() {
    }

    public String[] getColumns() {
        return (String[])TABLE_COLUMNS.stream().map(Enum::name).map(this::convertForeignKeyColumn).toArray(String[]::new);
    }

    private String convertForeignKeyColumn(String columnName) {
        return columnName.equals(TableColumn.owner_fk.name()) ? this.getForeignKeyColumn() : columnName;
    }

    public String getSequenceName() {
        return this.getTableName() + "_seq";
    }

    public boolean isVersionable() {
        return false;
    }

    public boolean isUpdatable() {
        return true;
    }

    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        MatchRuleToUpdateFP matchRule = (MatchRuleToUpdateFP)baseEntity;
        preparedStatement.setString(TableColumn.dynamicparameters.index(), matchRule.getDynamicParametersAsJson());
        preparedStatement.setShort(TableColumn.exclusion.index(), matchRule.isExclusion() ? (short)1 : 0);
        preparedStatement.setLong(TableColumn.owner_fk.index(), matchRule.getOwnerId());
        preparedStatement.setString(TableColumn.operationtype.index(), matchRule.getOperationType());
        return this.assignFingerprint(preparedStatement, TableColumn.fingerprint.index(), new Object[]{matchRule.isExclusion() ? 1 : 0, matchRule.getOperationType(), matchRule.getDynamicParametersAsJson(), matchRule.getOwnerId()});
    }

    protected void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        MatchRuleToUpdateFP matchRule = (MatchRuleToUpdateFP)baseEntity;
        matchRule.setDynamicParametersFromJson(resultSet.getString(TableColumn.dynamicparameters.name()));
        matchRule.setExclusion(resultSet.getShort(TableColumn.exclusion.name()) == 1);
        matchRule.setOperationType(resultSet.getString(TableColumn.operationtype.name()));
        matchRule.setOwnerId(resultSet.getLong(this.getForeignKeyColumn()));
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1 || fingerprintVersion == 2) {
            return new Object[]{resultSet.getInt(TableColumn.exclusion.name()), resultSet.getString(TableColumn.operationtype.name()), resultSet.getString(TableColumn.dynamicparameters.name()), resultSet.getLong(this.getForeignKeyColumn())};
        }
        return null;
    }

    public MatchRuleToUpdateFP update(MatchRuleToUpdateFP entry) {
        return (MatchRuleToUpdateFP)super.update((BaseEntity)entry);
    }

    protected abstract String getForeignKeyColumn();

    public MatchRuleToUpdateFP updateDefaultFingerprint(MatchRuleToUpdateFP entry) {
        return Optional.ofNullable(entry).map(entity -> (MatchRuleToUpdateFP)this.updateWithFingerprintVersionCheck((BaseEntity)entity, 1)).orElse(entry);
    }

    public long updateDefaultFingerprintUsingResultSetProcessor(long batchSize, FingerprintUpdateResultSetProcessor fpResultSetProcessor) {
        if (this.isDefaultData()) {
            return 0L;
        }
        return this.processEntityResultSet("select * from (" + this.getSelectStatement() + " where " + TableColumn.fingerprintversion + "= ? order by " + TableColumn.id + ") WHERE rownum <= ?", (EntityResultSetProcessor)fpResultSetProcessor, new Object[]{1, batchSize});
    }

    static enum TableColumn {
        id,
        exclusion,
        operationtype,
        dynamicparameters,
        owner_fk,
        fingerprint,
        fingerprintversion,
        fingerprintkeygeneration;


        int index() {
            return this.ordinal();
        }
    }
}

