/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.ParametersBuilderFactory;
import com.ericsson.em.emc.hierarchies.Unit;
import com.ericsson.em.emc.hierarchies.limits.CounterType;
import com.ericsson.em.emc.hierarchies.persistence.Periodizable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Optional;

@SuppressWarnings(value={"UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"}, justification="Fields will be initialized by builder")
public final class CounterIdentifierMatchParameters
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Optional<String> identifier = Optional.empty();
    private CounterType counterType;
    private Unit unit;
    private Periodizable.PeriodType periodType;
    private int periodLength;

    public static MandatoryCounterType build() {
        return ParametersBuilderFactory.create(MandatoryCounterType.class, new CounterIdentifierMatchParameters());
    }

    protected CounterIdentifierMatchParameters() {
    }

    public CounterType getCounterType() {
        return this.counterType;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Periodizable.PeriodType getPeriodType() {
        return this.periodType;
    }

    public int getPeriodLength() {
        return this.periodLength;
    }

    public Optional<String> getIdentifier() {
        return this.identifier;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.identifier.orElse(null));
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.identifier = Optional.ofNullable((String)ois.readObject());
    }

    public static interface OptionalCounterIdentifier
    extends ParametersBuilderFactory.OptionalParameters<CounterIdentifierMatchParameters> {
        public OptionalCounterIdentifier identifier(String var1);
    }

    public static interface MandatoryPeriodLength {
        public OptionalCounterIdentifier periodLength(int var1);
    }

    public static interface MandatoryPeriodType {
        public MandatoryPeriodLength periodType(Periodizable.PeriodType var1);
    }

    public static interface MandatoryUnit {
        public MandatoryPeriodType unit(Unit var1);
    }

    public static interface MandatoryCounterType {
        public MandatoryUnit counterType(CounterType var1);
    }
}

