/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.persistence.GlobalParameterErrorCode;
import com.ericsson.lwac.ValidationException;
import com.ericsson.lwac.cache.Cacheable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import jakarta.persistence.Entity;

@Entity
public class GlobalParameter
extends BaseEntity
implements Cacheable<GlobalParameter> {
    private static final long serialVersionUID = 1L;
    private String key;
    private String value;
    private String dataType;
    private long version = 1L;

    public GlobalParameter() {
    }

    public GlobalParameter(String key) {
        this.key = key;
    }

    protected GlobalParameter(GlobalParameter globalParameter) {
        super((BaseEntity)globalParameter);
        this.key = globalParameter.getKey();
        this.value = globalParameter.getValue();
        this.dataType = globalParameter.getDataType();
        this.version = globalParameter.getVersion();
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    protected void validate() {
        if (this.key == null || this.key.trim().isEmpty()) {
            throw new ValidationException(GlobalParameterErrorCode.GLOBALPARAMETER_KEY_INVALID.getMessage());
        }
        if (this.dataType == null || this.dataType.trim().isEmpty()) {
            throw new ValidationException(GlobalParameterErrorCode.GLOBALPARAMETER_DATATYPE_INVALID.getMessage());
        }
        if (this.version <= 0L) {
            throw new ValidationException(GlobalParameterErrorCode.GLOBALPARAMETER_VERSION_INVALID.getMessage());
        }
    }

    public String toString() {
        return "com.ericsson.em.emc.hierarchies.persistence.GlobalParameter[id=" + this.mId + "]";
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void increaseVersion() {
        ++this.version;
    }

    @Override
    public GlobalParameter deepClone() {
        return new GlobalParameter(this);
    }

    void setVersion(long version) {
        this.version = version;
    }
}

