/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.Unit;
import com.ericsson.em.emc.hierarchies.counters.CounterTypeRegistry;
import com.ericsson.em.emc.hierarchies.limits.CounterType;
import com.ericsson.em.emc.hierarchies.limits.LegacyLimitsConverter;
import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfigurationFPDAO;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfigurationToUpdateFP;
import com.ericsson.em.emc.hierarchies.persistence.ModifierMatchRule;
import com.ericsson.em.emc.hierarchies.persistence.PeriodizableManagerBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.FingerprintUpdateResultSetProcessor;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.database.persistence.EntityResultSetProcessor;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.joda.time.DateTime;

@Updatable
@Validatable
@Singleton
@CryptoKeys(keyAliases={"hier.counterconfiguration.S"})
public class IndividualCounterConfigurationFPDAOBean
extends PeriodizableManagerBean<IndividualCounterConfigurationToUpdateFP>
implements IndividualCounterConfigurationFPDAO {
    @EJB
    private CounterTypeRegistry counterTypeRegistry;
    static final String FINGERPRINT_KEY = "hier.counterconfiguration.S";
    private static final int CURRENT_FINGERPRINT_VERSION = 3;
    private static final String TABLE_NAME = "hier$counterconfiguration";
    private static final String TABLE_SEQUENCE_NAME = "hier$counterconfiguration_seq";

    @Override
    public int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        IndividualCounterConfigurationToUpdateFP individualCounterConfiguration = (IndividualCounterConfigurationToUpdateFP)baseEntity;
        DateTime startDateTime = individualCounterConfiguration.getStartDateTime();
        DateTime endDateTime = individualCounterConfiguration.getEndDateTime();
        int i = 1;
        preparedStatement.setString(i++, individualCounterConfiguration.getCounterType().getName());
        if (startDateTime != null) {
            preparedStatement.setTimestamp(i++, new Timestamp(startDateTime.getMillis()));
        } else {
            preparedStatement.setNull(i++, 93);
        }
        if (endDateTime != null) {
            preparedStatement.setTimestamp(i++, new Timestamp(endDateTime.getMillis()));
        } else {
            preparedStatement.setNull(i++, 93);
        }
        preparedStatement.setInt(i++, individualCounterConfiguration.getPeriodType().ordinal());
        preparedStatement.setString(i++, individualCounterConfiguration.isBalanceReuseable() ? "Y" : "N");
        preparedStatement.setInt(i++, individualCounterConfiguration.getPeriodLength());
        preparedStatement.setInt(i++, individualCounterConfiguration.getStartDayInMonth());
        preparedStatement.setString(i++, individualCounterConfiguration.getName());
        preparedStatement.setString(i++, individualCounterConfiguration.getExternalId());
        preparedStatement.setString(i++, null);
        preparedStatement.setString(i++, null);
        preparedStatement.setString(i++, individualCounterConfiguration.hasUnit() ? individualCounterConfiguration.getUnit().getValue() : null);
        preparedStatement.setInt(i++, individualCounterConfiguration.getDynamicType().ordinal());
        preparedStatement.setInt(i++, individualCounterConfiguration.getDynamicLength());
        preparedStatement.setLong(i++, individualCounterConfiguration.getFk_service());
        preparedStatement.setString(i++, individualCounterConfiguration.isHardLimitNotificationsEnabled() ? "Y" : "N");
        preparedStatement.setString(i++, individualCounterConfiguration.getHardLimitNotificationOperationTypeName());
        preparedStatement.setString(i++, individualCounterConfiguration.getDescription());
        preparedStatement.setString(i++, individualCounterConfiguration.getIdentifier());
        preparedStatement.setBigDecimal(i++, individualCounterConfiguration.getDefaultValue());
        preparedStatement.setBoolean(i++, individualCounterConfiguration.isPersonalizedLimitAllowed());
        return this.assignFingerprint(preparedStatement, i, new Object[]{individualCounterConfiguration.getCounterType().getName(), null != startDateTime ? new Timestamp(startDateTime.getMillis()) : null, null != endDateTime ? new Timestamp(endDateTime.getMillis()) : null, individualCounterConfiguration.getPeriodType().ordinal(), individualCounterConfiguration.isBalanceReuseable() ? "Y" : "N", individualCounterConfiguration.getPeriodLength(), individualCounterConfiguration.getStartDayInMonth(), individualCounterConfiguration.getName(), individualCounterConfiguration.getExternalId(), individualCounterConfiguration.getUnit().getValue(), individualCounterConfiguration.getDynamicType().ordinal(), individualCounterConfiguration.getDynamicLength(), individualCounterConfiguration.getFk_service(), individualCounterConfiguration.isHardLimitNotificationsEnabled() ? "Y" : "N", individualCounterConfiguration.getHardLimitNotificationOperationTypeName(), individualCounterConfiguration.getDescription(), individualCounterConfiguration.getIdentifier(), individualCounterConfiguration.getDefaultValue(), individualCounterConfiguration.isPersonalizedLimitAllowed()});
    }

    @Override
    public void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        IndividualCounterConfigurationToUpdateFP individualCounterConfiguration = (IndividualCounterConfigurationToUpdateFP)baseEntity;
        String counterTypeStr = MoreObjects.firstNonNull(resultSet.getString(TableColumn.COUNTERTYPE.name()), CounterConfiguration.NoCounterType.NONE.getName());
        CounterType counterType = this.counterTypeRegistry.getCounterType(counterTypeStr).orElseThrow(() -> new IllegalArgumentException("Unable to find counter type " + counterTypeStr));
        individualCounterConfiguration.setCounterType(counterType);
        individualCounterConfiguration.setName(resultSet.getString(TableColumn.NAME.name()));
        individualCounterConfiguration.setExternalId(resultSet.getString(TableColumn.EXTERNALID.name()));
        IndividualCounterConfigurationFPDAOBean.handleLegacyUnitTypeField(resultSet, individualCounterConfiguration);
        int dynamicTypeOrdinal = resultSet.getInt(TableColumn.DYNAMICTYPE.name());
        for (CounterConfiguration.DynamicType dynamicType : CounterConfiguration.DynamicType.values()) {
            if (dynamicType.ordinal() != dynamicTypeOrdinal) continue;
            individualCounterConfiguration.setDynamicType(dynamicType);
            break;
        }
        individualCounterConfiguration.setDynamicLength(resultSet.getInt(TableColumn.DYNAMICLENGTH.name()));
        individualCounterConfiguration.setHardLimitNotificationsEnabled(resultSet.getString(TableColumn.HARDLIMITNOTIFICATIONSENABLED.name()).equals("Y"));
        individualCounterConfiguration.setHardLimitNotificationOperationTypeName(resultSet.getString(TableColumn.HARDLIMITNOTIFICATIONNAME.name()));
        individualCounterConfiguration.setDescription(resultSet.getString(TableColumn.DESCRIPTION.name()));
        individualCounterConfiguration.setIdentifier(resultSet.getString(TableColumn.IDENTIFIER.name()));
        individualCounterConfiguration.setUnit(Unit.fromString(resultSet.getString(TableColumn.UNIT.name())));
        individualCounterConfiguration.setDefaultValue(resultSet.getBigDecimal(TableColumn.DEFAULTVALUE.name()));
        individualCounterConfiguration.setPersonalizedLimitAllowed(resultSet.getBoolean(TableColumn.ALLOWPERSONALLIMIT.name()));
        IndividualCounterConfigurationFPDAOBean.handleLegacyModifierUnitTypeField(resultSet, individualCounterConfiguration);
        individualCounterConfiguration.setFk_service(resultSet.getLong(TableColumn.FK_SERVICE.name()));
    }

    private static void handleLegacyUnitTypeField(ResultSet resultSet, CounterConfiguration counterConfiguration) throws SQLException {
        String unitType = resultSet.getString(TableColumn.UNITTYPE.name());
        if (Strings.isNullOrEmpty(unitType)) {
            return;
        }
        counterConfiguration.setCounterType(LegacyLimitsConverter.extractCounterTypeFrom(unitType));
        counterConfiguration.setMatchRules(LegacyLimitsConverter.convertToCounterMatchRules(unitType));
    }

    private static void handleLegacyModifierUnitTypeField(ResultSet resultSet, CounterConfiguration counterConfiguration) throws SQLException {
        String modifierUnitType = resultSet.getString(TableColumn.MODIFIERUNITTYPE.name());
        List<ModifierMatchRule> matchRules = LegacyLimitsConverter.convertToModifierMatchRules(modifierUnitType);
        if (!matchRules.isEmpty()) {
            counterConfiguration.getModifierConfigurations().forEach(mc -> mc.setMatchRules(matchRules));
        }
    }

    public IndividualCounterConfigurationToUpdateFP update(IndividualCounterConfigurationToUpdateFP entry) {
        return (IndividualCounterConfigurationToUpdateFP)super.update((BaseEntity)entry);
    }

    public IndividualCounterConfigurationToUpdateFP updateDefaultFingerprint(IndividualCounterConfigurationToUpdateFP entry) {
        return (IndividualCounterConfigurationToUpdateFP)this.updateWithFingerprintVersionCheck(entry, 1);
    }

    public long updateDefaultFingerprintUsingResultSetProcessor(long batchSize, FingerprintUpdateResultSetProcessor fpResultSetProcessor) {
        if (this.isDefaultData()) {
            return 0L;
        }
        return this.processEntityResultSet("select * from (" + this.getSelectStatement() + " where " + TableColumn.FINGERPRINTVERSION + "= ? order by " + TableColumn.ID + ") WHERE rownum <= ?", (EntityResultSetProcessor)fpResultSetProcessor, new Object[]{1, batchSize});
    }

    public String[] getColumns() {
        return (String[])Arrays.stream(TableColumn.values()).map(Enum::name).toArray(String[]::new);
    }

    public IndividualCounterConfigurationToUpdateFP createManagedEntity() {
        return new IndividualCounterConfigurationToUpdateFP();
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    public String getSequenceName() {
        return TABLE_SEQUENCE_NAME;
    }

    public boolean isVersionable() {
        return false;
    }

    public boolean isUpdatable() {
        return true;
    }

    protected String getEntitySimpleName() {
        return IndividualCounterConfiguration.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 3;
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1 || fingerprintVersion == 2) {
            return new Object[]{resultSet.getString(TableColumn.COUNTERTYPE.name()), resultSet.getTimestamp(TableColumn.STARTDATETIME.name()), resultSet.getTimestamp(TableColumn.ENDDATETIME.name()), resultSet.getInt(TableColumn.PERIODTYPE.name()), resultSet.getString(TableColumn.BALANCEREUSEABLE.name()), resultSet.getInt(TableColumn.PERIODLENGTH.name()), resultSet.getInt(TableColumn.STARTDAYINMONTH.name()), resultSet.getString(TableColumn.NAME.name()), resultSet.getString(TableColumn.EXTERNALID.name()), resultSet.getString(TableColumn.UNIT.name()), resultSet.getInt(TableColumn.DYNAMICTYPE.name()), resultSet.getInt(TableColumn.DYNAMICLENGTH.name()), resultSet.getLong(TableColumn.FK_SERVICE.name()), resultSet.getString(TableColumn.HARDLIMITNOTIFICATIONSENABLED.name()), resultSet.getString(TableColumn.HARDLIMITNOTIFICATIONNAME.name()), resultSet.getString(TableColumn.DESCRIPTION.name()), resultSet.getString(TableColumn.IDENTIFIER.name()), resultSet.getBigDecimal(TableColumn.DEFAULTVALUE.name())};
        }
        if (fingerprintVersion == 3) {
            return new Object[]{resultSet.getString(TableColumn.COUNTERTYPE.name()), resultSet.getTimestamp(TableColumn.STARTDATETIME.name()), resultSet.getTimestamp(TableColumn.ENDDATETIME.name()), resultSet.getInt(TableColumn.PERIODTYPE.name()), resultSet.getString(TableColumn.BALANCEREUSEABLE.name()), resultSet.getInt(TableColumn.PERIODLENGTH.name()), resultSet.getInt(TableColumn.STARTDAYINMONTH.name()), resultSet.getString(TableColumn.NAME.name()), resultSet.getString(TableColumn.EXTERNALID.name()), resultSet.getString(TableColumn.UNIT.name()), resultSet.getInt(TableColumn.DYNAMICTYPE.name()), resultSet.getInt(TableColumn.DYNAMICLENGTH.name()), resultSet.getLong(TableColumn.FK_SERVICE.name()), resultSet.getString(TableColumn.HARDLIMITNOTIFICATIONSENABLED.name()), resultSet.getString(TableColumn.HARDLIMITNOTIFICATIONNAME.name()), resultSet.getString(TableColumn.DESCRIPTION.name()), resultSet.getString(TableColumn.IDENTIFIER.name()), resultSet.getBigDecimal(TableColumn.DEFAULTVALUE.name()), resultSet.getBoolean(TableColumn.ALLOWPERSONALLIMIT.name())};
        }
        return null;
    }

    private static enum TableColumn {
        ID,
        COUNTERTYPE,
        STARTDATETIME,
        ENDDATETIME,
        PERIODTYPE,
        BALANCEREUSEABLE,
        PERIODLENGTH,
        STARTDAYINMONTH,
        NAME,
        EXTERNALID,
        UNITTYPE,
        MODIFIERUNITTYPE,
        UNIT,
        DYNAMICTYPE,
        DYNAMICLENGTH,
        FK_SERVICE,
        HARDLIMITNOTIFICATIONSENABLED,
        HARDLIMITNOTIFICATIONNAME,
        DESCRIPTION,
        IDENTIFIER,
        DEFAULTVALUE,
        ALLOWPERSONALLIMIT,
        FINGERPRINT,
        FINGERPRINTVERSION,
        FINGERPRINTKEYGENERATION;


        int index() {
            return this.ordinal();
        }
    }
}

