/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.CoreUserErrorCode;
import com.ericsson.em.emc.UserExceptionBuilder;
import com.ericsson.em.emc.hierarchies.ProfileConfigurationService;
import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.CounterIdentifierMatchParameters;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfigurationDAO;
import com.ericsson.em.emc.hierarchies.persistence.IndividualCounterConfigurationManager;
import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import com.ericsson.em.m3if.admin.common.CounterIdValue;
import com.google.common.base.Strings;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Singleton
public class IndividualCounterConfigurationManagerBean
implements IndividualCounterConfigurationManager {
    @EJB
    private IndividualCounterConfigurationDAO individualCounterConfigurationDAO;
    @Resource
    private ProfileConfigurationService profileConfigurationService;

    @Override
    public IndividualCounterConfiguration update(IndividualCounterConfiguration individualCounterConfiguration) {
        return this.individualCounterConfigurationDAO.update(individualCounterConfiguration);
    }

    @Override
    public IndividualCounterConfiguration create(IndividualCounterConfiguration individualCounterConfiguration, ProfileService profileService) {
        return this.create(individualCounterConfiguration, profileService, false);
    }

    @Override
    public IndividualCounterConfiguration create(IndividualCounterConfiguration individualCounterConfiguration, ProfileService profileService, boolean isExceededLimitOfRatingCountersAllowed) {
        long numberOfRatingCounters;
        if (!isExceededLimitOfRatingCountersAllowed && individualCounterConfiguration.isRatingCounter() && (numberOfRatingCounters = this.getNumberOfRatingCountersInCurrentProfile(profileService)) >= (long)this.profileConfigurationService.getMaximumNumberOfRatingCounters()) {
            throw new UserExceptionBuilder(CoreUserErrorCode.TOO_MANY_RATING_COUNTERS_IN_PROFILE).add("message", "Maximum number of allowed rating counters has been reached").create();
        }
        return this.individualCounterConfigurationDAO.create(individualCounterConfiguration, profileService);
    }

    private long getNumberOfRatingCountersInCurrentProfile(ProfileService profileService) {
        Map<Long, List<IndividualCounterConfiguration>> allCounterConfigurations = this.individualCounterConfigurationDAO.findAllCounterConfigurations(profileService.getProfile());
        return allCounterConfigurations.values().stream().flatMap(Collection::stream).filter(Objects::nonNull).filter(CounterConfiguration::isRatingCounter).count();
    }

    @Override
    public IndividualCounterConfiguration find(long id) {
        return this.individualCounterConfigurationDAO.find(id);
    }

    @Override
    public List<IndividualCounterConfiguration> findByService(ProfileService profileService) {
        return this.individualCounterConfigurationDAO.findByService(profileService);
    }

    @Override
    public void delete(IndividualCounterConfiguration individualCounterConfiguration) {
        this.individualCounterConfigurationDAO.delete(individualCounterConfiguration);
    }

    @Override
    public void deleteByService(ProfileService profileService) {
        this.individualCounterConfigurationDAO.deleteByService(profileService);
    }

    @Override
    public List<IndividualCounterConfiguration> findByMatchingAttributes(CounterIdentifierMatchParameters params) {
        return this.individualCounterConfigurationDAO.findByMatchingAttributes(params);
    }

    @Override
    public List<IndividualCounterConfiguration> findByIdentifier(String identifier) {
        return this.individualCounterConfigurationDAO.findByIdentifier(identifier);
    }

    @Override
    public List<IndividualCounterConfiguration> findByIdentifierAndCounterId(String identifier, CounterIdValue counterId) {
        return this.individualCounterConfigurationDAO.findByIdentifierAndCounterId(identifier, counterId);
    }

    @Override
    public boolean isIdentifierValidFor(CounterIdentifierMatchParameters params) {
        List<IndividualCounterConfiguration> matchingCCs = this.findByIdentifier(params.getIdentifier().orElse(""));
        if (Strings.isNullOrEmpty(params.getIdentifier().orElse(null)) || matchingCCs.isEmpty()) {
            return true;
        }
        return matchingCCs.stream().anyMatch(cc -> cc.getCounterType().equals(params.getCounterType()) && cc.getUnit().equals(params.getUnit()) && cc.getPeriodType().equals((Object)params.getPeriodType()) && cc.getPeriodLength() == params.getPeriodLength());
    }

    @Override
    public boolean isIdentifierValidForCounter(CounterIdentifierMatchParameters params, CounterIdValue counterId) {
        List<IndividualCounterConfiguration> matchingCCs = this.findByIdentifierAndCounterId(params.getIdentifier().orElse(""), counterId);
        if (Strings.isNullOrEmpty(params.getIdentifier().orElse(null)) || matchingCCs == null || matchingCCs.isEmpty()) {
            return true;
        }
        return matchingCCs.stream().anyMatch(cc -> cc.getCounterType().equals(params.getCounterType()) && cc.getUnit().equals(params.getUnit()) && cc.getPeriodType().equals((Object)params.getPeriodType()) && cc.getPeriodLength() == params.getPeriodLength());
    }

    @Override
    public Map<Long, List<IndividualCounterConfiguration>> findAllCounterConfigurations(Profile profile) {
        return this.individualCounterConfigurationDAO.findAllCounterConfigurations(profile);
    }
}

