/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.persistence.DeepCloneable;
import com.google.common.base.CaseFormat;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;

public abstract class MatchRule<T extends MatchRule<T>>
extends BaseEntity
implements DeepCloneable<T> {
    public static final String ALL = "*";
    private static final long serialVersionUID = 1602734109650563154L;
    private String operationType = "*";
    private boolean exclusion = false;
    protected final Map<String, String> matchingProperties = Maps.newHashMap();

    protected MatchRule() {
    }

    protected MatchRule(MatchRule<T> original) {
        this.operationType = original.operationType;
        this.exclusion = original.exclusion;
        this.matchingProperties.putAll(original.matchingProperties);
    }

    public Optional<String> getProperty(String propertyName) {
        return Optional.ofNullable(this.matchingProperties.get(Preconditions.checkNotNull(propertyName)));
    }

    public void setProperty(String propertyName, String propertyValue) {
        this.matchingProperties.put(Preconditions.checkNotNull(propertyName), Preconditions.checkNotNull(propertyValue));
    }

    public void clearProperty(String propertyName) {
        this.matchingProperties.remove(Preconditions.checkNotNull(propertyName));
    }

    public Map<String, String> getMatchingProperties() {
        return this.matchingProperties;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public void setOperationType(String operationType) {
        this.operationType = Preconditions.checkNotNull(operationType);
    }

    public boolean isExclusion() {
        return this.exclusion;
    }

    public void setExclusion(boolean exclusion) {
        this.exclusion = exclusion;
    }

    public String getDynamicParametersAsJson() {
        return new Gson().toJson(this.matchingProperties);
    }

    public void setDynamicParametersFromJson(String json) {
        if (json == null || json.isEmpty()) {
            this.matchingProperties.clear();
        } else {
            Type typeOfT = new TypeToken<Map<String, String>>(){}.getType();
            Map parameters = (Map)new Gson().fromJson(json, typeOfT);
            this.matchingProperties.putAll(parameters);
        }
    }

    protected MoreObjects.ToStringHelper toStringHelper() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper(this).add("transferType", this.operationType).add("exclusion", this.exclusion);
        for (Map.Entry<String, String> entry : this.matchingProperties.entrySet()) {
            tsh.add(CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.LOWER_CAMEL).convert(entry.getKey()), entry.getValue());
        }
        return tsh;
    }

    public boolean equalsToIgnoreId(T other) {
        if (other == null) {
            return false;
        }
        if (!this.getOperationType().equals(((MatchRule)other).getOperationType())) {
            return false;
        }
        if (this.isExclusion() != ((MatchRule)other).isExclusion()) {
            return false;
        }
        return this.matchingProperties.equals(((MatchRule)other).matchingProperties);
    }

    @Override
    public abstract T deepClone();

    protected abstract long getOwnerId();
}

