/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.persistence.ProfileCounterRelation;
import com.ericsson.em.emc.hierarchies.persistence.ProfileCounterRelationDAO;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.FingerprintUpdateResultSetProcessor;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.database.persistence.EntityResultSetProcessor;
import com.ericsson.lwac.deployer.ApplicationContext;
import jakarta.annotation.Resource;
import jakarta.ejb.Singleton;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

@Singleton
@Updatable
@Validatable
@CryptoKeys(keyAliases={"hier.profilecounterrelation.S"})
public class ProfileCounterRelationDAOBean
extends CryptoExtendedBaseEntityDAOBean<ProfileCounterRelation>
implements ProfileCounterRelationDAO {
    private static final String TABLE_NAME = "hier$profilecounterrelation";
    private static final int DEFAULT_FINGERPRINT_VERSION = 1;
    private static final int CURRENT_FINGERPRINT_VERSION = 2;
    static final String FINGERPRINT_KEY = "hier.profilecounterrelation.S";
    @Resource
    private ApplicationContext applicationContext;

    @Override
    public ProfileCounterRelation create(ProfileCounterRelation profileCounterRelation) {
        super.create((BaseEntity)profileCounterRelation);
        return profileCounterRelation;
    }

    protected ProfileCounterRelation createManagedEntity() {
        return new ProfileCounterRelation();
    }

    @Override
    public ProfileCounterRelation update(ProfileCounterRelation profileCounterRelation) {
        return (ProfileCounterRelation)super.update((BaseEntity)profileCounterRelation);
    }

    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        ProfileCounterRelation relation = (ProfileCounterRelation)baseEntity;
        int i = 1;
        preparedStatement.setLong(i++, relation.getProfileServiceId());
        preparedStatement.setString(i++, relation.getCounterConfigurationName());
        preparedStatement.setBigDecimal(i++, relation.getCounterConfigurationLimit());
        return this.assignFingerprint(preparedStatement, TableColumn.FINGERPRINT.index(), new Object[]{relation.getProfileServiceId(), relation.getCounterConfigurationName(), relation.getCounterConfigurationLimit()});
    }

    protected void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        ProfileCounterRelation relation = (ProfileCounterRelation)baseEntity;
        relation.setProfileServiceId(resultSet.getLong(TableColumn.PROFILESERVICEID.name()));
        relation.setCounterConfigurationName(resultSet.getString(TableColumn.COUNTERCONFIGNAME.name()));
        relation.setCounterConfigurationLimit(resultSet.getBigDecimal(TableColumn.COUNTERCONFIGLIMIT.name()));
    }

    @Override
    public void delete(ProfileCounterRelation profileCounterRelation) {
        String statement = "delete from hier$profilecounterrelation where " + TableColumn.PROFILESERVICEID.name() + " = ? and " + TableColumn.COUNTERCONFIGNAME.name() + " = ?";
        super.delete(statement, new Object[]{profileCounterRelation.getProfileServiceId(), profileCounterRelation.getCounterConfigurationName()});
    }

    @Override
    public void deleteByProfileService(Long profileServiceId) {
        String statement = "delete from hier$profilecounterrelation where profileserviceid = ?";
        super.delete(statement, new Object[]{profileServiceId});
    }

    public ProfileCounterRelation updateDefaultFingerprint(ProfileCounterRelation entry) {
        return (ProfileCounterRelation)this.updateWithFingerprintVersionCheck(entry, 1);
    }

    public long updateDefaultFingerprintUsingResultSetProcessor(long batchSize, FingerprintUpdateResultSetProcessor fpResultSetProcessor) {
        if (this.isDefaultData()) {
            return 0L;
        }
        return this.processEntityResultSet("select * from (" + this.getSelectStatement() + " where " + TableColumn.FINGERPRINTVERSION + "= ? order by " + TableColumn.ID + ") WHERE rownum <= ?", (EntityResultSetProcessor)fpResultSetProcessor, new Object[]{1, batchSize});
    }

    @Override
    public List<ProfileCounterRelation> findRelationByProfileService(long profileServiceId) {
        return this.findMultiple(this.getSelectStatement() + " where " + TableColumn.PROFILESERVICEID.name() + " = ?", new Object[]{profileServiceId});
    }

    @Override
    public List<ProfileCounterRelation> findRelationByCounterName(String counterConfigurationName) {
        return this.findMultiple(this.getSelectStatement() + " where " + TableColumn.COUNTERCONFIGNAME.name() + " = ?", new Object[]{counterConfigurationName});
    }

    @Override
    public ProfileCounterRelation findRelationByProfileServiceAndCounterName(long profileServiceId, String counterConfigurationName) {
        return (ProfileCounterRelation)this.find(this.getSelectStatement() + " where " + TableColumn.PROFILESERVICEID.name() + " = ? and " + TableColumn.COUNTERCONFIGNAME.name() + " = ?", new Object[]{profileServiceId, counterConfigurationName});
    }

    public String[] getColumns() {
        return (String[])Arrays.stream(TableColumn.values()).map(Enum::name).toArray(String[]::new);
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    public String getSequenceName() {
        return "hier$pcr_seq";
    }

    public boolean isVersionable() {
        return false;
    }

    public boolean isUpdatable() {
        return true;
    }

    protected String getEntitySimpleName() {
        return ProfileCounterRelation.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 2;
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1 || fingerprintVersion == 2) {
            return new Object[]{resultSet.getLong(TableColumn.PROFILESERVICEID.name()), resultSet.getString(TableColumn.COUNTERCONFIGNAME.name()), resultSet.getBigDecimal(TableColumn.COUNTERCONFIGLIMIT.name())};
        }
        return null;
    }

    private static enum TableColumn {
        ID,
        PROFILESERVICEID,
        COUNTERCONFIGNAME,
        COUNTERCONFIGLIMIT,
        FINGERPRINT,
        FINGERPRINTVERSION,
        FINGERPRINTKEYGENERATION;


        int index() {
            return this.ordinal();
        }
    }
}

