/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.persistence.ProfileEventEntity;
import com.ericsson.em.emc.hierarchies.persistence.ProfileEventLoggerDAO;
import com.ericsson.em.emc.hierarchies.persistence.SafeProfileEventEntity;
import com.ericsson.em.emc.profile.logging.profilelisteners.ProfileEventListener;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import jakarta.ejb.Singleton;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;

@Singleton
@Validatable
@CryptoKeys(keyAliases={"hier.profilechangeevent.S"})
public class ProfileEventLoggerDAOBean
extends CryptoExtendedBaseEntityDAOBean<ProfileEventEntity>
implements ProfileEventLoggerDAO {
    private static final String[] COLUMNS = (String[])Stream.of(TableColumn.values()).map(Enum::name).toArray(String[]::new);
    private static final int FINGERPRINT_KEY_VERSION = 1;
    private static final String TABLE_NAME = "hier$profilechangeevent";
    private static final String SEQUENCE_NAME = "hier$profilechangeevent_seq";
    static final String FINGERPRINT_KEY = "hier.profilechangeevent.S";
    private final List<ProfileEventListener> profileEventListeners = new CopyOnWriteArrayList<ProfileEventListener>();

    @Override
    public ProfileEventEntity create(ProfileEventEntity profileEventEntity) {
        ProfileEventEntity entity = (ProfileEventEntity)super.create((BaseEntity)profileEventEntity);
        this.profileEventListeners.forEach(listener -> listener.onProfileUpdated(entity));
        return entity;
    }

    public ProfileEventEntity createEntity(ResultSet resultSet) throws SQLException {
        return ProfileEventEntity.newBuilder().id(resultSet.getLong(TableColumn.ID.name())).timestamp(resultSet.getTimestamp(TableColumn.EVENTTIMESTAMP.name()).toLocalDateTime()).profileEvent(ProfileEventEntity.ProfileEvent.valueOf(resultSet.getString(TableColumn.EVENT.name()))).profileName(resultSet.getString(TableColumn.PROFILENAME.name())).userIdentity(resultSet.getString(TableColumn.USERIDENTITY.name())).profileIdentity(resultSet.getLong(TableColumn.PROFILEIDENTITY.name())).build();
    }

    @Override
    public ProfileEventEntity find(long id) {
        return (ProfileEventEntity)this.find(this.getSelectStatement() + " where id = ?", new Object[]{id});
    }

    @Override
    public List<ProfileEventEntity> findByProfileNameLimitResults(String profileName, LocalDate localDate, int limit) {
        Timestamp timestamp = Timestamp.valueOf(localDate.atStartOfDay());
        StringBuilder sb = new StringBuilder(this.getSelectStatement());
        sb.append(" where ");
        if (profileName != null) {
            sb.append((Object)TableColumn.PROFILENAME);
            sb.append(" = ? and ");
        }
        sb.append((Object)TableColumn.EVENTTIMESTAMP);
        sb.append(" > ? order by ");
        sb.append((Object)TableColumn.EVENTTIMESTAMP);
        sb.append(" desc");
        String sql = sb.toString();
        return profileName != null ? this.findMultiple(limit, sql, new Object[]{profileName, timestamp}) : this.findMultiple(limit, sql, new Object[]{timestamp});
    }

    @Override
    public List<SafeProfileEventEntity> findByProfileNameLimitResultsNoUserId(String profileName, LocalDate localDate, int limit) {
        LinkedList<SafeProfileEventEntity> safeList = new LinkedList<SafeProfileEventEntity>();
        this.findByProfileNameLimitResults(profileName, localDate, limit).forEach(entity -> safeList.add(new SafeProfileEventEntity((ProfileEventEntity)((Object)entity))));
        return safeList;
    }

    @Override
    public LocalDateTime findLastUpdateByProfile(String profileName) {
        ProfileEventEntity entity = (ProfileEventEntity)this.find(this.getSelectStatement() + " where " + TableColumn.PROFILENAME + " = ? order by " + TableColumn.EVENTTIMESTAMP + " desc", new Object[]{profileName});
        return entity != null ? entity.getTimestamp() : null;
    }

    @Override
    public void registerListener(ProfileEventListener profileEventListener) {
        this.profileEventListeners.add(profileEventListener);
    }

    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        ProfileEventEntity profileEventEntity = (ProfileEventEntity)baseEntity;
        preparedStatement.setTimestamp(TableColumn.EVENTTIMESTAMP.ordinal(), Timestamp.valueOf(profileEventEntity.getTimestamp()));
        preparedStatement.setString(TableColumn.EVENT.ordinal(), profileEventEntity.getProfileEvent().name());
        preparedStatement.setString(TableColumn.PROFILENAME.ordinal(), profileEventEntity.getProfileName());
        preparedStatement.setString(TableColumn.USERIDENTITY.ordinal(), profileEventEntity.getUserIdentity());
        preparedStatement.setLong(TableColumn.PROFILEIDENTITY.ordinal(), profileEventEntity.getProfileIdentity());
        return this.assignFingerprint(preparedStatement, TableColumn.FINGERPRINT.ordinal(), new Object[]{Timestamp.valueOf(profileEventEntity.getTimestamp()), profileEventEntity.getProfileEvent().name(), profileEventEntity.getProfileName(), profileEventEntity.getUserIdentity(), profileEventEntity.getProfileIdentity()});
    }

    protected String getEntitySimpleName() {
        return ProfileEventEntity.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 1;
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1) {
            return new Object[]{resultSet.getTimestamp(TableColumn.EVENTTIMESTAMP.name()), resultSet.getString(TableColumn.EVENT.name()), resultSet.getString(TableColumn.PROFILENAME.name()), resultSet.getString(TableColumn.USERIDENTITY.name()), resultSet.getString(TableColumn.PROFILEIDENTITY.name())};
        }
        return new Object[0];
    }

    public String[] getColumns() {
        return (String[])COLUMNS.clone();
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    public String getSequenceName() {
        return SEQUENCE_NAME;
    }

    public boolean isVersionable() {
        return false;
    }

    public boolean isUpdatable() {
        return false;
    }

    static enum TableColumn {
        ID,
        EVENTTIMESTAMP,
        EVENT,
        PROFILENAME,
        USERIDENTITY,
        PROFILEIDENTITY,
        FINGERPRINT,
        FINGERPRINTVERSION,
        FINGERPRINTKEYGENERATION;

    }
}

