/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.hierarchies.persistence.ProfileDAO;
import com.ericsson.em.emc.hierarchies.persistence.ProfilePropertiesManager;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import com.ericsson.em.emc.hierarchies.persistence.ProfileServiceDAO;
import com.ericsson.em.emc.hierarchies.persistence.Property;
import com.ericsson.em.emc.hierarchies.persistence.PropertyDAO;
import com.google.common.collect.ImmutableMap;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import jakarta.persistence.PersistenceException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ProfilePropertiesManagerBean
implements ProfilePropertiesManager {
    private static final Logger logger = LoggerFactory.getLogger(ProfilePropertiesManagerBean.class);
    private static final String ALLOWED_NUMBER_OF_TOKENS = "Allowed Number Of Tokens";
    @EJB
    private ProfileDAO profileDAO;
    @EJB
    private ProfileServiceDAO serviceDAO;
    @EJB
    private PropertyDAO propertyDAO;

    @Override
    public Map<String, String> getGeneralPropertiesByProfileName(String profileName) {
        if (profileName == null) {
            return ImmutableMap.of();
        }
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            Profile profile = this.profileDAO.findByName(profileName);
            if (profile == null) {
                return ImmutableMap.of();
            }
            ProfileService service = this.serviceDAO.findByName("General", profile);
            if (service == null) {
                return ImmutableMap.of();
            }
            List<Property> properties = this.propertyDAO.findByService(service);
            for (Property p : properties) {
                result.put(p.getName(), p.getValue());
            }
            return result;
        }
        catch (PersistenceException e) {
            logger.error("Get general profile {} properties failed", (Object)profileName, (Object)e);
            return ImmutableMap.of();
        }
    }

    @Override
    public Optional<Integer> getAllowedNumberOfTokens(String profileName) {
        return Optional.ofNullable(this.getGeneralPropertiesByProfileName(profileName).get(ALLOWED_NUMBER_OF_TOKENS)).map(Integer::valueOf);
    }
}

