/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.counters.move.CounterBalanceMove;
import com.ericsson.em.emc.hierarchies.counters.move.CounterBalanceMoveParameters;
import com.ericsson.em.emc.hierarchies.persistence.CounterBalanceDAO;
import com.ericsson.em.emc.hierarchies.persistence.PersonalModifierConfigurationDAO;
import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.hierarchies.persistence.ProfileReference;
import com.ericsson.em.emc.hierarchies.persistence.ProfileReferenceDAO;
import com.ericsson.em.emc.hierarchies.persistence.ProfileReferenceManager;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import org.joda.time.DateTime;

@Singleton
public class ProfileReferenceManagerBean
implements ProfileReferenceManager {
    @EJB
    private ProfileReferenceDAO profileReferenceDAO;
    @EJB
    private CounterBalanceDAO counterBalanceDAO;
    @EJB
    private PersonalModifierConfigurationDAO personalModifierConfigurationDAO;

    @Override
    public ProfileReference updateReference(ProfileReference profileReference, Profile profile) {
        ProfileReference newProfileReference = this.profileReferenceDAO.create(profile);
        CounterBalanceMoveParameters counterMoveParams = (CounterBalanceMoveParameters)CounterBalanceMoveParameters.build().fromProfileReference(profileReference).toProfileReference(newProfileReference).dateTime(DateTime.now()).counterBalanceDAO(this.counterBalanceDAO).personalModifierConfigurationDAO(this.personalModifierConfigurationDAO).get();
        CounterBalanceMove.move(counterMoveParams);
        this.profileReferenceDAO.delete(profileReference);
        return newProfileReference;
    }

    @Override
    public ProfileReference find(long profileReferenceId) {
        return this.profileReferenceDAO.find(profileReferenceId);
    }
}

