/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.persistence.FingerprintProperty;
import com.ericsson.em.emc.hierarchies.persistence.PropertyFPDAO;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.FingerprintUpdateResultSetProcessor;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.database.persistence.EntityResultSetProcessor;
import jakarta.ejb.Singleton;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.stream.Stream;

@Updatable
@Validatable
@Singleton
@CryptoKeys(keyAliases={"hier.properties.S"})
public class PropertyFPDAOBean
extends CryptoExtendedBaseEntityDAOBean<FingerprintProperty>
implements PropertyFPDAO {
    private static final int CURRENT_FINGERPRINT_VERSION = 2;
    private static final int DEFAULT_FINGERPRINT_VERSION = 1;
    static final String FINGERPRINT_KEY = "hier.properties.S";
    static final String DB_TABLENAME = "hier$properties";

    protected String getEntitySimpleName() {
        return FingerprintProperty.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 2;
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1 || fingerprintVersion == 2) {
            return new Object[]{resultSet.getLong(TableColumn.FK_SERVICE.name()), resultSet.getString(TableColumn.NAME.name()), resultSet.getString(TableColumn.PVALUE.name())};
        }
        return null;
    }

    public String[] getColumns() {
        return (String[])Stream.of(TableColumn.values()).map(Enum::name).toArray(String[]::new);
    }

    protected FingerprintProperty createManagedEntity() {
        return new FingerprintProperty();
    }

    public String getTableName() {
        return DB_TABLENAME;
    }

    public String getSequenceName() {
        return "hier$properties_seq";
    }

    public boolean isVersionable() {
        return false;
    }

    public boolean isUpdatable() {
        return true;
    }

    public FingerprintProperty update(FingerprintProperty entry) {
        return (FingerprintProperty)super.update((BaseEntity)entry);
    }

    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        FingerprintProperty property = (FingerprintProperty)baseEntity;
        int i = 1;
        preparedStatement.setLong(i++, property.getFkServiceId());
        preparedStatement.setString(i++, property.getName());
        preparedStatement.setString(i++, property.getValue());
        return this.assignFingerprint(preparedStatement, i, new Object[]{property.getFkServiceId(), property.getName(), property.getValue()});
    }

    protected void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        FingerprintProperty property = (FingerprintProperty)baseEntity;
        property.setFkServiceId(resultSet.getLong(TableColumn.FK_SERVICE.name()));
        property.setName(resultSet.getString(TableColumn.NAME.name()));
        property.setValue(resultSet.getString(TableColumn.PVALUE.name()));
    }

    public FingerprintProperty updateDefaultFingerprint(FingerprintProperty entry) {
        return (FingerprintProperty)this.updateWithFingerprintVersionCheck(entry, 1);
    }

    public long updateDefaultFingerprintUsingResultSetProcessor(long batchSize, FingerprintUpdateResultSetProcessor fpResultSetProcessor) {
        long recordsUpdated = this.processEntityResultSet("select * from (" + this.getSelectStatement() + " where " + TableColumn.FINGERPRINTVERSION + "= ? order by " + TableColumn.ID + ") WHERE rownum <= ?", (EntityResultSetProcessor)fpResultSetProcessor, new Object[]{1, batchSize});
        return recordsUpdated;
    }

    private static enum TableColumn {
        ID,
        FK_SERVICE,
        NAME,
        PVALUE,
        FINGERPRINT,
        FINGERPRINTVERSION,
        FINGERPRINTKEYGENERATION;


        int index() {
            return this.ordinal();
        }
    }
}

