/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.beust.jcommander.internal.Lists;
import com.ericsson.em.emc.hierarchies.Unit;
import com.ericsson.em.emc.hierarchies.limits.LegacyLimitsConverter;
import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import com.ericsson.em.emc.hierarchies.persistence.ProfileServiceDAO;
import com.ericsson.em.emc.hierarchies.persistence.ThresholdConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.ThresholdConfigurationDAO;
import com.ericsson.em.emc.hierarchies.persistence.ThresholdConfigurationFpDAOBean;
import com.ericsson.em.emc.hierarchies.persistence.ThresholdMatchRuleDAO;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.monitoring.Measurement;
import com.ericsson.lwac.monitoring.StatisticsService;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import jakarta.persistence.PersistenceException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.joda.time.DateTime;

@Updatable
@Singleton
@Validatable
@CryptoKeys(keyAliases={"hier.thresholdconfig.S"})
public class ThresholdConfigurationDAOBean
extends CryptoExtendedBaseEntityDAOBean<ThresholdConfiguration>
implements ThresholdConfigurationDAO {
    @EJB
    private ThresholdMatchRuleDAO thresholdMatchRuleDAO;
    @EJB
    private ProfileServiceDAO serviceDAO;
    private static final List<TableColumn> TABLE_COLUMNS = Lists.newArrayList((Object[])TableColumn.values());
    private static final int CURRENT_FINGERPRINT_VERSION = 2;
    private static final int DEFAULT_FINGERPRINT_VERSION = 1;
    static final String FINGERPRINT_KEY = "hier.thresholdconfig.S";
    static final String DB_TABLENAME = "hier$thresholdconfig";

    protected ThresholdConfiguration createManagedEntity() {
        return new ThresholdConfiguration();
    }

    @Override
    public ThresholdConfiguration create(ThresholdConfiguration threshold, ProfileService profileService) {
        threshold.setService(profileService);
        super.create((BaseEntity)threshold);
        LinkedList<ThresholdConfiguration> thresholds = new LinkedList<ThresholdConfiguration>(profileService.getThresholdConfigurations());
        if (thresholds.contains(threshold)) {
            return threshold;
        }
        threshold.setMatchRules(this.thresholdMatchRuleDAO.setMatchRules(threshold.getMatchRules(), threshold));
        thresholds.add(threshold);
        profileService.setThresholdConfigurations(Collections.unmodifiableList(thresholds));
        this.serviceDAO.update(profileService);
        return threshold;
    }

    @Override
    public List<ThresholdConfiguration> findByService(ProfileService profileService) {
        List thresholdConfigurations = this.findMultiple(this.getSelectStatement() + " where fk_service = ?", new Object[]{profileService.getId()});
        for (ThresholdConfiguration thresholdConfiguration : thresholdConfigurations) {
            thresholdConfiguration.setService(profileService);
            thresholdConfiguration.setMatchRulesIfNotUpgraded(this.thresholdMatchRuleDAO.getMatchRules(thresholdConfiguration));
        }
        return thresholdConfigurations;
    }

    @Override
    public ThresholdConfiguration update(ThresholdConfiguration threshold) {
        threshold = (ThresholdConfiguration)super.update((BaseEntity)threshold);
        this.thresholdMatchRuleDAO.setMatchRules(threshold.getMatchRules(), threshold);
        this.serviceDAO.update(threshold.getService());
        return threshold;
    }

    @Override
    public void delete(ThresholdConfiguration aThresholdConfiguration) {
        super.delete((BaseEntity)aThresholdConfiguration);
        ProfileService service = aThresholdConfiguration.getService();
        LinkedList<ThresholdConfiguration> newThresholdConfigurationList = new LinkedList<ThresholdConfiguration>(service.getThresholdConfigurations());
        newThresholdConfigurationList.remove(aThresholdConfiguration);
        service.setThresholdConfigurations(Collections.unmodifiableList(newThresholdConfigurationList));
        this.serviceDAO.update(service);
        this.thresholdMatchRuleDAO.deleteCascade(aThresholdConfiguration);
    }

    @Override
    public void deleteByService(ProfileService profileService) {
        List<ThresholdConfiguration> thresholds = this.findByService(profileService);
        for (ThresholdConfiguration threshold : thresholds) {
            super.delete((BaseEntity)threshold);
            this.thresholdMatchRuleDAO.deleteCascade(threshold);
        }
    }

    @Override
    public Map<Long, List<ThresholdConfiguration>> findAllThresholdConfigurations(Profile profile) {
        HashMap<Long, List<ThresholdConfiguration>> allThresholdConfigurations = new HashMap<Long, List<ThresholdConfiguration>>();
        String statement = this.getSelectStatement() + " where fk_service in (select id from hier$service where fk_profile = ?)";
        Measurement measurement = this.statisticsService.startMeasurment("sql", statement, StatisticsService.MeasurementType.OUTGOING);
        try (Connection connection = this.dataSource.getReadOnlyConnection(this.getPreferredConnectionType());
             PreparedStatement preparedStatement = connection.prepareStatement(statement);){
            preparedStatement.setLong(1, profile.getId());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    ThresholdConfiguration thresholdConfiguration = new ThresholdConfiguration();
                    this.assign((BaseEntity)thresholdConfiguration, resultSet);
                    this.validate(thresholdConfiguration, resultSet);
                    allThresholdConfigurations.computeIfAbsent(resultSet.getLong("fk_service"), k -> new LinkedList()).add(thresholdConfiguration);
                    thresholdConfiguration.setMatchRulesIfNotUpgraded(this.thresholdMatchRuleDAO.getMatchRules(thresholdConfiguration));
                }
            }
        }
        catch (SQLException e) {
            throw new PersistenceException(String.format("Error while executing: %s parameters %s", statement, profile.getId()), e);
        }
        finally {
            this.statisticsService.stopMeasurement(measurement);
        }
        return allThresholdConfigurations;
    }

    @Override
    public ThresholdConfiguration find(long id) {
        ThresholdConfiguration result = (ThresholdConfiguration)super.find(id);
        if (result != null) {
            result.setMatchRulesIfNotUpgraded(this.thresholdMatchRuleDAO.getMatchRules(result));
        }
        return result;
    }

    protected String getEntitySimpleName() {
        return ThresholdConfiguration.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 2;
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1 || fingerprintVersion == 2) {
            return new Object[]{resultSet.getTimestamp(TableColumn.STARTDATETIME.name()), resultSet.getTimestamp(TableColumn.ENDDATETIME.name()), resultSet.getLong(TableColumn.FK_SERVICE.name()), resultSet.getString(TableColumn.NAME.name()), resultSet.getBigDecimal(TableColumn.THRESHOLD.name()), resultSet.getString(TableColumn.UNITTYPE.name()), resultSet.getString(TableColumn.CLASSNAME.name()), resultSet.getString(TableColumn.DATA.name()), resultSet.getString(TableColumn.HARDLIMITNOTIFICATIONSENABLED.name()), resultSet.getString(TableColumn.HARDLIMITNOTIFICATIONNAME.name()), resultSet.getString(TableColumn.DESCRIPTION.name()), resultSet.getString(TableColumn.UNIT.name())};
        }
        return null;
    }

    public String getTableName() {
        return DB_TABLENAME;
    }

    public String getSequenceName() {
        return "hier$thresholdconfig_seq";
    }

    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        ThresholdConfiguration thresholdConfiguration = (ThresholdConfiguration)baseEntity;
        DateTime startDateTime = thresholdConfiguration.getStartDateTime();
        DateTime endDateTime = thresholdConfiguration.getEndDateTime();
        int i = 1;
        if (startDateTime != null) {
            preparedStatement.setTimestamp(i++, new Timestamp(startDateTime.getMillis()));
        } else {
            preparedStatement.setNull(i++, 93);
        }
        if (endDateTime != null) {
            preparedStatement.setTimestamp(i++, new Timestamp(endDateTime.getMillis()));
        } else {
            preparedStatement.setNull(i++, 93);
        }
        preparedStatement.setLong(i++, thresholdConfiguration.getService().getId());
        preparedStatement.setString(i++, thresholdConfiguration.getName());
        preparedStatement.setBigDecimal(i++, thresholdConfiguration.getThreshold());
        preparedStatement.setString(i++, thresholdConfiguration.getThresholdType());
        preparedStatement.setString(i++, null);
        preparedStatement.setString(i++, thresholdConfiguration.getClassName());
        preparedStatement.setString(i++, thresholdConfiguration.getData());
        preparedStatement.setString(i++, thresholdConfiguration.isHardLimitNotificationsEnabled() ? "Y" : "N");
        preparedStatement.setString(i++, thresholdConfiguration.getHardLimitNotificationOperationTypeName());
        preparedStatement.setString(i++, thresholdConfiguration.getDescription());
        preparedStatement.setString(i++, thresholdConfiguration.hasUnit() ? thresholdConfiguration.getUnit().getValue() : null);
        return this.assignFingerprint(preparedStatement, i, new Object[]{null != startDateTime ? new Timestamp(startDateTime.getMillis()) : null, null != endDateTime ? new Timestamp(endDateTime.getMillis()) : null, thresholdConfiguration.getService().getId(), thresholdConfiguration.getName(), thresholdConfiguration.getThreshold(), thresholdConfiguration.getThresholdType(), thresholdConfiguration.getClassName(), thresholdConfiguration.getData(), thresholdConfiguration.isHardLimitNotificationsEnabled() ? "Y" : "N", thresholdConfiguration.getHardLimitNotificationOperationTypeName(), thresholdConfiguration.getDescription(), thresholdConfiguration.hasUnit() ? thresholdConfiguration.getUnit().getValue() : null});
    }

    protected void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        ThresholdConfiguration threshold = (ThresholdConfiguration)baseEntity;
        threshold.setStartDateTime(ThresholdConfigurationDAOBean.getNullableDateTimeFromTimestampResultSet((ResultSet)resultSet, (String)TableColumn.STARTDATETIME.name()));
        threshold.setEndDateTime(ThresholdConfigurationDAOBean.getNullableDateTimeFromTimestampResultSet((ResultSet)resultSet, (String)TableColumn.ENDDATETIME.name()));
        threshold.setName(resultSet.getString(TableColumn.NAME.name()));
        threshold.setThreshold(resultSet.getBigDecimal(TableColumn.THRESHOLD.name()));
        threshold.setThresholdType(resultSet.getString(TableColumn.UNITTYPE.name()));
        threshold.setMatchRules(LegacyLimitsConverter.convertToThresholdMatchRules(resultSet.getString(TableColumn.MODIFIERUNITTYPE.name())));
        threshold.setClassName(resultSet.getString(TableColumn.CLASSNAME.name()));
        threshold.setData(resultSet.getString(TableColumn.DATA.name()));
        threshold.setHardLimitNotificationsEnabled(resultSet.getString(TableColumn.HARDLIMITNOTIFICATIONSENABLED.name()).equals("Y"));
        threshold.setHardLimitNotificationOperationTypeName(resultSet.getString(TableColumn.HARDLIMITNOTIFICATIONNAME.name()));
        threshold.setDescription(resultSet.getString(TableColumn.DESCRIPTION.name()));
        threshold.setUnit(Unit.fromString(resultSet.getString(TableColumn.UNIT.name())));
    }

    public String[] getColumns() {
        return TABLE_COLUMNS.stream().map(Enum::name).collect(Collectors.toList()).toArray(new String[TableColumn.values().length]);
    }

    public boolean isVersionable() {
        return false;
    }

    public boolean isUpdatable() {
        return true;
    }

    public Class<? extends CryptoExtendedBaseEntityDAOBean> getDaoBeanForUpdateFpCli() {
        return ThresholdConfigurationFpDAOBean.class;
    }

    static enum TableColumn {
        ID,
        STARTDATETIME,
        ENDDATETIME,
        FK_SERVICE,
        NAME,
        THRESHOLD,
        UNITTYPE,
        MODIFIERUNITTYPE,
        CLASSNAME,
        DATA,
        HARDLIMITNOTIFICATIONSENABLED,
        HARDLIMITNOTIFICATIONNAME,
        DESCRIPTION,
        UNIT,
        FINGERPRINT,
        FINGERPRINTVERSION,
        FINGERPRINTKEYGENERATION;


        int index() {
            return this.ordinal();
        }
    }
}

