/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence.serialization;

import com.ericsson.em.emc.hierarchies.counters.CounterTypeRegistry;
import com.ericsson.em.emc.hierarchies.limits.CounterType;
import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import com.google.common.base.MoreObjects;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class CounterTypeConverter
implements JsonDeserializer<CounterType>,
JsonSerializer<CounterType> {
    private final CounterTypeRegistry counterTypeRegistry;

    public CounterTypeConverter(CounterTypeRegistry counterTypeRegistry) {
        this.counterTypeRegistry = counterTypeRegistry;
    }

    @Override
    public JsonElement serialize(CounterType src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(((CounterType)MoreObjects.firstNonNull(src, CounterConfiguration.NoCounterType.NONE)).getName());
    }

    @Override
    public CounterType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String counterTypeStr = json.getAsString();
        return this.counterTypeRegistry.getCounterType(counterTypeStr).orElseThrow(() -> new JsonParseException("Unknown counter type " + counterTypeStr));
    }
}

