/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence.serialization;

import com.ericsson.em.emc.hierarchies.persistence.serialization.UnknownFieldAware;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class UnknownFieldAwareDeserializer
implements JsonDeserializer<UnknownFieldAware> {
    private Set<Field> getAllDeclaredFields(Class<?> targetClass) {
        if (targetClass == Object.class) {
            return Collections.emptySet();
        }
        LinkedHashSet<Field> fields = Sets.newLinkedHashSet(Arrays.asList(targetClass.getDeclaredFields()));
        fields.addAll(this.getAllDeclaredFields(targetClass.getSuperclass()));
        return fields;
    }

    @Override
    public UnknownFieldAware deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = (JsonObject)json;
        try {
            Class targetClass = (Class)typeOfT;
            UnknownFieldAware target = (UnknownFieldAware)targetClass.newInstance();
            for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
                Optional<Field> field = this.getAllDeclaredFields(targetClass).stream().filter(f -> f.getName().equals(entry.getKey())).findFirst();
                if (!field.isPresent()) {
                    if (entry.getValue() instanceof JsonNull) {
                        target.handleUnknownField(entry.getKey(), null);
                        continue;
                    }
                    target.handleUnknownField(entry.getKey(), entry.getValue().getAsString());
                    continue;
                }
                Object propertyValue = context.deserialize(entry.getValue(), field.get().getGenericType());
                field.get().setAccessible(true);
                field.get().set(target, propertyValue);
            }
            return target;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            throw Throwables.propagate(e);
        }
    }
}

