/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.license;

import com.ericsson.em.emc.license.SystemUsageReportListener;
import com.ericsson.em.emc.license.SystemUsageReportNotifier;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import jakarta.ejb.Singleton;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SystemUsageReportNotifierBean
implements SystemUsageReportNotifier {
    private SystemUsageReportListener listener;
    private static final Logger logger = LoggerFactory.getLogger(SystemUsageReportNotifierBean.class);

    @Override
    public void registerSystemUsageReportListener(SystemUsageReportListener systemUsageReportListener) {
        Preconditions.checkState(systemUsageReportListener != null, "System usage listener can't be null");
        if (this.listener != null) {
            throw new RuntimeException("System usage listener already set");
        }
        this.listener = systemUsageReportListener;
    }

    @Override
    public void notifySystemUsageReport(int txCount) throws IOException {
        if (this.listener != null) {
            logger.debug("Calling onSystemUsageReported with txCount={}", (Object)txCount);
            this.listener.onSystemUsageReported(txCount);
        } else {
            logger.debug("No system usage report listener has been registered");
        }
    }

    @Override
    @VisibleForTesting
    public void resetListener() {
        this.listener = null;
    }
}

