/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.linkresource;

import com.ericsson.em.emc.linkresource.LinkResourceInSPSystemService;
import com.ericsson.em.emc.util.Currency;
import com.ericsson.em.emc.util.Money;
import com.ericsson.lwac.deployer.service.Service;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;

@Service(serviceInterface=LinkResourceInSPSystemService.class)
public class LinkResourceInSPSystemServiceBean
implements LinkResourceInSPSystemService {
    private static final int APPROVAL_EXPIRY_TIME_DEFAULT = 1;
    private static final TimeUnit APPROVAL_EXPIRY_TIME_UNITS_DEFAULT = TimeUnit.HOURS;
    private static final String ANY_CURRENCY = "*";
    private static final String ANY_CURRENCY_DEFAULT_AMOUNT = "1.00";
    private int approvalExpiryTime = 1;
    private TimeUnit approvalExpiryTimeUnits = APPROVAL_EXPIRY_TIME_UNITS_DEFAULT;
    private String fallbackAmount = "1.00";
    private final Map<Currency, Money> currenciesDefaultAmounts = new HashMap<Currency, Money>();

    @Override
    public Money getVerificationPaymentAmount(Currency currency) {
        if (currency == null) {
            throw new IllegalArgumentException("Cannot get verification payment amount for null currency");
        }
        Money amount = this.currenciesDefaultAmounts.get(currency);
        if (amount == null) {
            amount = Money.valueOf(this.fallbackAmount, currency);
        }
        return amount;
    }

    @Override
    public void setVerificationPaymentDefaultAmounts(List<String> settings) {
        HashSet<String> seenCurrencyCodes = new HashSet<String>();
        for (String amountSetting : settings) {
            if (!amountSetting.contains(":")) {
                String message = "Cannot parse entry in service configuration: '" + amountSetting + "'. Expected formats: 'XTS:1.00', '*:1.00'";
                throw new IllegalArgumentException(message);
            }
            String[] currencyAmount = amountSetting.split(":", 2);
            String currencyCode = currencyAmount[0];
            String amount = currencyAmount[1];
            if (seenCurrencyCodes.contains(currencyCode)) {
                throw new IllegalArgumentException("Duplicate entry for '" + currencyCode + "'");
            }
            seenCurrencyCodes.add(currencyCode);
            if (currencyCode.equals(ANY_CURRENCY)) {
                this.fallbackAmount = amount;
                continue;
            }
            Currency currency = Currency.getInstance(currencyCode);
            this.currenciesDefaultAmounts.put(currency, Money.valueOf(amount, currency));
        }
    }

    @Override
    public void setApprovalExpiryTime(int approvalExpiryTime) {
        if (approvalExpiryTime <= 0) {
            throw new IllegalArgumentException("ApprovalExpiryTime has to be greater than 0");
        }
        this.approvalExpiryTime = approvalExpiryTime;
    }

    @Override
    public void setApprovalExpiryTimeUnits(String approvalExpiryTimeUnits) {
        TimeUnit expiryUnits = TimeUnit.valueOf(approvalExpiryTimeUnits);
        switch (expiryUnits) {
            case DAYS: 
            case HOURS: 
            case MINUTES: 
            case SECONDS: {
                this.approvalExpiryTimeUnits = expiryUnits;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported ApprovalExpiryTimeUnits property value, allowed values: DAYS, HOURS, MINUTES, SECONDS");
            }
        }
    }

    @Override
    public DateTime generateApprovalExpiryDateTime() {
        DateTime start = DateTime.now();
        switch (this.approvalExpiryTimeUnits) {
            case DAYS: {
                return start.plusDays(this.approvalExpiryTime);
            }
            case HOURS: {
                return start.plusHours(this.approvalExpiryTime);
            }
            case MINUTES: {
                return start.plusMinutes(this.approvalExpiryTime);
            }
            case SECONDS: {
                return start.plusSeconds(this.approvalExpiryTime);
            }
        }
        throw new IllegalArgumentException("Cannot calculate approval expiry date");
    }
}

