/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.m3externallog.json;

import com.ericsson.em.emc.m3externallog.json.CustomExclusionStrategy;
import com.ericsson.em.emc.m3externallog.json.CustomFieldNamingStrategy;
import com.ericsson.em.emc.m3externallog.json.JsonMapper;
import com.ericsson.em.emc.m3externallog.json.JsonMapperProvider;
import com.ericsson.em.emc.m3externallog.json.converters.AbstractValueObjectSerializer;
import com.ericsson.em.emc.m3externallog.json.converters.Converters;
import com.ericsson.em.emc.m3externallog.json.converters.ExtensionTypeJsonSerializer;
import com.ericsson.em.emc.m3externallog.json.converters.SensitiveValue;
import com.ericsson.em.emc.m3externallog.json.converters.SensitiveValueSerializer;
import com.ericsson.em.emc.m3externallog.json.typeadapters.ImmutableMapTypeAdapterFactory;
import com.ericsson.em.emm.util.AbstractValueObject;
import com.ericsson.em.m3if.v1_0.common.ExtensionType;
import com.google.common.collect.ImmutableMap;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.reflect.TypeToken;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

@Singleton
public class JsonMapperProviderBean
implements JsonMapperProvider {
    @EJB
    private Converters converters;
    private Gson gson;
    private Gson internalGson;
    private final Type defaultMapType = new TypeToken<Map<String, Object>>(){}.getType();
    private final FieldNamingStrategy fieldNamingStrategy = new CustomFieldNamingStrategy();
    private JsonMapper jsonMapper;

    private void buildJsonMapper() {
        GsonBuilder builder = new GsonBuilder().setFieldNamingStrategy(this.fieldNamingStrategy);
        builder.disableHtmlEscaping();
        builder.setExclusionStrategies(new CustomExclusionStrategy());
        for (Map.Entry<Class<?>, Object> entry : this.converters.getConverters().entrySet()) {
            builder.registerTypeAdapter(entry.getKey(), entry.getValue());
        }
        builder.registerTypeHierarchyAdapter(SensitiveValue.class, new SensitiveValueSerializer());
        builder.registerTypeHierarchyAdapter(AbstractValueObject.class, new AbstractValueObjectSerializer());
        builder.registerTypeHierarchyAdapter(ExtensionType.class, new ExtensionTypeJsonSerializer());
        builder.registerTypeAdapter(new TypeToken<Map<String, Object>>(){}.getType(), new MapDeserializerDoubleAsIntFix());
        builder.registerTypeAdapterFactory(new ImmutableMapTypeAdapterFactory());
        builder.registerTypeAdapter((Type)((Object)ImmutableMap.class), ImmutableMapTypeAdapterFactory.newCreator());
        this.gson = builder.create();
        GsonBuilder internalBuilder = new GsonBuilder().setFieldNamingStrategy(this.fieldNamingStrategy);
        internalBuilder.setExclusionStrategies(new CustomExclusionStrategy());
        for (Map.Entry<Class<?>, Object> entry : this.converters.getInternalConverters().entrySet()) {
            internalBuilder.registerTypeAdapter(entry.getKey(), entry.getValue());
        }
        internalBuilder.registerTypeHierarchyAdapter(SensitiveValue.class, new SensitiveValueSerializer());
        internalBuilder.registerTypeHierarchyAdapter(AbstractValueObject.class, new AbstractValueObjectSerializer());
        internalBuilder.registerTypeHierarchyAdapter(ExtensionType.class, new ExtensionTypeJsonSerializer());
        internalBuilder.registerTypeAdapter(new TypeToken<Map<String, Object>>(){}.getType(), new MapDeserializerDoubleAsIntFix());
        this.internalGson = internalBuilder.create();
        this.jsonMapper = new JsonMapper(){

            @Override
            public String toJson(Object src) {
                return JsonMapperProviderBean.this.gson.toJson(src);
            }

            @Override
            public Map<String, Object> toMap(Object src) {
                return this.fromJsonToMap(JsonMapperProviderBean.this.gson.toJson(src));
            }

            @Override
            public <T> T fromJson(String json, Class<T> classOfT) {
                return JsonMapperProviderBean.this.gson.fromJson(json, classOfT);
            }

            @Override
            public String toInternalJson(Object src) {
                return JsonMapperProviderBean.this.internalGson.toJson(src);
            }

            @Override
            public <T> T fromInternalJson(String json, Class<T> classOfT) {
                return JsonMapperProviderBean.this.internalGson.fromJson(json, classOfT);
            }

            @Override
            public Map<String, Object> fromJsonToMap(String json) {
                return (Map)JsonMapperProviderBean.this.gson.fromJson(json, JsonMapperProviderBean.this.defaultMapType);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonMapper get() {
        JsonMapperProviderBean jsonMapperProviderBean = this;
        synchronized (jsonMapperProviderBean) {
            if (this.jsonMapper == null) {
                this.buildJsonMapper();
            }
            return this.jsonMapper;
        }
    }

    public static class MapDeserializerDoubleAsIntFix
    implements JsonDeserializer<Map<String, Object>> {
        @Override
        public Map<String, Object> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return (Map)this.read(json);
        }

        public Object read(JsonElement in) {
            if (in.isJsonArray()) {
                ArrayList<Object> list = new ArrayList<Object>();
                JsonArray arr = in.getAsJsonArray();
                for (JsonElement anArr : arr) {
                    list.add(this.read(anArr));
                }
                return list;
            }
            if (in.isJsonObject()) {
                LinkedTreeMap<String, Object> map = new LinkedTreeMap<String, Object>();
                JsonObject obj = in.getAsJsonObject();
                Set<Map.Entry<String, JsonElement>> entitySet = obj.entrySet();
                for (Map.Entry<String, JsonElement> entry : entitySet) {
                    map.put(entry.getKey(), this.read(entry.getValue()));
                }
                return map;
            }
            if (in.isJsonPrimitive()) {
                JsonPrimitive prim = in.getAsJsonPrimitive();
                if (prim.isBoolean()) {
                    return prim.getAsBoolean();
                }
                if (prim.isString()) {
                    return prim.getAsString();
                }
                if (prim.isNumber()) {
                    Number num = prim.getAsNumber();
                    if (Math.ceil(num.doubleValue()) == (double)num.longValue()) {
                        return num.longValue();
                    }
                    return num.doubleValue();
                }
            }
            return null;
        }
    }
}

