/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.m3externallog.json.converters;

import com.ericsson.em.emc.m3externallog.json.converters.Converter;
import com.ericsson.em.emc.util.XmlExtension;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlExtensionConverter
implements Converter<XmlExtension> {
    private static final int MAX_DEPTH = 20;
    private static final Logger log = LoggerFactory.getLogger(XmlExtensionConverter.class);

    @Override
    public XmlExtension deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        throw new UnsupportedOperationException();
    }

    private void addObject(NodeList list, JsonObject parent, Deque<String> path) {
        int i;
        HashMap<String, Integer> nodeNamesCountMap = new HashMap<String, Integer>();
        for (i = 0; i < list.getLength(); ++i) {
            nodeNamesCountMap.merge(list.item(i).getNodeName(), 1, Integer::sum);
        }
        block5: for (i = 0; i < list.getLength(); ++i) {
            Node currentNode = list.item(i);
            String nodeName = currentNode.getNodeName();
            if (nodeName.startsWith("xmlns") || nodeName.startsWith("#text")) continue;
            switch (currentNode.getNodeType()) {
                case 1: {
                    JsonElement elementToAdd = this.createElementToAdd(currentNode, path);
                    if ((Integer)nodeNamesCountMap.get(nodeName) > 1) {
                        JsonArray jsonArray = parent.getAsJsonArray(nodeName) == null ? new JsonArray() : parent.getAsJsonArray(nodeName);
                        jsonArray.add(elementToAdd);
                        parent.add(nodeName, jsonArray);
                        continue block5;
                    }
                    parent.add(nodeName, elementToAdd);
                    continue block5;
                }
                case 3: {
                    parent.add(nodeName, new JsonPrimitive(currentNode.getNodeValue()));
                    continue block5;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonElement serialize(XmlExtension src, Type srcType, JsonSerializationContext context) {
        List<Element> elementList;
        JsonObject json = new JsonObject();
        List<Element> list = elementList = src.getExtensionData();
        synchronized (list) {
            try {
                HashMap<String, Integer> nodeNamesCountMap = new HashMap<String, Integer>();
                for (Element extensionDatum : src.getExtensionData()) {
                    nodeNamesCountMap.merge(extensionDatum.getNodeName(), 1, Integer::sum);
                }
                for (Element el : src.getExtensionData()) {
                    String nodeName = el.getNodeName();
                    if (nodeName.startsWith("xmlns") || nodeName.startsWith("#text")) continue;
                    switch (el.getNodeType()) {
                        case 1: {
                            ArrayDeque<String> path = new ArrayDeque<String>(21);
                            JsonElement elementToAdd = this.createElementToAdd(el, path);
                            if ((Integer)nodeNamesCountMap.get(nodeName) > 1) {
                                JsonArray jsonArray = json.getAsJsonArray(nodeName) == null ? new JsonArray() : json.getAsJsonArray(nodeName);
                                jsonArray.add(elementToAdd);
                                json.add(nodeName, jsonArray);
                                break;
                            }
                            json.add(nodeName, elementToAdd);
                            break;
                        }
                        case 3: {
                            json.add(nodeName, new JsonPrimitive(el.getNodeValue()));
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new JsonParseException("Can not deserialize Extension", e);
            }
        }
        return json;
    }

    private JsonElement createElementToAdd(Node currentNode, Deque<String> path) {
        JsonElement elementToAdd;
        if (currentNode.getChildNodes().getLength() == 1 && currentNode.getFirstChild().getNodeType() == 3) {
            elementToAdd = new JsonPrimitive(currentNode.getFirstChild().getNodeValue());
        } else {
            elementToAdd = new JsonObject();
            if (path.size() >= 20) {
                log.error("Failed to convert XMLExtension, to deep. Path: {}", (Object)path);
                return elementToAdd;
            }
            path.push(currentNode.getNodeName());
            this.addObject(currentNode.getChildNodes(), (JsonObject)elementToAdd, path);
            path.pop();
        }
        return elementToAdd;
    }
}

