/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.notificationclient;

import com.ericsson.em.emc.notificationclient.NotificationChannelType;
import com.ericsson.em.emc.notificationclient.NotificationCommunicationErrorCode;
import com.ericsson.em.emc.notificationclient.NotificationCommunicationException;
import com.ericsson.em.emc.notificationclient.NotificationException;
import com.ericsson.em.emc.notificationclient.NotificationIdentity;
import com.ericsson.em.emc.notificationclient.NotificationOperationType;
import com.ericsson.em.emc.notificationclient.NotificationService;
import com.ericsson.em.emc.notificationclient.NotificationValidationException;
import com.ericsson.em.emc.notificationclient.NsFaultIndicationId;
import com.ericsson.em.emc.notificationclient.faultindication.NotificationClientFaultIndicationDescription;
import com.ericsson.em.emc.notificationclient.internal.NSTranslator;
import com.ericsson.em.emc.notificationclient.internal.NotificationOperation;
import com.ericsson.em.emc.notificationclient.internal.Parameter;
import com.ericsson.em.emc.notificationclient.internal.ParameterName;
import com.ericsson.em.emc.notificationreceiver.NotificationReceiverService;
import com.ericsson.em.emc.notificationreceiver.persistence.NotificationReceiver;
import com.ericsson.em.emm.ns.v1_0.common.Base64Value;
import com.ericsson.em.emm.ns.v1_0.common.Channel;
import com.ericsson.em.emm.ns.v1_0.common.Destination;
import com.ericsson.em.emm.ns.v1_0.common.Identity;
import com.ericsson.em.emm.ns.v1_0.common.LanguageCodeValue;
import com.ericsson.em.emm.ns.v1_0.common.OperationName;
import com.ericsson.em.emm.ns.v2_0.client.deleteemaillogo.DeleteEmailLogoRequest;
import com.ericsson.em.emm.ns.v2_0.client.deleteemaillogo.DeleteEmailLogoResponse;
import com.ericsson.em.emm.ns.v2_0.client.getemaillogo.GetEmailLogoRequest;
import com.ericsson.em.emm.ns.v2_0.client.getemaillogo.GetEmailLogoResponse;
import com.ericsson.em.emm.ns.v2_0.client.querynotification.QueryNotificationRequest;
import com.ericsson.em.emm.ns.v2_0.client.querynotification.QueryNotificationResponse;
import com.ericsson.em.emm.ns.v2_0.client.sendnotification.SendNotificationRequest;
import com.ericsson.em.emm.ns.v2_0.client.sendnotification.SendNotificationResponse;
import com.ericsson.em.emm.ns.v2_0.client.setemaillogo.SetEmailLogoRequest;
import com.ericsson.em.emm.ns.v2_0.client.setemaillogo.SetEmailLogoResponse;
import com.ericsson.em.emm.ns.v2_0.client.syncnotifications.SyncNotificationsRequest;
import com.ericsson.em.emm.ns.v2_0.client.syncnotifications.SyncNotificationsResponse;
import com.ericsson.em.emm.ns.v2_0.common.ClientId;
import com.ericsson.em.emm.ns.v2_0.common.NotificationText;
import com.ericsson.em.emm.ns.v2_0.common.ReceiverIdentity;
import com.ericsson.lwac.cli.ApplicationProperties;
import com.ericsson.lwac.cli.ApplicationPropertyChangeListener;
import com.ericsson.lwac.deployer.ApplicationContext;
import com.ericsson.lwac.deployer.service.Service;
import com.ericsson.lwac.deployer.service.ServiceProperty;
import com.ericsson.lwac.faultindication.FaultIndication;
import com.ericsson.lwac.faultindication.FaultIndicationDescription;
import com.ericsson.lwac.faultindication.FaultIndicationService;
import com.ericsson.lwac.http.client.HttpClientException;
import com.ericsson.lwac.http.client.HttpRequest;
import com.ericsson.lwac.http.client.xml.HttpXmlClientServiceBean;
import com.ericsson.lwac.http.types.ErrorArgument;
import com.ericsson.lwac.http.types.ErrorResponse;
import com.ericsson.lwac.timer.TimerCondition;
import com.ericsson.lwac.timer.TimerListener;
import com.ericsson.lwac.timer.TimerRegistration;
import com.ericsson.lwac.timer.TimerService;
import com.ericsson.lwac.transaction.Transaction;
import com.ericsson.lwac.transaction.TransactionManager;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(serviceInterface=NotificationService.class)
public class NotificationServiceBean
extends HttpXmlClientServiceBean
implements NotificationService,
TimerListener,
ApplicationPropertyChangeListener {
    private static final boolean IS_TRANSACTION_AWARE = true;
    private static final Integer DEFAULT_PRIORITY = null;
    private static final List<NotificationChannelType> ALL_CHANNELS = Arrays.asList(NotificationChannelType.values());
    private static final Logger logger = LoggerFactory.getLogger(NotificationServiceBean.class);
    private final Map<String, NotificationOperationType> notificationOperations = new ConcurrentSkipListMap<String, NotificationOperationType>();
    private final ReentrantLock syncLock = new ReentrantLock();
    private boolean useAccountOwnerAsSender = false;
    @Resource
    private TransactionManager transactionManager;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private FaultIndicationService faultIndicationService;
    @Resource
    private ApplicationProperties applicationProperties;
    @Resource
    private TimerService timerService;
    @Resource
    private NotificationReceiverService notificationReceiverService;
    private boolean newSyncNeeded = false;
    private String notificationClientId;
    private Integer priority = DEFAULT_PRIORITY;

    @PostConstruct
    public void registerNotifier() {
        this.applicationProperties.registerApplicationPropertyChangeListener(this, BATCHTRANSACTION_TRANSFERNOTIFICATION_USEACCOUNTOWNERASSENDER);
    }

    public void onStart() {
        if (this.notificationClientId == null) {
            this.notificationClientId = this.applicationContext.getApplicationName();
        }
        this.onTimeout();
    }

    @Override
    public void onTimeout() {
        this.syncNotificationsIfNeeded();
    }

    @Override
    public void syncNotificationsIfNeeded() {
        this.syncLock.lock();
        try {
            if (this.newSyncNeeded && this.syncNotifications()) {
                logger.info("Sync with NS successful.");
                this.newSyncNeeded = false;
            }
        }
        finally {
            this.syncLock.unlock();
        }
    }

    private boolean syncNotifications() {
        boolean managedToSync = false;
        List<NotificationOperation> notificationOperationList = this.createNotificationList();
        try {
            managedToSync = this.syncNotifications(notificationOperationList) != null;
        }
        catch (Exception e) {
            logger.trace("Sync with NS Failed.", e);
        }
        return managedToSync;
    }

    private SyncNotificationsResponse syncNotifications(List<NotificationOperation> notificationOperations) {
        SyncNotificationsRequest syncNotificationsRequest = new SyncNotificationsRequest();
        syncNotificationsRequest.setClientId(this.notificationClientId != null ? ClientId.fromString((String)this.notificationClientId) : null);
        syncNotificationsRequest.setNotifications(NSTranslator.translateNotificationOperations(notificationOperations));
        FaultIndicationHandler ah = new FaultIndicationHandler(this.faultIndicationService, syncNotificationsRequest);
        try {
            HttpRequest syncnotification = HttpRequest.newBuilder(SyncNotificationsRequest.class, SyncNotificationsResponse.class, ErrorResponse.class).operation("syncnotification").request((Object)syncNotificationsRequest).build();
            SyncNotificationsResponse response = (SyncNotificationsResponse)this.handleRequest(syncnotification);
            ah.clearFaultIndications();
            return response;
        }
        catch (NotificationException e) {
            throw ah.reportFaultIndicationAndCreateException(e);
        }
    }

    @Override
    public void sendNotification(NotificationIdentity notificationIdentity, NotificationOperationType operation, List<Parameter> parameters, String language) {
        this.sendNotification(notificationIdentity, operation, null, parameters, language);
    }

    @Override
    public void sendNotification(NotificationIdentity notificationIdentity, NotificationOperationType operation, List<Parameter> parameters, String language, List<NotificationChannelType> allowedChannels) {
        this.validateParameters(operation, parameters);
        if (!this.sendToNotificationReceivers(notificationIdentity, operation.getName(), null, parameters, language, true, allowedChannels)) {
            this.executeSynchronization(() -> this.sendNotificationToServer(notificationIdentity, operation.getName(), null, parameters, language, allowedChannels));
        }
    }

    private void validateParameters(NotificationOperationType operation, List<Parameter> parameters) {
        if (parameters.size() < operation.getNumberOfParameters()) {
            throw new NotificationValidationException(String.format("NotificationService %s parameter mismatch, expected %d, but got %d", operation.getName(), operation.getNumberOfParameters(), parameters.size()));
        }
        for (Parameter p : parameters) {
            if (this.hasParameter(operation, p.getName())) continue;
            throw new IllegalArgumentException("Notification type " + operation + " cannot take parameter " + p.getName());
        }
    }

    private boolean hasParameter(NotificationOperationType operation, String name) {
        int len = operation.getNumberOfParameters();
        for (int i = 0; i < len; ++i) {
            if (!operation.getParameterName(i).equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void sendNotification(NotificationIdentity notificationIdentity, NotificationOperationType operation, NotificationChannelType channel, List<Parameter> parameters, String language) {
        this.validateParameters(operation, parameters);
        if (!this.sendToNotificationReceivers(notificationIdentity, operation.getName(), channel, parameters, language, true)) {
            this.executeSynchronization(() -> this.sendNotificationToServer(notificationIdentity, operation.getName(), channel, parameters, language, ALL_CHANNELS));
        }
    }

    @Override
    public void sendCustomNotification(NotificationIdentity notificationIdentity, String operation, NotificationChannelType channelType, List<Parameter> parameterList, String language) {
        if (!this.sendToNotificationReceivers(notificationIdentity, operation, channelType, parameterList, language, true)) {
            this.executeSynchronization(() -> this.sendNotificationToServer(notificationIdentity, operation, channelType, parameterList, language, ALL_CHANNELS));
        }
    }

    @Override
    public void sendNotificationUnsynchronized(NotificationIdentity notificationIdentity, NotificationOperationType operation, List<Parameter> parameters, String language) {
        this.sendNotificationUnsynchronized(notificationIdentity, operation, null, parameters, language);
    }

    @Override
    public void sendNotificationUnsynchronized(NotificationIdentity notificationIdentity, NotificationOperationType operation, NotificationChannelType channel, List<Parameter> parameters, String language) {
        this.validateParameters(operation, parameters);
        if (!this.sendToNotificationReceivers(notificationIdentity, operation.getName(), channel, parameters, language, false)) {
            this.sendNotificationToServer(notificationIdentity, operation.getName(), channel, parameters, language, ALL_CHANNELS);
        }
    }

    private boolean sendToNotificationReceivers(NotificationIdentity notificationIdentity, String operationName, NotificationChannelType channel, List<Parameter> parameters, String language, boolean isSynchronized) {
        return this.sendToNotificationReceivers(notificationIdentity, operationName, channel, parameters, language, isSynchronized, ALL_CHANNELS);
    }

    private boolean sendToNotificationReceivers(NotificationIdentity notificationIdentity, String operationName, NotificationChannelType channel, List<Parameter> parameters, String language, boolean isSynchronized, List<NotificationChannelType> allowedChannels) {
        if (!this.notificationReceiverService.isApplicableNotification(operationName)) {
            return false;
        }
        Optional<List<NotificationReceiver>> notificationReceivers = this.notificationReceiverService.getNotificationReceivers(notificationIdentity);
        if (notificationReceivers.isEmpty() || notificationReceivers.get().isEmpty()) {
            return false;
        }
        if (isSynchronized) {
            notificationReceivers.get().forEach(notificationReceiver -> this.executeSynchronization(() -> this.sendNotificationToServer((NotificationIdentity)notificationReceiver, operationName, channel, parameters, notificationReceiver.getLanguageCode() != null ? notificationReceiver.getLanguageCode() : language, allowedChannels)));
        } else {
            notificationReceivers.get().forEach(notificationReceiver -> this.sendNotificationToServer((NotificationIdentity)notificationReceiver, operationName, channel, parameters, notificationReceiver.getLanguageCode() != null ? notificationReceiver.getLanguageCode() : language, allowedChannels));
        }
        return true;
    }

    @Override
    public void sendImageLogoToNotificationServer(String identity, String imageData) {
        SetEmailLogoRequest request = new SetEmailLogoRequest();
        request.setIdentity(Identity.fromString((String)identity));
        request.setImageData(Base64Value.fromString((String)imageData));
        HttpRequest setEmailHttpRequest = HttpRequest.newBuilder(SetEmailLogoRequest.class, SetEmailLogoResponse.class, ErrorResponse.class).operation("setemaillogo").request((Object)request).build();
        this.handleRequest(setEmailHttpRequest);
    }

    @Override
    public byte[] getImageLogoFromNotificationServer(String identity) {
        GetEmailLogoRequest request = new GetEmailLogoRequest();
        request.setIdentity(Identity.fromString((String)identity));
        HttpRequest getEmailHttpRequest = HttpRequest.newBuilder(GetEmailLogoRequest.class, GetEmailLogoResponse.class, ErrorResponse.class).operation("getemaillogo").request((Object)request).build();
        return Optional.ofNullable((GetEmailLogoResponse)this.handleRequest(getEmailHttpRequest)).map(GetEmailLogoResponse::getImageData).map(Base64Value::getValueAsByteArray).orElse(null);
    }

    @Override
    public void deleteImageLogoFromNotificationServer(String identity) {
        DeleteEmailLogoRequest request = new DeleteEmailLogoRequest();
        request.setIdentity(Identity.fromString((String)identity));
        HttpRequest deleteEmailHttpRequest = HttpRequest.newBuilder(DeleteEmailLogoRequest.class, DeleteEmailLogoResponse.class, ErrorResponse.class).operation("deleteemaillogo").request((Object)request).build();
        this.handleRequest(deleteEmailHttpRequest);
    }

    private void sendNotificationToServer(NotificationIdentity notificationIdentity, String operationName, NotificationChannelType channel, List<Parameter> parameters, String language, List<NotificationChannelType> allowedNotificationChannels) {
        try {
            ArrayList<ReceiverIdentity> receiverIdentityList = new ArrayList<ReceiverIdentity>();
            if (channel == null) {
                allowedNotificationChannels.forEach(channelType -> NotificationServiceBean.processReceiverNotificationChannels(notificationIdentity, channelType, receiverIdentityList));
            } else if (allowedNotificationChannels.contains((Object)channel)) {
                NotificationServiceBean.processReceiverNotificationChannels(notificationIdentity, channel, receiverIdentityList);
            }
            this.sendNotification(receiverIdentityList, operationName, channel, parameters, language);
        }
        catch (Exception e) {
            logger.trace("Send Notification Failed", e);
        }
    }

    private static void processReceiverNotificationChannels(NotificationIdentity notificationIdentity, NotificationChannelType channelType, List<ReceiverIdentity> receiverIdentityList) {
        notificationIdentity.getNotificationReceiverIdentity(channelType).ifPresent(s -> receiverIdentityList.add(new ReceiverIdentity(Channel.fromString((String)channelType.toString()), Destination.fromString((String)s))));
    }

    final void sendNotification(List<ReceiverIdentity> receiverIdentity, String operation, NotificationChannelType channel, List<Parameter> parameters, String language) {
        if (!receiverIdentity.isEmpty()) {
            SendNotificationRequest sendNotificationRequest = new SendNotificationRequest();
            sendNotificationRequest.setClientId(this.notificationClientId != null ? ClientId.fromString((String)this.notificationClientId) : null);
            sendNotificationRequest.setReceiverIdentities(receiverIdentity);
            sendNotificationRequest.setOperation(OperationName.fromString((String)operation));
            if (channel != null && !channel.getString().trim().isEmpty()) {
                sendNotificationRequest.setChannel(Channel.fromString((String)channel.getString()));
            }
            if (language != null && !language.trim().isEmpty()) {
                sendNotificationRequest.setLanguageCode(LanguageCodeValue.fromString((String)language));
            }
            sendNotificationRequest.setParameters(NSTranslator.translateParameters(parameters));
            FaultIndicationHandler ah = new FaultIndicationHandler(this.faultIndicationService, sendNotificationRequest);
            try {
                HttpRequest sendNotification = HttpRequest.newBuilder(SendNotificationRequest.class, SendNotificationResponse.class, ErrorResponse.class).operation("sendnotification").request((Object)sendNotificationRequest).build();
                this.handleRequest(sendNotification);
                ah.clearFaultIndications();
            }
            catch (NotificationException e) {
                throw ah.reportFaultIndicationAndCreateException(e);
            }
        } else {
            logger.trace("No receiver identities when sending notification for operation: {}", (Object)operation);
        }
    }

    private void executeSynchronization(Runnable runnable) {
        Optional<Transaction> transaction = this.transactionManager.getTransaction();
        if (transaction.isPresent()) {
            transaction.get().afterCommit(tr -> runnable.run());
        } else {
            runnable.run();
        }
    }

    @Override
    public void setNotificationClientId(String clientId) {
        this.notificationClientId = clientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerNotificationOperation(NotificationOperationType[] operations) {
        if (operations != null) {
            for (NotificationOperationType currentOperation : operations) {
                String operationName = currentOperation.getName();
                if (this.notificationOperations.containsKey(operationName)) continue;
                this.notificationOperations.put(operationName, currentOperation);
                this.syncLock.lock();
                try {
                    this.newSyncNeeded = true;
                }
                finally {
                    this.syncLock.unlock();
                }
            }
        }
    }

    @Override
    public List<NotificationOperation> createNotificationList() {
        LinkedList<NotificationOperation> notificationOperationList = new LinkedList<NotificationOperation>();
        for (String name : this.notificationOperations.keySet()) {
            NotificationOperationType notificationOperationType = this.notificationOperations.get(name);
            LinkedList<String> parameterNames = new LinkedList<String>();
            for (int i = 0; i < notificationOperationType.getNumberOfParameters(); ++i) {
                parameterNames.add(notificationOperationType.getParameterName(i));
            }
            NotificationOperation notificationOperation = new NotificationOperation(notificationOperationType.getName(), notificationOperationType.getDefaultMessage(), parameterNames.stream().map(ParameterName::new).collect(Collectors.toList()));
            notificationOperationList.add(notificationOperation);
        }
        return notificationOperationList;
    }

    @Override
    public String queryNotification(NotificationOperationType operation, NotificationChannelType channel, List<Parameter> parameters, String languageCode) {
        this.validateParameters(operation, parameters);
        QueryNotificationRequest queryNotificationRequest = this.createQueryNotificationRequest(operation, channel, parameters, languageCode);
        FaultIndicationHandler alarmHandler = new FaultIndicationHandler(this.faultIndicationService, queryNotificationRequest);
        try {
            HttpRequest queryNotification = HttpRequest.newBuilder(QueryNotificationRequest.class, QueryNotificationResponse.class, ErrorResponse.class).operation("querynotification").request((Object)queryNotificationRequest).build();
            QueryNotificationResponse response = (QueryNotificationResponse)this.handleRequest(queryNotification);
            alarmHandler.clearFaultIndications();
            return Optional.ofNullable(response).map(QueryNotificationResponse::getText).map(NotificationText::getValueAsString).orElse(null);
        }
        catch (NotificationException e) {
            logger.trace("QueryNotification Failed", e);
            throw alarmHandler.reportFaultIndicationAndCreateException(e);
        }
    }

    private QueryNotificationRequest createQueryNotificationRequest(NotificationOperationType operation, NotificationChannelType channel, List<Parameter> parameters, String languageCode) {
        QueryNotificationRequest queryNotificationRequest = new QueryNotificationRequest();
        queryNotificationRequest.setOperation(OperationName.fromString((String)operation.getName()));
        if (languageCode != null && !languageCode.trim().isEmpty()) {
            queryNotificationRequest.setLanguageCode(LanguageCodeValue.fromString((String)languageCode));
        }
        queryNotificationRequest.setParameters(NSTranslator.translateParameters(parameters));
        queryNotificationRequest.setClientId(this.notificationClientId != null ? ClientId.fromString((String)this.notificationClientId) : null);
        if (channel != null && !channel.getString().trim().isEmpty()) {
            queryNotificationRequest.setChannel(Channel.fromString((String)channel.getString()));
        }
        return queryNotificationRequest;
    }

    @PostConstruct
    public void postConstruct() {
        this.timerService.registerTimerListener(new TimerRegistration.TimerRegistrationBuilder().beanId(this.applicationContext.getBeanId()).timerListener(this).pattern("* * * * *").timerCondition(TimerCondition.ANY_NODE).priority(this.priority).build());
    }

    protected FaultIndication getCommunicationFaultIndication() {
        return FaultIndication.newBuilder(NotificationClientFaultIndicationDescription.NOTIFICATION_CONNECTION_ERROR).build();
    }

    protected void onCommunicationError(Throwable error) {
        ErrorResponse response = new ErrorResponse("NOTIFICATION_CONNECTION_ERROR");
        throw new NotificationException(error.getMessage(), response, error);
    }

    public void onResponse(String operation, int status, Object request, Object response) {
        super.onResponse(operation, status, request, response);
        if (status == 500) {
            Class<?> responseClass = response.getClass();
            if (ErrorResponse.class.equals(responseClass)) {
                ErrorResponse errorResponse = (ErrorResponse)response;
                throw new NotificationException("Notification Server Error", errorResponse);
            }
            ErrorResponse r = new ErrorResponse(String.valueOf(status));
            r.addErrorArgument(new ErrorArgument("operation", operation));
            String msg = String.format("Unexpected error of type: %s", responseClass.getName());
            throw new NotificationException(msg, r);
        }
    }

    public void onError(String operation, Object request, int status, String reason) throws HttpClientException {
        super.onError(operation, request, status, reason);
    }

    @ServiceProperty
    public void setPriority(String priority) {
        this.priority = priority.trim().isEmpty() ? null : Integer.valueOf(priority);
    }

    @Override
    public void onPropertyChanged(ApplicationProperties.ApplicationProperty property, String newValue) {
        if (property.getPropertyName().equals(BATCHTRANSACTION_TRANSFERNOTIFICATION_USEACCOUNTOWNERASSENDER.getPropertyName())) {
            this.useAccountOwnerAsSender = Boolean.parseBoolean(newValue);
        }
    }

    @Override
    public boolean isUseAccountOwnerAsSender() {
        return this.useAccountOwnerAsSender;
    }

    @Override
    @ServiceProperty
    public void setUseAccountOwnerAsSender(boolean useAccountOwnerAsSender) {
        this.useAccountOwnerAsSender = useAccountOwnerAsSender;
    }

    private static class FaultIndicationHandler {
        private final String language;
        private final String channel;
        private final String operation;
        private final String notification;
        private final NsFaultIndicationId configError;
        private final NsFaultIndicationId resourceError;
        private final NsFaultIndicationId connectionError;
        private final FaultIndicationService faultIndicationService;

        FaultIndicationHandler(FaultIndicationService faultIndicationService, SendNotificationRequest request) {
            this(faultIndicationService, "sendnotification", request.getOperation().getValueAsString(), Optional.ofNullable(request.getLanguageCode()).map(LanguageCodeValue::getValueAsString).orElse(null), Optional.ofNullable(request.getChannel()).map(Channel::getValueAsString).orElse(null), Optional.ofNullable(request.getClientId()).map(ClientId::getValueAsString).orElse(null));
        }

        FaultIndicationHandler(FaultIndicationService faultIndicationService, SyncNotificationsRequest request) {
            this(faultIndicationService, "syncnotification", "sync", "*", "*", Optional.ofNullable(request.getClientId()).map(ClientId::getValueAsString).orElse(null));
        }

        FaultIndicationHandler(FaultIndicationService faultIndicationService, QueryNotificationRequest request) {
            this(faultIndicationService, "querynotification", request.getOperation().getValueAsString(), Optional.ofNullable(request.getLanguageCode()).map(LanguageCodeValue::getValueAsString).orElse(null), Optional.ofNullable(request.getChannel()).map(Channel::getValueAsString).orElse(null), Optional.ofNullable(request.getClientId()).map(ClientId::getValueAsString).orElse(null));
        }

        private FaultIndicationHandler(FaultIndicationService faultIndicationService, String operation, String notification, String language, String channel, String notificationClientId) {
            this.faultIndicationService = faultIndicationService;
            this.operation = operation;
            this.notification = notification;
            this.language = "*";
            this.channel = "*";
            this.configError = new NsFaultIndicationId(notification, notificationClientId, channel, language, FaultIndication.newBuilder(NotificationClientFaultIndicationDescription.NOTIFICATION_CONFIGURATION_ERROR).build());
            this.resourceError = new NsFaultIndicationId("*", notificationClientId, channel == null || channel.isEmpty() ? "*" : channel, "*", FaultIndication.newBuilder(NotificationClientFaultIndicationDescription.NOTIFICATION_RESOURCE_LIMIT_EXCEEDED).build());
            this.connectionError = new NsFaultIndicationId("*", notificationClientId, "*", "*", FaultIndication.newBuilder(NotificationClientFaultIndicationDescription.NOTIFICATION_CONNECTION_ERROR).build());
        }

        void clearFaultIndications() {
            this.faultIndicationService.report(this.configError.getFaultIndication().buildUpon().severity(FaultIndicationDescription.Severity.CLEAR).build());
            this.faultIndicationService.report(this.resourceError.getFaultIndication().buildUpon().severity(FaultIndicationDescription.Severity.CLEAR).build());
            this.faultIndicationService.report(this.connectionError.getFaultIndication().buildUpon().severity(FaultIndicationDescription.Severity.CLEAR).build());
        }

        NotificationCommunicationException reportFaultIndicationAndCreateException(NotificationException ne) {
            NotificationCommunicationException mappedException;
            String message;
            NotificationCommunicationErrorCode errorStatus;
            ErrorResponse e = ne.getErrorResponse();
            if (e != null) {
                errorStatus = NotificationCommunicationErrorCode.getErrorCodeFromString(e.getErrorCode());
                message = !e.getArguments().isEmpty() ? e.getArguments().get(0).getValue() : e.getErrorCode();
            } else {
                errorStatus = NotificationCommunicationErrorCode.NOTIFICATION_OTHER_ERROR;
                message = String.format("Unexpected Error: %s", ne.getCause() != null ? ne.getCause().getMessage() : ne.getMessage());
            }
            String exceptionMessage = this.operation + (String)(this.notification != null ? "(" + this.notification + ")" : "");
            switch (errorStatus) {
                case NOTIFICATION_TEXT_NOT_FOUND: {
                    this.faultIndicationService.report(this.configError.getFaultIndication());
                    mappedException = new NotificationCommunicationException(NotificationCommunicationErrorCode.NOTIFICATION_TEXT_NOT_FOUND, exceptionMessage);
                    break;
                }
                case INVALID_NOTIFICATION_CHANNEL_FOR_OPERATION: {
                    this.faultIndicationService.report(this.configError.getFaultIndication());
                    mappedException = new NotificationCommunicationException(NotificationCommunicationErrorCode.INVALID_NOTIFICATION_CHANNEL_FOR_OPERATION, exceptionMessage);
                    break;
                }
                case NOTIFICATION_MISSING_PARAMETER: {
                    this.faultIndicationService.report(this.configError.getFaultIndication());
                    mappedException = new NotificationCommunicationException(NotificationCommunicationErrorCode.NOTIFICATION_MISSING_PARAMETER, exceptionMessage);
                    break;
                }
                case NOTIFICATION_QUEUE_FULL: {
                    this.faultIndicationService.report(this.resourceError.getFaultIndication());
                    mappedException = new NotificationCommunicationException(NotificationCommunicationErrorCode.NOTIFICATION_QUEUE_FULL, new Object[0]);
                    break;
                }
                case NOTIFICATION_UNKNOWN_LANGUAGE_CODE: {
                    this.faultIndicationService.report(this.configError.getFaultIndication());
                    mappedException = new NotificationCommunicationException(NotificationCommunicationErrorCode.NOTIFICATION_UNKNOWN_LANGUAGE_CODE, this.language, exceptionMessage);
                    break;
                }
                case NOTIFICATION_UNKNOWN_OPERATION: {
                    this.faultIndicationService.report(this.configError.getFaultIndication());
                    mappedException = new NotificationCommunicationException(NotificationCommunicationErrorCode.NOTIFICATION_UNKNOWN_OPERATION, exceptionMessage);
                    break;
                }
                case NOTIFICATION_UNKNOWN_CHANNEL: {
                    this.faultIndicationService.report(this.configError.getFaultIndication());
                    mappedException = new NotificationCommunicationException(NotificationCommunicationErrorCode.NOTIFICATION_UNKNOWN_CHANNEL, this.channel, exceptionMessage);
                    break;
                }
                case NOTIFICATION_INVALID_DATE_PARAMETER: {
                    this.faultIndicationService.report(this.configError.getFaultIndication());
                    mappedException = new NotificationCommunicationException(NotificationCommunicationErrorCode.NOTIFICATION_INVALID_DATE_PARAMETER, exceptionMessage);
                    break;
                }
                case NOTIFICATION_INVALID_TIME_PARAMETER: {
                    this.faultIndicationService.report(this.configError.getFaultIndication());
                    mappedException = new NotificationCommunicationException(NotificationCommunicationErrorCode.NOTIFICATION_INVALID_TIME_PARAMETER, exceptionMessage);
                    break;
                }
                case NOTIFICATION_INTERNAL_SERVER_ERROR: {
                    this.faultIndicationService.report(this.connectionError.getFaultIndication());
                    mappedException = new NotificationCommunicationException(NotificationCommunicationErrorCode.NOTIFICATION_INTERNAL_SERVER_ERROR, exceptionMessage, message);
                    break;
                }
                case NOTIFICATION_VALIDATION_ERROR: {
                    this.faultIndicationService.report(this.configError.getFaultIndication());
                    mappedException = new NotificationCommunicationException(NotificationCommunicationErrorCode.NOTIFICATION_VALIDATION_ERROR, exceptionMessage, message);
                    break;
                }
                case SYNC_FAILED: {
                    mappedException = new NotificationCommunicationException(NotificationCommunicationErrorCode.SYNC_FAILED, this.operation, message);
                    break;
                }
                case SYNC_CHECKSUM_FAILED: {
                    mappedException = new NotificationCommunicationException(NotificationCommunicationErrorCode.SYNC_CHECKSUM_FAILED, this.operation, message);
                    break;
                }
                default: {
                    this.faultIndicationService.report(this.connectionError.getFaultIndication());
                    mappedException = new NotificationCommunicationException(NotificationCommunicationErrorCode.NOTIFICATION_OTHER_ERROR, exceptionMessage, message);
                }
            }
            return mappedException;
        }
    }
}

