/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.otp;

import com.ericsson.em.emc.entities.OtpEntity;
import com.ericsson.em.emc.notificationclient.NotificationChannelType;
import com.ericsson.em.emc.operations.otp.OtpOperations;
import com.ericsson.em.emc.otp.OtpHistory;
import com.ericsson.em.emc.otp.OtpServiceListener;
import com.ericsson.lwac.ErrorCode;
import com.ericsson.lwac.timer.TimeDependent;
import com.ericsson.lwac.timer.TimerListener;
import java.util.List;
import org.joda.time.DateTime;

public interface OtpService
extends TimerListener,
TimeDependent {
    public void setQuarantineDate(String var1, OtpOperations var2, DateTime var3);

    public int getHistoryMapSize();

    public boolean supportGenericErrorOnFailure();

    public OtpHistory getOtpHistory(String var1, OtpOperations var2);

    public void processOTPHistory(DateTime var1);

    public String generateOtp(OtpEntity var1);

    public OtpResult validateOtp(OtpEntity var1, String var2);

    public ErrorCode getErrorCodeFromValidationResult(OtpStatus var1);

    public void addFailedSecurityAnswerAttempt(String var1);

    public void checkSecurityAnswerFailureLimits(String var1);

    public void resetSecurityAnswerFailCounter(String var1);

    public int getNumberOfSecurityQuestionsForReset();

    public void setOtpOperationAtm(List<String> var1);

    public void setOtpOperationLogin(List<String> var1);

    public void setOtpOperationBankAccountVerification(List<String> var1);

    public void setOtpOperationMsisdnVerification(List<String> var1);

    public void setOtpOperationEmailVerification(List<String> var1);

    public void setOtpOperationDefaultNotificationMsisdnVerification(List<String> var1);

    public void setOtpOperationDefaultNotificationEmailVerification(List<String> var1);

    public void setOtpOperationSelfServiceNotificationReceiverMsisdnVerification(List<String> var1);

    public void setOtpOperationSelfServiceNotificationReceiverEmailVerification(List<String> var1);

    public void setOtpOperationCredentialsReset(List<String> var1);

    public void setOtpOperationCredentialsSelfPinReset(List<String> var1);

    public void setOtpOperationGeneral(List<String> var1);

    public void setOtpOperationRedeemCashVoucher(List<String> var1);

    public void setOtpOperationCancelCashVoucher(List<String> var1);

    public void setOtpOperationReclaimCashVoucher(List<String> var1);

    public void setOtpOperationCashIn(List<String> var1);

    public void setOtpOperationResetCardPin(List<String> var1);

    public void setOtpOperationLinkFinancialResource(List<String> var1);

    public void setOtpOperationCreateDeviceCredential(List<String> var1);

    public void setOtpOperationSetProfile(List<String> var1);

    public void setOtpOperationUpdateIdentification(List<String> var1);

    public void setOtpSecurityQuestions(List<String> var1);

    public void setOtpOperationDownloadDocument(List<String> var1);

    public void registerListener(OtpOperations var1, OtpServiceListener var2);

    public void setOtpOperationVerifyAccountHolder(List<String> var1);

    public void setOtpOperationVerifyPointOfSaleMsisdn(List<String> var1);

    public void setOtpOperationTransfer(List<String> var1);

    public void setOtpOperationPayment(List<String> var1);

    public String getIdentificationForGenericOTP(String var1, String var2);

    public List<NotificationChannelType> getAllowedNotificationChannelsForOtpOperation(OtpOperations var1);

    public static class OtpResult {
        private String target;
        private OtpStatus status;

        public OtpStatus getStatus() {
            return this.status;
        }

        public String getTarget() {
            return this.target;
        }

        public OtpResult(OtpStatus status) {
            this(status, null);
        }

        public OtpResult(OtpStatus status, String target) {
            this.status = status;
            this.target = target;
        }

        public boolean isValid() {
            return this.status.isValid;
        }
    }

    public static enum OtpStatus {
        VALID(true),
        OTP_NOT_FOUND(false),
        INVALID_OTP(false);

        private final boolean isValid;

        public boolean isValid() {
            return this.isValid;
        }

        private OtpStatus(boolean isValid) {
            this.isValid = isValid;
        }
    }
}

