/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.otp.persistence;

import com.ericsson.em.emc.operations.otp.OtpOperations;
import com.ericsson.em.emc.otp.persistence.Otp;
import com.ericsson.em.emc.otp.persistence.OtpDAO;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.database.persistence.ResultSetProcessor;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import jakarta.ejb.Singleton;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.joda.time.DateTime;

@Validatable
@Updatable
@Singleton
@CryptoKeys(keyAliases={"emm.otp.S"})
public class OtpDAOBean
extends CryptoExtendedBaseEntityDAOBean<Otp>
implements OtpDAO {
    private static final int OTP_CURRENT_FINGERPRINT_VERSION = 4;
    static final String OTP_FINGERPRINT_KEY = "emm.otp.S";
    private static final String TABLE_NAME = "emcc$otp";
    private static final String SEQUENCE_NAME = "emcc$otp_seq";
    private static final String[] COLUMNS = new String[]{"id", "expires", "identification", "operationtype", "operation", "otphash", "salt", "tries", "otptarget", "generatedby", "fingerprint", "fingerprintversion", "fingerprintkeygeneration"};

    @Override
    public Otp create(Otp otp) {
        return (Otp)super.create((BaseEntity)otp);
    }

    @Override
    public void delete(String identification) {
        this.delete("delete from emcc$otp where identification = ?", new Object[]{identification.toLowerCase()});
    }

    public Otp update(Otp otp) {
        return (Otp)super.update((BaseEntity)otp);
    }

    @Override
    public Otp find(long id) {
        return (Otp)super.find(id);
    }

    @Override
    public Otp find(String identification) {
        Otp otp = (Otp)this.find("select id, expires, identification, operationtype, operation, otphash, salt, tries, otptarget, generatedby, fingerprint, fingerprintversion, fingerprintkeygeneration from emcc$otp where identification = ?", new Object[]{identification.toLowerCase()});
        return otp;
    }

    protected String getFingerprintKeyAlias() {
        return OTP_FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 4;
    }

    protected String getEntitySimpleName() {
        return "Otp";
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1) {
            DateTime createdDateTime = null;
            if (resultSet.getTimestamp("expires") != null) {
                createdDateTime = new DateTime(resultSet.getTimestamp("expires").getTime());
            }
            return new Object[]{createdDateTime, resultSet.getString("identification"), resultSet.getString("operation"), resultSet.getBytes("otphash"), resultSet.getBytes("salt"), resultSet.getInt("tries")};
        }
        if (fingerprintVersion == 2) {
            DateTime createdDateTime = null;
            if (resultSet.getTimestamp("expires") != null) {
                createdDateTime = new DateTime(resultSet.getTimestamp("expires").getTime());
            }
            return new Object[]{createdDateTime, resultSet.getString("identification"), resultSet.getInt("operationtype"), resultSet.getString("operation"), resultSet.getBytes("otphash"), resultSet.getBytes("salt"), resultSet.getInt("tries")};
        }
        if (fingerprintVersion == 3) {
            DateTime createdDateTime = null;
            if (resultSet.getTimestamp("expires") != null) {
                createdDateTime = new DateTime(resultSet.getTimestamp("expires").getTime());
            }
            return new Object[]{createdDateTime, resultSet.getString("identification"), resultSet.getInt("operationtype"), resultSet.getString("operation"), resultSet.getBytes("otphash"), resultSet.getBytes("salt"), resultSet.getInt("tries"), resultSet.getString("otptarget")};
        }
        if (fingerprintVersion == 4) {
            DateTime createdDateTime = null;
            if (resultSet.getTimestamp("expires") != null) {
                createdDateTime = new DateTime(resultSet.getTimestamp("expires").getTime());
            }
            return new Object[]{createdDateTime, resultSet.getString("identification"), resultSet.getInt("operationtype"), resultSet.getString("operation"), resultSet.getBytes("otphash"), resultSet.getBytes("salt"), resultSet.getInt("tries"), resultSet.getString("otptarget"), resultSet.getString("generatedby")};
        }
        return null;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public String[] getColumns() {
        return COLUMNS;
    }

    public String getSequenceName() {
        return SEQUENCE_NAME;
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    public boolean isVersionable() {
        return false;
    }

    public boolean isUpdatable() {
        return true;
    }

    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        int i = 1;
        Otp otp = (Otp)baseEntity;
        preparedStatement.setTimestamp(i++, new Timestamp(otp.getExpiryDate().getMillis()));
        preparedStatement.setString(i++, otp.getIdentification());
        preparedStatement.setInt(i++, otp.getOperationType().ordinal());
        preparedStatement.setString(i++, otp.getOperation());
        preparedStatement.setBytes(i++, otp.getOtpHash());
        preparedStatement.setBytes(i++, otp.getSalt());
        preparedStatement.setInt(i++, otp.getTries());
        preparedStatement.setString(i++, otp.getOtpTarget());
        preparedStatement.setString(i++, otp.getGeneratedBy());
        i = this.assignFingerprint(preparedStatement, i, new Object[]{otp.getExpiryDate(), otp.getIdentification(), otp.getOperationType().ordinal(), otp.getOperation(), otp.getOtpHash(), otp.getSalt(), otp.getTries(), otp.getOtpTarget(), otp.getGeneratedBy()});
        return i;
    }

    protected void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        Otp otp = (Otp)baseEntity;
        Timestamp created = resultSet.getTimestamp("expires");
        otp.setExpiryDate(new DateTime(created.getTime()));
        otp.setIdentification(resultSet.getString("identification"));
        int operationTypeValue = resultSet.getInt("operationtype");
        for (OtpOperations operationType : OtpOperations.values()) {
            if (operationType.ordinal() != operationTypeValue) continue;
            otp.setOperationType(operationType);
            break;
        }
        otp.setOperation(resultSet.getString("operation"));
        otp.setOtpHash(resultSet.getBytes("otphash"));
        otp.setSalt(resultSet.getBytes("salt"));
        otp.setTries(resultSet.getInt("tries"));
        otp.setOtpTarget(resultSet.getString("otptarget"));
        otp.setGeneratedBy(resultSet.getString("generatedby"));
    }

    protected Otp createManagedEntity() {
        return new Otp();
    }

    @Override
    public void processOtp(ResultSetProcessor resultSetProcessor, DateTime now) {
        String statement = "select id from emcc$otp where expires < ?";
        this.processResultSet(statement, "id", resultSetProcessor, new Object[]{now});
    }
}

