/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.profile;

import com.ericsson.em.emc.util.MoneyHelper;
import java.util.Objects;
import java.util.function.Function;

public enum PermissionWithProperty {
    DEFAULT("maxLevelInHierarchy", PermissionWithProperty::isNonNegativeInteger),
    ROLE_FLOAT_TRANSFER_IN_OWN_ASCENDING_LINE("maxLevelsUpInHierarchy", PermissionWithProperty::isPositiveInteger),
    ROLE_FLOAT_TRANSFER_IN_OWN_DESCENDING_LINE("maxLevelsDownInHierarchy", PermissionWithProperty::isPositiveInteger),
    ROLE_FLOAT_TRANSFER_WITHIN_OWN_SUB_HIERARCHY("subHierarchyStartingLevel", PermissionWithProperty::isPositiveInteger),
    ROLE_APPROVAL_ON_REVERSE_TRANSACTION("ApprovalLimits", PermissionWithProperty::isApprovalLimit);

    private final String property;
    private final Function<String, Boolean> validator;
    private static final String DELIMITER = ":";

    private PermissionWithProperty(String property, Function<String, Boolean> validator) {
        this.property = property;
        this.validator = validator;
    }

    public static PermissionWithProperty fromPermission(String permission) {
        for (PermissionWithProperty p : PermissionWithProperty.values()) {
            if (!Objects.equals(p.name(), permission)) continue;
            return p;
        }
        return DEFAULT;
    }

    public String getProperty() {
        return this.property;
    }

    public boolean isValid(String value) {
        return this.validator.apply(value);
    }

    private static boolean isNonNegativeInteger(String value) {
        try {
            return Integer.parseInt(value) >= 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static boolean isPositiveInteger(String value) {
        try {
            return Integer.parseInt(value) > 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static Boolean isApprovalLimit(String value) {
        try {
            return MoneyHelper.convertStringToMonies(value, DELIMITER).size() > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

