/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.readonly;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ReadOnlySettings {
    private static final String MATCH_ALL_REGEX = "*";
    private static final String PROPERTY_KEY_VALUE_SEPARATOR = ":";
    private static final String PROPERTY_KEY_MATCH_REGEX = "(?i)%s:";
    private static final String CONTEXT_SEPARATOR = "\\s*,\\s*";
    private static final String INCLUDE_CONTEXT_REGEX = "^\\s*(?:\\*|(?:(?:\\s*,\\s*)*[\\w-]+(?:\\s*,\\s*)*)*)\\s*$";
    private static final String EXCLUDE_CONTEXT_REGEX = "^\\s*(?:(?:\\s*,\\s*)*[\\w-]+(?:\\s*,\\s*)*)*\\s*$";
    private boolean isEnabled = false;
    private final List<String> includeContexts = new ArrayList<String>();
    private final List<String> excludeContexts = new ArrayList<String>();

    public ReadOnlySettings() {
    }

    public ReadOnlySettings(List<String> settings) {
        if (settings == null || settings.isEmpty()) {
            return;
        }
        settings.forEach(propertyWithValue -> {
            String upperCasePropertyWithValue = propertyWithValue.toUpperCase();
            if (upperCasePropertyWithValue.startsWith(PropertyNames.ENABLED.name() + PROPERTY_KEY_VALUE_SEPARATOR)) {
                this.isEnabled = Boolean.parseBoolean(this.extractValue((String)propertyWithValue, PropertyNames.ENABLED).trim());
            } else if (upperCasePropertyWithValue.startsWith(PropertyNames.INCLUDECONTEXTS.name() + PROPERTY_KEY_VALUE_SEPARATOR)) {
                this.setIncludeContexts((String)propertyWithValue);
            } else if (upperCasePropertyWithValue.startsWith(PropertyNames.EXCLUDECONTEXTS.name() + PROPERTY_KEY_VALUE_SEPARATOR)) {
                this.setExcludeContexts((String)propertyWithValue);
            }
        });
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public List<String> getIncludeContexts() {
        return this.includeContexts;
    }

    public void setIncludeContexts(List<String> includeContexts) {
        this.includeContexts.clear();
        this.includeContexts.addAll(includeContexts);
    }

    private void setIncludeContexts(String propertyWithValue) {
        String includeContextsString = this.extractValue(propertyWithValue, PropertyNames.INCLUDECONTEXTS);
        if (!includeContextsString.matches(INCLUDE_CONTEXT_REGEX)) {
            throw new IllegalArgumentException(String.format("%s is not a valid include context list.", includeContextsString));
        }
        if (!includeContextsString.trim().isEmpty()) {
            this.setIncludeContexts(Arrays.asList(includeContextsString.trim().split(CONTEXT_SEPARATOR)));
        }
    }

    public List<String> getExcludeContexts() {
        return this.excludeContexts;
    }

    public void setExcludeContexts(List<String> excludeContexts) {
        this.excludeContexts.clear();
        this.excludeContexts.addAll(excludeContexts);
    }

    private void setExcludeContexts(String propertyWithValue) {
        String excludeContextsString = this.extractValue(propertyWithValue, PropertyNames.EXCLUDECONTEXTS);
        if (!excludeContextsString.matches(EXCLUDE_CONTEXT_REGEX)) {
            throw new IllegalArgumentException(String.format("%s is not a valid exclude context list.", excludeContextsString));
        }
        if (!excludeContextsString.trim().isEmpty()) {
            this.setExcludeContexts(Arrays.asList(excludeContextsString.trim().split(CONTEXT_SEPARATOR)));
        }
    }

    private String extractValue(String propertyWithValue, PropertyNames propertyName) {
        return propertyWithValue.replaceFirst(String.format(PROPERTY_KEY_MATCH_REGEX, propertyName.name()), "");
    }

    boolean isIncludeAllContexts() {
        return this.includeContexts.isEmpty() || this.includeContexts.size() == 1 && MATCH_ALL_REGEX.equals(this.includeContexts.get(0));
    }

    private static enum PropertyNames {
        ENABLED,
        INCLUDECONTEXTS,
        EXCLUDECONTEXTS;

    }
}

