/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.transactionid;

import com.ericsson.em.emc.transactionid.TransactionIdService;
import com.ericsson.lwac.database.persistence.sequence.SequenceHelper;
import com.ericsson.lwac.deployer.service.Service;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.EJB;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DateTime;

@Service
public class TransactionIdServiceBean
implements TransactionIdService {
    private static final String SEQUENCE_NAME = "emcc$transactionid";
    private final Map<Thread, TransactionId> threadMap = new ConcurrentHashMap<Thread, TransactionId>();
    @EJB
    private SequenceHelper sequenceHelper;
    private DateTime transactionDate;

    @Override
    public void reset() {
        this.threadMap.remove(Thread.currentThread());
    }

    @Override
    public Long getTransactionId() {
        TransactionId id = this.getTransactionIdData();
        return id.getTransactionId();
    }

    @Override
    public Long getNextSubTransactionId() {
        TransactionId id = this.getTransactionIdData();
        return id.getNextSubTransactionId();
    }

    @Override
    public DateTime getTransactionDateTime() {
        TransactionId id = this.getTransactionIdData();
        return id.getTransactionDateTime();
    }

    @Override
    @RolesAllowed(value={"ROLE_TEST"})
    public void setTransactionDateTime(DateTime now) {
        this.transactionDate = now;
    }

    private TransactionId getTransactionIdData() {
        Thread thread = Thread.currentThread();
        TransactionId transactionId = this.threadMap.get(thread);
        if (!this.threadMap.containsKey(thread)) {
            transactionId = new TransactionId(this.sequenceHelper.getNextValue(SEQUENCE_NAME));
            if (this.transactionDate != null) {
                transactionId.transactionDateTime = this.transactionDate;
            }
            this.threadMap.put(thread, transactionId);
        }
        return transactionId;
    }

    private static class TransactionId {
        Long transactionId;
        Long currentSubTransactionId = 0L;
        DateTime transactionDateTime = new DateTime();

        TransactionId(Long transactionId) {
            this.transactionId = transactionId;
        }

        Long getTransactionId() {
            return this.transactionId;
        }

        Long getNextSubTransactionId() {
            Long l = this.currentSubTransactionId;
            Long l2 = this.currentSubTransactionId = Long.valueOf(this.currentSubTransactionId + 1L);
            return l;
        }

        DateTime getTransactionDateTime() {
            return this.transactionDateTime;
        }
    }
}

