/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.util;

import com.ericsson.lwac.transaction.TransactionManager;
import com.ericsson.lwac.transaction.UnstartedTransaction;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class Debounce {
    private static ScheduledExecutorService fakedExecutor;
    private final long delay;
    private final TimeUnit delayTimeUnit;
    private final Map<MethodCallArguments, AtomicInteger> debouncedCalls = Maps.newHashMap();
    private final Map<MethodCallArguments, CompletableFuture<Object>> debouncedFutures = Maps.newHashMap();
    private final Object mutex = new Object();
    private static final AtomicLong debounceSequence;
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("debounce-" + debounceSequence.incrementAndGet()).build());

    private Debounce(long delay, TimeUnit delayTimeUnit) {
        this.delay = delay;
        this.delayTimeUnit = delayTimeUnit;
    }

    public DebounceCall arguments(Object ... arguments) {
        return new DebounceCall().arguments(arguments);
    }

    @VisibleForTesting
    public static void setFakeExecutorForTesting(ScheduledExecutorService fake) {
        fakedExecutor = fake;
    }

    public static Debounce of(long delay, TimeUnit delayTimeUnit) {
        return new Debounce(delay, delayTimeUnit);
    }

    static {
        debounceSequence = new AtomicLong();
    }

    private static class MethodCallArguments {
        private final Object[] arguments;

        private MethodCallArguments(Object[] arguments) {
            this.arguments = (Object[])arguments.clone();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodCallArguments that = (MethodCallArguments)o;
            return Arrays.equals(this.arguments, that.arguments);
        }

        public int hashCode() {
            return Arrays.hashCode(this.arguments);
        }
    }

    public class DebounceCall {
        private Object[] arguments = new Object[0];
        @Nullable
        private TransactionManager transactionManager;

        private DebounceCall arguments(Object ... arguments) {
            this.arguments = arguments;
            return this;
        }

        public DebounceCall withTransaction(TransactionManager transactionManager) {
            this.transactionManager = transactionManager;
            return this;
        }

        public <RET> CompletableFuture<RET> call(Callable<RET> callback) {
            return this.invoke(callback);
        }

        public CompletableFuture<Void> call(Runnable callback) {
            return this.invoke(() -> {
                callback.run();
                return null;
            });
        }

        private ScheduledExecutorService getExecutorService() {
            return fakedExecutor != null ? fakedExecutor : Debounce.this.executorService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <RET> CompletableFuture<RET> invoke(Callable<RET> callback) {
            MethodCallArguments argumentKey = new MethodCallArguments(this.arguments);
            Object object = Debounce.this.mutex;
            synchronized (object) {
                boolean noDelay = Debounce.this.delayTimeUnit.toNanos(Debounce.this.delay) == 0L;
                AtomicInteger callCount = Debounce.this.debouncedCalls.computeIfAbsent(argumentKey, it -> new AtomicInteger(0));
                CompletableFuture debouncedFuture = noDelay ? new CompletableFuture() : Debounce.this.debouncedFutures.computeIfAbsent(argumentKey, it -> new CompletableFuture());
                int callCountBefore = callCount.incrementAndGet();
                this.getExecutorService().schedule(() -> {
                    Object object = Debounce.this.mutex;
                    synchronized (object) {
                        int callCountAfter = callCount.get();
                        if (callCountAfter != callCountBefore && !noDelay) {
                            return null;
                        }
                        Debounce.this.debouncedCalls.remove(argumentKey);
                        Debounce.this.debouncedFutures.remove(argumentKey);
                    }
                    try {
                        if (this.transactionManager != null) {
                            debouncedFuture.complete(this.transactionManager.invokeAsTransaction(UnstartedTransaction.createWithDefaultTimeout(), callback::call));
                        } else {
                            debouncedFuture.complete(callback.call());
                        }
                    }
                    catch (Exception e) {
                        debouncedFuture.completeExceptionally(e);
                    }
                    return null;
                }, Debounce.this.delay, Debounce.this.delayTimeUnit);
                return debouncedFuture;
            }
        }
    }
}

