/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.util;

import com.ericsson.em.emc.m3externallog.json.converters.XmlExtensionConverter;
import com.ericsson.em.emc.util.XmlFactory;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlExtension
implements Serializable {
    private static final int MAX_DEPTH = 20;
    private static final Logger log = LoggerFactory.getLogger(XmlExtension.class);
    private static final long serialVersionUID = 1L;
    private List<Element> extensionData;
    private static final DocumentBuilderFactory documentBuilderFactory = XmlFactory.newDocumentBuilderFactory();

    public static XmlExtension create(List<Element> listOfElement) {
        return new XmlExtension(listOfElement);
    }

    public static XmlExtension create(String xmlData) {
        return new XmlExtension(XmlExtension.listFromString(xmlData));
    }

    public XmlExtension(List<Element> listOfElement) {
        this.extensionData = listOfElement;
    }

    public List<Element> getExtensionData() {
        return this.extensionData;
    }

    public String toJsonString() {
        return new GsonBuilder().setPrettyPrinting().registerTypeAdapter((Type)((Object)XmlExtension.class), new XmlExtensionConverter()).create().toJson(this);
    }

    public String toString() {
        return this.toJsonString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        String string = XmlExtension.listToString(this.extensionData);
        out.writeUTF(string);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.extensionData = XmlExtension.listFromString(in.readUTF());
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("Stream data required");
    }

    public static String listToString(List<Element> list) {
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element mainElement = document.createElement("extension");
            document.appendChild(mainElement);
            if (list != null && !list.isEmpty()) {
                for (Element el : list) {
                    int i;
                    Node imported = document.importNode(el, true);
                    NamedNodeMap nnm = imported.getAttributes();
                    int size = nnm.getLength();
                    String[] removeNames = new String[size];
                    for (i = 0; i < size; ++i) {
                        Node n = nnm.item(i);
                        String s = n.getNodeName();
                        if (!s.startsWith("xmlns")) continue;
                        removeNames[i] = n.getNodeName();
                    }
                    for (i = 0; i < size; ++i) {
                        if (removeNames[i] == null) continue;
                        nnm.removeNamedItem(removeNames[i]);
                    }
                    mainElement.appendChild(imported);
                }
            }
            Transformer transformer = XmlExtension.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
            return writer.toString();
        }
        catch (ParserConfigurationException | TransformerException x) {
            throw new RuntimeException(x);
        }
    }

    private static List<Element> listFromString(String data) {
        try {
            if (data == null || data.isEmpty()) {
                return null;
            }
            Transformer transformer = XmlExtension.newTransformer();
            StringReader reader = new StringReader(data);
            DOMResult domResult = new DOMResult();
            transformer.transform(new StreamSource(reader), domResult);
            Node node = domResult.getNode();
            Node firstChild = node.getFirstChild();
            NodeList nodeList = firstChild.getChildNodes();
            int size = nodeList.getLength();
            ArrayList<Element> elements = new ArrayList<Element>(size);
            for (int i = 0; i < size; ++i) {
                elements.add((Element)nodeList.item(i));
            }
            return elements;
        }
        catch (TransformerException x) {
            throw new RuntimeException(x);
        }
    }

    private static Transformer newTransformer() throws TransformerConfigurationException {
        TransformerFactory factory = XmlFactory.newTransformerFactory();
        return factory.newTransformer();
    }

    static {
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
    }
}

