/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emm.ere.modifiers.custom;

import com.ericsson.em.emm.ere.modifiers.custom.model.EntryModel;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.expression.Expression;
import com.ericsson.ere.expression.ExpressionEvaluator;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.expression.PostfixEvaluator;
import com.ericsson.ere.expression.ShuntingYardConverter;
import com.ericsson.ere.expression.StandardInfixOperatorRules;
import com.ericsson.ere.selectiontree.BeanBasedPluginConfiguration;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.ParseContextAdapter;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import com.ericsson.ere.selectiontree.modifiers.DefaultDataSetValueReader;
import com.ericsson.ere.selectiontree.modifiers.mfo.DataSetEvaluationContext;
import com.ericsson.ere.selectiontree.modifiers.mfo.ExpressionXMLReader;
import com.ericsson.ere.selectiontree.modifiers.mfo.TrafficExpressionXMLReader;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.xml.XMLUtil;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class CollectionOfMultiFieldsConfiguration
extends BeanBasedPluginConfiguration {
    private static final String ATTR_DEST_FIELD_NAME = "name";
    private static final String TAG_DEST_FIELD = "DestField";
    private static final String TAG_DEST_FIELD_INDEX = "Index";
    private static final String TAG_ENTRY = "Entry";
    private static final String TAG_ENTRY_NAME = "Name";
    private static final String TAG_ENTRY_EXPRESSION = "Expression";
    private final String destinationField;
    private final ValueFieldCompositeObject key;
    private final FieldIndexKeyContainer keyContainer;
    private final List<EntryConfiguration> entries;

    public static CollectionOfMultiFieldsConfiguration createReader(ParseContext ctx) {
        TrafficExpressionXMLReader expressionReader = new TrafficExpressionXMLReader(ctx.getClassRepository(), DefaultDataSetValueReader.INSTANCE);
        String destinationField = CollectionOfMultiFieldsConfiguration.getDestinationFieldFromXML(ctx.getXMLNode());
        ValueFieldCompositeObject key = CollectionOfMultiFieldsConfiguration.getKeyFromXML(ctx.getXMLNode());
        FieldIndexKeyContainer keyContainer = CollectionOfMultiFieldsConfiguration.createKeyContainer(ctx, destinationField);
        List<Element> elements = XMLUtil.getElementNodesNamed(TAG_ENTRY, ctx.getXMLNode().getChildNodes());
        if (elements.isEmpty()) {
            throw new IllegalArgumentException("CollectionOfMultiFields must have at least one entry");
        }
        List<EntryConfiguration> configurableTaxes = elements.stream().map(element -> CollectionOfMultiFieldsConfiguration.createReader(element, ctx, (ExpressionXMLReader)expressionReader)).collect(Collectors.toList());
        return new CollectionOfMultiFieldsConfiguration(ctx, destinationField, key, keyContainer, configurableTaxes);
    }

    public static CollectionOfMultiFieldsConfiguration createReader(ClassRepository repository, Node config, ExpressionXMLReader reader) {
        ParseContextAdapter ctx = new ParseContextAdapter(repository, config, null);
        String destinationField = CollectionOfMultiFieldsConfiguration.getDestinationFieldFromXML(config);
        ValueFieldCompositeObject key = CollectionOfMultiFieldsConfiguration.getKeyFromXML(config);
        FieldIndexKeyContainer keyContainer = CollectionOfMultiFieldsConfiguration.createKeyContainer(ctx, destinationField);
        List<Element> elements = XMLUtil.getElementNodesNamed(TAG_ENTRY, config.getChildNodes());
        if (elements.isEmpty()) {
            throw new IllegalArgumentException("CollectionOfMultiFields must have at least one entry");
        }
        List<EntryConfiguration> entryConfigurations = elements.stream().map(element -> CollectionOfMultiFieldsConfiguration.createReader(element, ctx, reader)).collect(Collectors.toList());
        return new CollectionOfMultiFieldsConfiguration(ctx, destinationField, key, keyContainer, entryConfigurations);
    }

    public static CollectionOfMultiFieldsConfiguration createWriter(String destField, List<EntryModel> entries, Function<Expression, Node> expressionConverter) {
        if (entries.isEmpty()) {
            throw new IllegalArgumentException("CollectionOfMultiFields must have at least one entry");
        }
        List<EntryConfiguration> entryConfigurations = entries.stream().map(entry -> CollectionOfMultiFieldsConfiguration.createWriter(entry.getEntryName(), entry.getExpression(), expressionConverter)).collect(Collectors.toList());
        return new CollectionOfMultiFieldsConfiguration(null, destField, null, null, entryConfigurations);
    }

    private static EntryConfiguration createReader(Element element, ParseContext ctx, ExpressionXMLReader expressionReader) {
        NodeList children = element.getChildNodes();
        String name = CollectionOfMultiFieldsConfiguration.getNameFromXML(children);
        Expression originalInfixExpression = CollectionOfMultiFieldsConfiguration.getExpressionFromXML(children, expressionReader);
        Expression postfixExpression = originalInfixExpression.convert(new ShuntingYardConverter(new StandardInfixOperatorRules()));
        return new EntryConfiguration(ctx, name, originalInfixExpression, postfixExpression, null);
    }

    private static EntryConfiguration createWriter(String name, Expression expression, Function<Expression, Node> expressionConverter) {
        Expression postfixExpression = expression.convert(new ShuntingYardConverter(new StandardInfixOperatorRules()));
        return new EntryConfiguration(null, name, expression, postfixExpression, expressionConverter);
    }

    private static String getNameFromXML(NodeList children) {
        Element fieldNameNode = XMLUtil.getNamedElement(TAG_ENTRY_NAME, children);
        String name = XMLUtil.getFirstTextContent(fieldNameNode);
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Tag Name is required for Entry");
        }
        return name;
    }

    private static Expression getExpressionFromXML(NodeList children, ExpressionXMLReader reader) {
        Element expressionElement = XMLUtil.getNamedElement(TAG_ENTRY_EXPRESSION, children);
        if (expressionElement == null) {
            throw new IllegalArgumentException("Tag Expression is required for Entry");
        }
        Expression expression = reader.read(expressionElement);
        if (expression.getNotation() != Expression.ExpressionNotation.INFIX) {
            throw new IllegalArgumentException("Entry requires an " + Expression.ExpressionNotation.INFIX + " expression.");
        }
        return expression;
    }

    private static FieldIndexKeyContainer createKeyContainer(ParseContext ctx, String destField) {
        FieldIndexKeyContainer keyContainer = null;
        if (ctx.getClassRepository() != null) {
            keyContainer = CollectionOfMultiFieldsConfiguration.getKeyContainerFromXML(ctx.getXMLNode(), ctx.getClassRepository(), destField);
        }
        return keyContainer;
    }

    private static FieldIndexKeyContainer getKeyContainerFromXML(Node config, ClassRepository rep, String field) {
        Element index = CollectionOfMultiFieldsConfiguration.getFirstElementNamed(config, TAG_DEST_FIELD_INDEX);
        FieldDefinition indexedField = rep.getFieldDefinitionByName(field);
        return FieldOrientedPluginUtil.extractIndexKeyObjectFromIndexElement(index, rep, (FieldHierarchyNode)indexedField);
    }

    private static Element getFirstElementNamed(Node parent, String name) {
        List<Element> list = XMLUtil.getElementNodesNamed(name, parent.getChildNodes());
        return !list.isEmpty() ? list.get(0) : null;
    }

    private static String getDestinationFieldFromXML(Node config) {
        String fieldName;
        Element field = CollectionOfMultiFieldsConfiguration.getFirstElementNamed(config, TAG_DEST_FIELD);
        String string = fieldName = field == null ? "" : field.getAttribute(ATTR_DEST_FIELD_NAME);
        if ("".equals(fieldName)) {
            throw new IllegalArgumentException("No destination field specified for CollectionOfMultiFieldsModifier.");
        }
        return fieldName;
    }

    private static ValueFieldCompositeObject getKeyFromXML(Node config) {
        Element index = CollectionOfMultiFieldsConfiguration.getFirstElementNamed(config, TAG_DEST_FIELD_INDEX);
        return FieldOrientedPluginUtil.createValueFieldCompositeObjectFromIndexElement(index);
    }

    private CollectionOfMultiFieldsConfiguration(ParseContext ctx, String destinationField, ValueFieldCompositeObject key, FieldIndexKeyContainer keyContainer, List<EntryConfiguration> entries) {
        super(ctx);
        this.destinationField = destinationField;
        this.key = key;
        this.keyContainer = keyContainer;
        this.entries = entries;
    }

    @Override
    public void appendXML(Node parent) {
        Element destField = parent.getOwnerDocument().createElement(TAG_DEST_FIELD);
        destField.setAttribute(ATTR_DEST_FIELD_NAME, this.destinationField);
        parent.appendChild(destField);
        if (this.entries != null) {
            this.entries.forEach(ctm -> this.appendXMLWithConfigurableTax(parent, (EntryConfiguration)ctm));
        }
    }

    public String getDestinationField() {
        return this.destinationField;
    }

    public FieldIndexKeyContainer getKeyContainer() {
        return this.keyContainer;
    }

    public List<EntryConfiguration> getEntries() {
        return this.entries;
    }

    public ValueFieldCompositeObject getKey() {
        return this.key;
    }

    private void appendXMLWithConfigurableTax(Node parent, EntryConfiguration entryConfiguration) {
        Element configurableTax = parent.getOwnerDocument().createElement(TAG_ENTRY);
        entryConfiguration.appendXML(configurableTax);
        parent.appendChild(configurableTax);
    }

    public static class EntryConfiguration
    extends BeanBasedPluginConfiguration {
        private final String name;
        private final Expression postfixExpression;
        private final Expression originalInfixExpression;
        private final Function<Expression, Node> expressionConverter;

        EntryConfiguration(ParseContext ctx, String name, Expression infixExpression, Expression postfixExpression, Function<Expression, Node> expressionConverter) {
            super(ctx);
            this.originalInfixExpression = infixExpression;
            this.postfixExpression = postfixExpression;
            this.name = name;
            this.expressionConverter = expressionConverter;
        }

        public String getName() {
            return this.name;
        }

        public Expression getExpression() {
            return this.originalInfixExpression;
        }

        @Override
        public void appendXML(Node parent) {
            Element nameField = parent.getOwnerDocument().createElement(CollectionOfMultiFieldsConfiguration.TAG_ENTRY_NAME);
            nameField.setTextContent(this.name);
            parent.appendChild(nameField);
            if (this.expressionConverter == null) {
                throw new IllegalArgumentException("Expression converter was not initialized");
            }
            Node expressionElement = this.expressionConverter.apply(this.originalInfixExpression);
            expressionElement = parent.getOwnerDocument().importNode(expressionElement, true);
            parent.appendChild(expressionElement);
        }

        public Map.Entry<String, Object> evaluate(final DataSet theData) throws TreeExecutionException {
            final PostfixEvaluator evaluator = new PostfixEvaluator();
            DataSetEvaluationContext context = new DataSetEvaluationContext(){

                @Override
                public DataSet getDataSet() {
                    return theData;
                }

                @Override
                public ExpressionEvaluator getEvaluator() {
                    return evaluator;
                }
            };
            try {
                Operand result = this.postfixExpression.evaluate(context);
                Object value = result.getValue(context);
                return new AbstractMap.SimpleEntry<String, Object>(this.name, value);
            }
            catch (RuntimeException e) {
                throw new TreeExecutionException(e);
            }
        }
    }
}

