/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emm.ere.modifiers.custom;

import com.ericsson.em.emm.ere.modifiers.custom.CollectionOfMultiFieldsConfiguration;
import com.ericsson.ere.annotations.ConfigurationClass;
import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.modifiers.ImmutableModifier;
import com.ericsson.ere.selectiontree.modifiers.mfo.AbstractDestinationFieldInfo;
import com.ericsson.ere.selectiontree.modifiers.mfo.DestinationFieldInfo;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.trace.TracePoint;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.TariffStructureNode;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Immutable
@ConfigurationClass(value=CollectionOfMultiFieldsConfiguration.class)
public final class CollectionOfMultiFieldsModifier
extends ImmutableModifier {
    private final DestinationFieldInfo destinationFieldInfo;
    private final List<CollectionOfMultiFieldsConfiguration.EntryConfiguration> entries;

    public static CollectionOfMultiFieldsModifier create(ParseContext ctx, TariffStructureNode[] children) {
        return new CollectionOfMultiFieldsModifier(ctx);
    }

    private CollectionOfMultiFieldsModifier(ParseContext ctx) {
        super(ctx);
        CollectionOfMultiFieldsConfiguration config = CollectionOfMultiFieldsConfiguration.createReader(ctx);
        this.destinationFieldInfo = this.createDestinationFieldInfo(ctx.getClassRepository(), config.getDestinationField(), config.getKeyContainer());
        this.entries = config.getEntries();
    }

    @Override
    public void perform(DataSet theData) {
        Map<String, Object> result = this.entries.stream().map(ct -> ct.evaluate(theData)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.storeResult(theData, result);
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    @Override
    public String describeTrace(TracePoint tp) {
        return "";
    }

    private DestinationFieldInfo createDestinationFieldInfo(ClassRepository rep, String destinationField, FieldIndexKeyContainer key) {
        FieldDefinition field = this.getFieldOrThrow(rep, destinationField);
        DataType dt = field.getTypedDataType();
        if (!dt.equals(DataType.OBJECT)) {
            throw new UnsupportedOperationException("Destination field data type must be an OBJECT: " + dt);
        }
        return new CollectionOfMultiFieldsFieldInfo(field, key);
    }

    private FieldDefinition getFieldOrThrow(ClassRepository repository, String name) {
        FieldDefinition field = repository.getFieldDefinitionByName(name);
        if (field == null) {
            throw new IllegalArgumentException("Field not found in class repository: " + name);
        }
        return field;
    }

    private void storeResult(DataSet dataSet, Object resultValue) {
        Object finalValue = this.destinationFieldInfo.convertValue(dataSet, resultValue);
        this.setDestinationFieldValue(dataSet, finalValue);
    }

    private void setDestinationFieldValue(DataSet dataSet, Object value) {
        DestinationFieldInfo info = this.destinationFieldInfo;
        DataSetField destField = info.getDestinationField();
        if (info.useKeyForDestination()) {
            Key[] keys;
            FieldIndexKeyContainer fieldKeyContainer = info.retrieveKeyContainerForDestination();
            for (Key key : keys = fieldKeyContainer.getKeySet(dataSet)) {
                destField.setValueInDataSet(dataSet, key, value);
            }
        } else {
            destField.setValueInDataSet(dataSet, value);
        }
    }

    private static class CollectionOfMultiFieldsFieldInfo
    extends AbstractDestinationFieldInfo {
        CollectionOfMultiFieldsFieldInfo(FieldDefinition field, FieldIndexKeyContainer key) {
            super(field, key);
        }

        @Override
        public Object convertValue(DataSet dataSet, Object resultValue) {
            return resultValue;
        }
    }
}

