/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emm.ere.rma.custom;

import com.ericsson.em.emm.ere.modifiers.custom.CollectionOfMultiFieldsConfiguration;
import com.ericsson.em.emm.ere.modifiers.custom.model.EntryModel;
import com.ericsson.em.emm.ere.rma.ExtendedStringVariable;
import com.ericsson.em.emm.ere.rma.custom.mfo.ExpressionToDomModelConverter;
import com.ericsson.em.emm.ere.rma.custom.model.CollectionOfMultiFieldsModel;
import com.ericsson.em.emm.ere.rma.custom.model.CollectionOfMultiFieldsModelEntry;
import com.ericsson.em.emm.ere.rma.custom.view.CollectionOfMultiFieldEntriesVariable;
import com.ericsson.em.emm.ere.rma.custom.view.CollectionOfMultiFieldEntryNameVariable;
import com.ericsson.em.emm.ere.rma.custom.view.CollectionOfMultiFieldsEntryVariable;
import com.ericsson.em.emm.ere.rma.custom.view.CollectionOfMultiFieldsResultExpressionVariable;
import com.ericsson.em.emm.ere.rma.utils.CollectionOfMultiFieldsUtils;
import com.ericsson.ere.constraint.ConstraintService;
import com.ericsson.ere.constraint.contract.Constrainable;
import com.ericsson.ere.constraint.entity.ConstraintContext;
import com.ericsson.ere.constraint.entity.ConstraintContextItemType;
import com.ericsson.ere.expression.Expression;
import com.ericsson.ere.expression.Function;
import com.ericsson.ere.expression.FunctionParameterInfo;
import com.ericsson.ere.expression.Functions;
import com.ericsson.ere.expression.Operator;
import com.ericsson.ere.expression.Operators;
import com.ericsson.ere.selectiontree.FieldFilter;
import com.ericsson.ere.selectiontree.modifiers.AbstractFieldOrientedModifierProfile;
import com.ericsson.ere.selectiontree.modifiers.MultiFieldOperationProfile;
import com.ericsson.ere.selectiontree.modifiers.MultiFieldOperationProfileContract;
import com.ericsson.ere.selectiontree.modifiers.mfo.ExpressionVariable;
import com.ericsson.ere.selectiontree.modifiers.mfo.ExpressionXMLReader;
import com.ericsson.ere.selectiontree.modifiers.mfo.FieldUseEvaluator;
import com.ericsson.ere.selectiontree.modifiers.mfo.MultiFieldOperationModel;
import com.ericsson.ere.selectiontree.modifiers.mfo.ProfileExpressionXMLReader;
import com.ericsson.ere.selectiontree.util.AvailableFieldListBuilder;
import com.ericsson.ere.selectiontree.util.ClassRepositoryHelper;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import com.ericsson.ere.selectiontree.util.PluginConfigurationHelper;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldDefinitionHelper;
import ericsson.vareditor.variable.LazyFieldDropDownVariable;
import ericsson.vareditor.variable.NotAllowedVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Node;

@Constrainable(contractClass=MultiFieldOperationProfileContract.class)
public class CollectionOfMultiFieldsProfile
extends MultiFieldOperationProfile {
    private static final String MFO_FUNCTION_SUPPORT_FEATURE = "Function_Support";
    private static final String LBL_DEST_FIELD = "Destination field";
    private static final String LBL_ENTRY_CONTROLS = "Entry Controls";
    private static final String LBL_ENTRIES = "Entries";
    private static final String LBL_ENTRY_NAME = "Entry Name";
    private static final String LBL_ENTRY_EXPRESSION = "Expression";
    private static final String LBL_ENTRY_RESULTING_EXPRESSION = "Resulting expression";
    private static final String LBL_INFO = "Info";
    private static final String MSG_NO_DEST_FIELDS = "No destination fields found";
    private static final int MAX_RESULTING_EXPRESSION_LENGTH = 500;
    private static final int MAX_DESCRIPTION_LENGTH = 300;
    private static final List<String> DEST_PARAM_TYPES;
    private static final List<String> OPERAND_PARAM_TYPES;
    private static final List<DataType> NUMERIC_DATA_TYPES;
    private static final Function[] DEFAULT_SUPPORTED_FUNCTIONS;
    private static final Operator[] NUMERIC_OPERATORS;
    private static final ExpressionToDomModelConverter EXPRESSION_TO_DOM_MODEL_CONVERTER;
    private Boolean isFunctionSupportEnabled;
    private final CollectionOfMultiFieldsModel model = new CollectionOfMultiFieldsModel();

    @Override
    public List<Variable> getVariables() {
        return this.createVariables(null);
    }

    @Override
    public List<Variable> getVariables(Node config) {
        ProfileExpressionXMLReader reader = new ProfileExpressionXMLReader(this.myClassRepository);
        CollectionOfMultiFieldsConfiguration configuration = CollectionOfMultiFieldsConfiguration.createReader(this.myClassRepository, config, (ExpressionXMLReader)reader);
        return this.createVariables(configuration);
    }

    @Override
    public String getDescription(List<Variable> variables) {
        Variable destField = VarListUtil.getVariableForName(variables, LBL_DEST_FIELD);
        String fieldName = destField.getValueString();
        if (destField instanceof NotAllowedVariable) {
            return fieldName;
        }
        Object descriptionString = this.model.getModelDescription();
        if (((String)descriptionString).length() > 300) {
            descriptionString = ((String)descriptionString).substring(0, 297) + "...";
        }
        return descriptionString;
    }

    @Override
    public Map<String, Object> getDisplayValues(Node data, Map<String, Object> prev) {
        ProfileExpressionXMLReader reader = new ProfileExpressionXMLReader(this.myClassRepository);
        CollectionOfMultiFieldsConfiguration config = CollectionOfMultiFieldsConfiguration.createReader(this.myClassRepository, data, (ExpressionXMLReader)reader);
        HashMap<String, Object> displayValues = new HashMap<String, Object>();
        displayValues.put(LBL_DEST_FIELD, config.getDestinationField());
        return displayValues;
    }

    @Override
    public String[] getTreeDefinedFieldInUse(List<Variable> profileState) {
        Collection<String> coll = this.getUsedTDFs(profileState);
        if (coll.isEmpty()) {
            return new String[0];
        }
        return coll.toArray(new String[coll.size()]);
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        List<EntryModel> entryModels = this.model.getEntries().stream().map(entry -> new EntryModel(entry.getName(), entry.getExpressionHolder().getExpression())).collect(Collectors.toList());
        CollectionOfMultiFieldsConfiguration config = CollectionOfMultiFieldsConfiguration.createWriter(this.model.getCurrentDestinationField(), entryModels, (java.util.function.Function<Expression, Node>)EXPRESSION_TO_DOM_MODEL_CONVERTER);
        PluginConfigurationHelper.writeXML(config, out, indentLevel, indentMarker);
    }

    @Override
    public boolean parameterChanged(String reference, Variable value, List<Variable> vars) {
        if (LBL_DEST_FIELD.equals(value.getLabel())) {
            return this.changeDestinationField(value);
        }
        if (LBL_ENTRY_CONTROLS.equals(value.getLabel()) && value instanceof CollectionOfMultiFieldsEntryVariable) {
            if (this.changeEntries(value)) {
                this.refreshVariables(LBL_ENTRY_EXPRESSION, this.createExpressionVariable(), vars);
                this.refreshVariables(LBL_ENTRY_RESULTING_EXPRESSION, this.createResultingExpressionVariable(), vars);
                return true;
            }
        } else if (LBL_ENTRIES.equals(value.getLabel()) && value instanceof CollectionOfMultiFieldEntriesVariable) {
            if (this.changeEntry(value)) {
                this.refreshVariables(LBL_ENTRY_EXPRESSION, this.createExpressionVariable(), vars);
                this.refreshVariables(LBL_ENTRY_RESULTING_EXPRESSION, this.createResultingExpressionVariable(), vars);
                return true;
            }
        } else if (LBL_ENTRY_NAME.equals(value.getLabel())) {
            if (this.changeEntryName(value)) {
                this.refreshVariables(LBL_ENTRY_EXPRESSION, this.createExpressionVariable(), vars);
                this.refreshVariables(LBL_ENTRY_RESULTING_EXPRESSION, this.createResultingExpressionVariable(), vars);
                return true;
            }
        } else if (LBL_ENTRY_EXPRESSION.equals(value.getLabel()) && this.isExpressionChanged(vars)) {
            this.refreshVariables(LBL_ENTRY_RESULTING_EXPRESSION, this.createResultingExpressionVariable(), vars);
            return true;
        }
        return false;
    }

    private List<Variable> createVariables(CollectionOfMultiFieldsConfiguration configuration) {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        vars.add(this.createDestinationFieldVariable(configuration));
        vars.add(this.createEntryControlsVariable());
        vars.add(this.createListOfEntriesVariable(configuration));
        vars.add(this.createEntryNameVariable());
        vars.add(this.createResultingExpressionVariable());
        vars.add(this.createExpressionVariable());
        vars.add(new ExtendedStringVariable(LBL_INFO, false));
        return vars;
    }

    private Variable createDestinationFieldVariable(CollectionOfMultiFieldsConfiguration configuration) {
        DestinationFieldFilter destinationFieldFilter = new DestinationFieldFilter();
        NoSetFieldFilter noSetFieldFilter = new NoSetFieldFilter();
        List<String> destinationFields = CollectionOfMultiFieldsUtils.getDestinationFields(this.myClassRepository, this, destinationFieldFilter, noSetFieldFilter);
        if (destinationFields.isEmpty()) {
            return new NotAllowedVariable(LBL_DEST_FIELD, MSG_NO_DEST_FIELDS);
        }
        String destinationField = configuration == null ? destinationFields.get(0) : configuration.getDestinationField();
        this.model.setCurrentDestinationField(destinationField);
        AvailableFieldListBuilder builder = AvailableFieldListBuilder.createAvailableFieldListBuilder(this.myClassRepository).withFilter(destinationFieldFilter).withFilter(noSetFieldFilter).withConstraints(this, null);
        return new LazyFieldDropDownVariable(LBL_DEST_FIELD, builder, this.model.getCurrentDestinationField());
    }

    private Variable createEntryControlsVariable() {
        return new CollectionOfMultiFieldsEntryVariable(LBL_ENTRY_CONTROLS, this.model);
    }

    private Variable createListOfEntriesVariable() {
        if (this.model.isEntitiesEmpty()) {
            this.model.createEntry(this.myClassRepository, this);
        }
        List<String> entries = this.model.getEntryNames();
        this.model.setCurrentEntryName(entries.get(0));
        return new CollectionOfMultiFieldEntriesVariable(LBL_ENTRIES, this.model);
    }

    private Variable createListOfEntriesVariable(CollectionOfMultiFieldsConfiguration configuration) {
        if (configuration != null) {
            this.model.initializeEntries(this.myClassRepository, this, configuration);
        }
        return this.createListOfEntriesVariable();
    }

    private Variable createEntryNameVariable() {
        return new CollectionOfMultiFieldEntryNameVariable(LBL_ENTRY_NAME, this.model);
    }

    private Variable createExpressionVariable() {
        CollectionOfMultiFieldsModelEntry entry = this.model.getCurrentEntry();
        String expressionDestinationField = entry.getExpressionDestinationField();
        Function[] functions = this.getSupportedFunctions();
        List<DataType> dataTypes = this.getNecessaryDataTypes(expressionDestinationField, functions);
        EntryExpressionBuilder builder = new EntryExpressionBuilder(expressionDestinationField, this, this.myClassRepository, dataTypes, Arrays.asList(NUMERIC_OPERATORS), Arrays.asList(functions));
        return new ExpressionVariable(LBL_ENTRY_EXPRESSION, entry.getExpressionHolder(), builder);
    }

    @Override
    protected Variable createResultingExpressionVariable() {
        String initialExpression = this.model.getCurrentEntry().getExpressionString();
        String formattedExpression = this.formatExpression(initialExpression);
        return new CollectionOfMultiFieldsResultExpressionVariable(LBL_ENTRY_RESULTING_EXPRESSION, formattedExpression, initialExpression, this.model);
    }

    private String formatExpression(String initialExpression) {
        if (((String)initialExpression).length() > 500) {
            initialExpression = ((String)initialExpression).substring(0, 497) + "...";
        }
        return initialExpression;
    }

    private boolean changeDestinationField(Variable destinationFieldVar) {
        this.model.setCurrentDestinationField(destinationFieldVar.getValueString());
        return true;
    }

    private boolean changeEntries(Variable entryControlsVariable) {
        CollectionOfMultiFieldsEntryVariable variable = (CollectionOfMultiFieldsEntryVariable)entryControlsVariable;
        String action = variable.getAction();
        if ("entryAdded".equals(action)) {
            this.model.createEntry(this.myClassRepository, this);
            return true;
        }
        if ("entryRemoved".equals(action)) {
            this.model.deleteCurrentEntry();
            return true;
        }
        throw new IllegalArgumentException("Unknown action from Entry Controls panel");
    }

    private boolean changeEntry(Variable entryVar) {
        CollectionOfMultiFieldEntriesVariable variable = (CollectionOfMultiFieldEntriesVariable)entryVar;
        String selectedEntry = variable.getSelectedEntry();
        String currentEntryName = this.model.getCurrentEntryName();
        if (!currentEntryName.equals(selectedEntry)) {
            this.model.setCurrentEntryName(selectedEntry);
            return true;
        }
        return false;
    }

    private boolean changeEntryName(Variable entryNameVar) {
        CollectionOfMultiFieldEntryNameVariable variable = (CollectionOfMultiFieldEntryNameVariable)entryNameVar;
        String entryName = variable.getEntryName();
        String currentEntryName = this.model.getCurrentEntryName();
        if (!currentEntryName.equals(entryName)) {
            this.model.updateEntryName(entryName);
            return true;
        }
        return false;
    }

    private boolean isExpressionChanged(List<Variable> vars) {
        Variable variable;
        CollectionOfMultiFieldsResultExpressionVariable expressionResultVar;
        String oldExpression;
        String initialExpression = this.model.getCurrentEntry().getExpressionString();
        return !initialExpression.equals(oldExpression = (expressionResultVar = (CollectionOfMultiFieldsResultExpressionVariable)(variable = VarListUtil.getVariableForName(vars, LBL_ENTRY_RESULTING_EXPRESSION))).getInitialExpression());
    }

    private void refreshVariables(String label, Variable newVariable, List<Variable> existingVariables) {
        Variable tobeRefreshed = VarListUtil.getVariableForName(existingVariables, label);
        if (tobeRefreshed != null) {
            int index = existingVariables.indexOf(tobeRefreshed);
            existingVariables.remove(index);
            existingVariables.add(index, newVariable);
        } else {
            existingVariables.add(newVariable);
        }
    }

    @Override
    protected Collection<String> getUsedTDFs(List<Variable> vars) {
        HashSet<String> tdfs = new HashSet<String>();
        tdfs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForName(vars, LBL_DEST_FIELD), this.myClassRepository, true));
        tdfs.addAll(this.findUsedTDFs(vars));
        return tdfs;
    }

    @Override
    protected List<String> findUsedTDFs(List<Variable> vars) {
        ArrayList<String> result = new ArrayList<String>();
        Expression expression = this.getCurrentExpression(vars);
        List<String> expressionFields = FieldUseEvaluator.getUsedFields(expression);
        for (String s : expressionFields) {
            if (!this.isTreeDefinedField(s)) continue;
            result.add(s);
        }
        return result;
    }

    private boolean isTreeDefinedField(String field) {
        FieldDefinition fd = this.myClassRepository.getFieldDefinitionByName(field);
        return fd != null && "INTERNAL".equals(fd.getParameterType());
    }

    @Override
    protected Function[] getSupportedFunctions() {
        return this.isFunctionSupportEnabled() ? DEFAULT_SUPPORTED_FUNCTIONS : new Function[]{};
    }

    private List<DataType> getNecessaryDataTypes(String destField, Function[] functions) {
        ArrayList<DataType> dataTypes = new ArrayList<DataType>(NUMERIC_DATA_TYPES);
        FieldDefinition fieldDefinition = this.myClassRepository.getFieldDefinitionByName(destField);
        this.addFieldDataType(fieldDefinition, dataTypes);
        this.addFunctionParameterDataTypes(functions, dataTypes);
        return dataTypes;
    }

    private void addFieldDataType(FieldDefinition fd, List<DataType> dataTypes) {
        DataType fieldType;
        if (fd != null && !dataTypes.contains(fieldType = fd.getTypedDataType())) {
            dataTypes.add(0, fieldType);
        }
    }

    private void addFunctionParameterDataTypes(Function[] functions, List<DataType> dataTypes) {
        for (Function func : functions) {
            for (FunctionParameterInfo param : func.getParameters()) {
                DataType dt = param.getType();
                if (dataTypes.contains(dt)) continue;
                dataTypes.add(dt);
            }
        }
    }

    private boolean isFunctionSupportEnabled() {
        if (this.isFunctionSupportEnabled == null) {
            this.isFunctionSupportEnabled = this.isFeatureEnabled(MFO_FUNCTION_SUPPORT_FEATURE);
        }
        return this.isFunctionSupportEnabled;
    }

    private boolean isFeatureEnabled(String feature) {
        List<String> features = ConstraintService.constrainFeatures(this, this.myClassRepository, Collections.singletonList(MFO_FUNCTION_SUPPORT_FEATURE));
        return features.contains(feature);
    }

    @Override
    protected Expression getCurrentExpression(List<Variable> variables) {
        MultiFieldOperationModel expressionHolder = (MultiFieldOperationModel)VarListUtil.getValueForName(variables, LBL_ENTRY_EXPRESSION);
        return expressionHolder == null ? null : expressionHolder.getExpression();
    }

    static {
        DEFAULT_SUPPORTED_FUNCTIONS = new Function[]{Functions.ROUND, Functions.TRUNCATE, Functions.BALANCEOF};
        NUMERIC_OPERATORS = new Operator[]{Operators.ADD, Operators.SUBTRACT, Operators.MULTIPLY, Operators.DIVIDE, Operators.INT_DIVIDE, Operators.MODULUS, Operators.POWER};
        EXPRESSION_TO_DOM_MODEL_CONVERTER = new ExpressionToDomModelConverter();
        DEST_PARAM_TYPES = new ArrayList<String>(Arrays.asList(ClassRepository.OUTPUT_TYPES));
        DEST_PARAM_TYPES.add("INTERNAL");
        OPERAND_PARAM_TYPES = new ArrayList<String>(DEST_PARAM_TYPES);
        OPERAND_PARAM_TYPES.addAll(Arrays.asList(ClassRepository.INPUT_TYPES));
        NUMERIC_DATA_TYPES = EnumSet.allOf(DataType.class).stream().filter(DataType::isNumeric).collect(Collectors.toList());
    }

    private static class EntryExpressionBuilder
    implements ExpressionVariable.ExpressionBuilder {
        private final String destField;
        private final List<Operator> allowedOperators;
        private final List<DataType> necessaryDataTypes;
        private final List<Function> supportedFunctions;
        private final AbstractFieldOrientedModifierProfile profile;
        private final ClassRepository classRepository;
        private final OperandFieldFilter operandFieldFilter;

        EntryExpressionBuilder(String destField, AbstractFieldOrientedModifierProfile profile, ClassRepository classRepository, List<DataType> necessaryDataTypes, List<Operator> allowedOperators, List<Function> supportedFunctions) {
            this.destField = destField;
            this.profile = profile;
            this.classRepository = classRepository;
            this.necessaryDataTypes = necessaryDataTypes;
            this.allowedOperators = allowedOperators;
            this.supportedFunctions = supportedFunctions;
            this.operandFieldFilter = new OperandFieldFilter(necessaryDataTypes);
        }

        @Override
        public List<String> getAllowedOperandFields() {
            return this.getConstrainedOperandFieldsForDestinationField(this.destField);
        }

        @Override
        public List<Operator> getAllowedOperators() {
            return this.allowedOperators;
        }

        @Override
        public List<DataType> getAllowedValueDataTypes() {
            return this.necessaryDataTypes;
        }

        @Override
        public ClassRepository getClassRepository() {
            return this.classRepository;
        }

        @Override
        public String getDestinationField() {
            return this.destField;
        }

        @Override
        public List<Function> getAllowedFunctions() {
            return this.supportedFunctions;
        }

        @Override
        public AvailableFieldListBuilder getAllowedOperandFieldsListBuilder() {
            ConstraintContext context = new ConstraintContext.Builder().addContext(ConstraintContextItemType.FIELD, this.destField).build();
            return AvailableFieldListBuilder.createAvailableFieldListBuilder(this.classRepository).withFilter(this.operandFieldFilter).withFilter(new ClassRepositoryHelper.VisibleFieldFilter(this.classRepository)).withFilter(new NoSetFieldFilter()).withConstraints(this.profile, context);
        }

        private List<String> getConstrainedOperandFieldsForDestinationField(String destination) {
            List<FieldDefinition> definitions = ClassRepositoryHelper.extractVisibleFieldsForField(destination, this.classRepository);
            List fieldMappableFields = CollectionOfMultiFieldsProfile.getSupportedFields(definitions, this.operandFieldFilter);
            List candidates = CollectionOfMultiFieldsProfile.getSupportedFields(fieldMappableFields, new NoSetFieldFilter());
            ConstraintContext context = new ConstraintContext.Builder().addContext(ConstraintContextItemType.FIELD, destination).build();
            List<FieldDefinition> constrained = this.profile.getConstrainedFields(candidates, context);
            return FieldDefinitionHelper.extractFieldNameList(constrained);
        }
    }

    private static class OperandFieldFilter
    implements FieldFilter {
        private final Collection<DataType> myTypes;

        OperandFieldFilter(Collection<DataType> types) {
            this.myTypes = types;
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            DataType dt = field.getTypedDataType();
            String pt = field.getParameterType();
            return OPERAND_PARAM_TYPES.contains(pt) && this.isSupportedDataType(dt);
        }

        private boolean isSupportedDataType(DataType dt) {
            return this.myTypes.contains(dt);
        }
    }

    private static class DestinationFieldFilter
    implements FieldFilter {
        private DestinationFieldFilter() {
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            DataType dt = field.getTypedDataType();
            String pt = field.getParameterType();
            return DEST_PARAM_TYPES.contains(pt) && dt.getTypeName().equals("Object");
        }
    }

    private static class NoSetFieldFilter
    implements FieldFilter {
        private NoSetFieldFilter() {
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            return !field.isSet();
        }
    }
}

