/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emm.ere.rma.custom.model;

import com.ericsson.em.emm.ere.modifiers.custom.CollectionOfMultiFieldsConfiguration;
import com.ericsson.em.emm.ere.rma.utils.CollectionOfMultiFieldsUtils;
import com.ericsson.ere.expression.Expression;
import com.ericsson.ere.expression.ExpressionFormatter;
import com.ericsson.ere.expression.InfixExpressionFormatter;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.selectiontree.FieldFilter;
import com.ericsson.ere.selectiontree.modifiers.AbstractFieldOrientedModifierProfile;
import com.ericsson.ere.selectiontree.modifiers.mfo.MultiFieldOperationModel;
import com.ericsson.ere.selectiontree.modifiers.mfo.ValueFieldCompositeOperand;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;

public final class CollectionOfMultiFieldsModelEntry {
    private static final String NEW_ENTRY_LABEL_FORMAT = "New Entry %d";
    private static final ExpressionFormatter EXPRESSION_FORMATTER = new InfixExpressionFormatter();
    private static final List<String> DEST_PARAM_TYPES = new ArrayList<String>(Arrays.asList(ClassRepository.INPUT_TYPES));
    private final String name;
    private final MultiFieldOperationModel expressionHolder;
    private final FieldDefinition fieldDefinition;

    public static CollectionOfMultiFieldsModelEntry create(ClassRepository classRepository, AbstractFieldOrientedModifierProfile profile, Supplier<Integer> suffix) {
        FieldDefinition expressionFieldDefinition = CollectionOfMultiFieldsModelEntry.createFieldDefinition(classRepository, profile);
        Operand operand = CollectionOfMultiFieldsModelEntry.createOperandForField(expressionFieldDefinition, classRepository);
        String newEntryName = String.format(NEW_ENTRY_LABEL_FORMAT, suffix.get());
        return new CollectionOfMultiFieldsModelEntry(newEntryName, operand, expressionFieldDefinition);
    }

    public static CollectionOfMultiFieldsModelEntry create(String name, CollectionOfMultiFieldsModelEntry old) {
        return new CollectionOfMultiFieldsModelEntry(name, old.expressionHolder, old.fieldDefinition);
    }

    public static CollectionOfMultiFieldsModelEntry create(ClassRepository classRepository, AbstractFieldOrientedModifierProfile profile, CollectionOfMultiFieldsConfiguration.EntryConfiguration modifier) {
        FieldDefinition expressionFieldDefinition = CollectionOfMultiFieldsModelEntry.createFieldDefinition(classRepository, profile);
        return new CollectionOfMultiFieldsModelEntry(modifier.getName(), modifier.getExpression(), expressionFieldDefinition);
    }

    private static FieldDefinition createFieldDefinition(ClassRepository classRepository, AbstractFieldOrientedModifierProfile profile) {
        List<String> destinationFields = CollectionOfMultiFieldsUtils.getDestinationFields(classRepository, profile, new EntryExpressionDestinationFieldFilter(), new NoSetFieldFilter());
        if (destinationFields.isEmpty()) {
            throw new IllegalArgumentException("There are no destination fields supported for Expression");
        }
        String selectedDestination = destinationFields.get(0);
        return classRepository.getFieldDefinitionByName(selectedDestination);
    }

    private static Operand createOperandForField(FieldDefinition expressionFieldDefinition, ClassRepository classRepository) {
        String expressionFieldName = expressionFieldDefinition.getFieldName();
        ValueFieldCompositeObject obj = new ValueFieldCompositeObject(ValueFieldCompositeObject.Mode.Field, expressionFieldName);
        ValueFieldCompositeObject index = null;
        if (expressionFieldDefinition.isComplexType()) {
            index = FieldOrientedPluginUtil.createDefaultValueFieldCompositeObjectForFieldKey(expressionFieldDefinition, classRepository);
        }
        return new ValueFieldCompositeOperand(obj, index);
    }

    private CollectionOfMultiFieldsModelEntry(String name, Operand initialOperand, FieldDefinition fieldDefinition) {
        this(name, new MultiFieldOperationModel(initialOperand), fieldDefinition);
    }

    private CollectionOfMultiFieldsModelEntry(String name, Expression expression, FieldDefinition fieldDefinition) {
        this(name, new MultiFieldOperationModel(expression), fieldDefinition);
    }

    private CollectionOfMultiFieldsModelEntry(String name, MultiFieldOperationModel expressionHolder, FieldDefinition fieldDefinition) {
        this.name = name;
        this.expressionHolder = expressionHolder;
        this.fieldDefinition = fieldDefinition;
    }

    public String getName() {
        return this.name;
    }

    public MultiFieldOperationModel getExpressionHolder() {
        return this.expressionHolder;
    }

    public String getExpressionString() {
        return this.expressionHolder.getExpression() == null ? "" : this.expressionHolder.getExpression().format(EXPRESSION_FORMATTER);
    }

    public String getExpressionDestinationField() {
        return this.fieldDefinition.getFieldName() == null ? this.fieldDefinition.getCanonicalName() : this.fieldDefinition.getFieldName();
    }

    public String toString() {
        return "{" + this.name + " = " + this.expressionHolder.toString() + "}";
    }

    static {
        DEST_PARAM_TYPES.add("INTERNAL");
    }

    private static class NoSetFieldFilter
    implements FieldFilter {
        private NoSetFieldFilter() {
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            return !field.isSet();
        }
    }

    private static class EntryExpressionDestinationFieldFilter
    implements FieldFilter {
        private EntryExpressionDestinationFieldFilter() {
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            DataType dt = field.getTypedDataType();
            String pt = field.getParameterType();
            return DEST_PARAM_TYPES.contains(pt) && (dt.isNumeric() || dt == DataType.AMOUNT);
        }
    }
}

